/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import io.papermc.paper.annotation.DoNotUse;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.command.CommandSender;
import org.bukkit.event.server.ServerCommandEvent;
import org.jspecify.annotations.Nullable;
import org.spigotmc.AsyncCatcher;

public abstract class BaseCommandBlock {
    private static final Component DEFAULT_NAME = Component.literal("@");
    private static final int NO_LAST_EXECUTION = -1;
    private long lastExecution = -1L;
    private boolean updateLastExecution = true;
    private int successCount;
    private boolean trackOutput = true;
    @Nullable Component lastOutput;
    private String command = "";
    private @Nullable Component customName;

    protected abstract CommandSender getBukkitSender(CommandSourceStack var1);

    public abstract ServerLevel getLevel();

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    public Component getLastOutput() {
        return this.lastOutput == null ? CommonComponents.EMPTY : this.lastOutput;
    }

    public void save(ValueOutput output) {
        output.putString("Command", this.command);
        output.putInt("SuccessCount", this.successCount);
        output.storeNullable("CustomName", ComponentSerialization.CODEC, this.customName);
        output.putBoolean("TrackOutput", this.trackOutput);
        if (this.trackOutput) {
            output.storeNullable("LastOutput", ComponentSerialization.CODEC, this.lastOutput);
        }
        output.putBoolean("UpdateLastExecution", this.updateLastExecution);
        if (this.updateLastExecution && this.lastExecution != -1L) {
            output.putLong("LastExecution", this.lastExecution);
        }
    }

    public void load(ValueInput input) {
        this.command = input.getStringOr("Command", "");
        this.successCount = input.getIntOr("SuccessCount", 0);
        this.setCustomName(BlockEntity.parseCustomNameSafe(input, "CustomName"));
        this.trackOutput = input.getBooleanOr("TrackOutput", true);
        this.lastOutput = this.trackOutput ? BlockEntity.parseCustomNameSafe(input, "LastOutput") : null;
        this.updateLastExecution = input.getBooleanOr("UpdateLastExecution", true);
        this.lastExecution = this.updateLastExecution ? input.getLongOr("LastExecution", -1L) : -1L;
    }

    public void setCommand(String command) {
        this.command = command;
        this.successCount = 0;
    }

    public String getCommand() {
        return this.command;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performCommand(ServerLevel level) {
        if (level.getGameTime() == this.lastExecution) {
            return false;
        }
        if ("Searge".equalsIgnoreCase(this.command)) {
            this.lastOutput = Component.literal("#itzlipofutzli");
            this.successCount = 1;
            return true;
        }
        this.successCount = 0;
        if (level.isCommandBlockEnabled() && !StringUtil.isNullOrEmpty(this.command)) {
            try {
                this.lastOutput = null;
                try (CloseableCommandBlockSource closeableCommandBlockSource = this.createSource(level);){
                    CommandSource commandSource = Objects.requireNonNullElse(closeableCommandBlockSource, CommandSource.NULL);
                    CommandSourceStack commandSourceStack = this.createCommandSourceStack(level, commandSource).withCallback((success, result) -> {
                        if (success) {
                            ++this.successCount;
                        }
                    });
                    ServerCommandEvent event = new ServerCommandEvent(commandSourceStack.getBukkitSender(), Commands.trimOptionalPrefix(this.command));
                    if (!event.callEvent()) {
                        boolean bl = true;
                        return bl;
                    }
                    level.getServer().getCommands().performPrefixedCommand(commandSourceStack, event.getCommand());
                }
            }
            catch (Throwable var7) {
                CrashReport crashReport = CrashReport.forThrowable(var7, "Executing command block");
                CrashReportCategory crashReportCategory = crashReport.addCategory("Command to be executed");
                crashReportCategory.setDetail("Command", this::getCommand);
                crashReportCategory.setDetail("Name", () -> this.getName().getString());
                throw new ReportedException(crashReport);
            }
        }
        if (this.updateLastExecution) {
            this.lastExecution = level.getGameTime();
            return true;
        }
        this.lastExecution = -1L;
        return true;
    }

    public CloseableCommandBlockSource createSource(ServerLevel level) {
        return new CloseableCommandBlockSource(level, this.trackOutput);
    }

    public Component getName() {
        return this.customName != null ? this.customName : DEFAULT_NAME;
    }

    public @Nullable Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable Component customName) {
        this.customName = customName;
    }

    public abstract void onUpdated(ServerLevel var1);

    public void setLastOutput(@Nullable Component lastOutputMessage) {
        this.lastOutput = lastOutputMessage;
    }

    public void setTrackOutput(boolean shouldTrackOutput) {
        this.trackOutput = shouldTrackOutput;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }

    public abstract CommandSourceStack createCommandSourceStack(ServerLevel var1, CommandSource var2);

    public abstract boolean isValid();

    public class CloseableCommandBlockSource
    implements CommandSource,
    AutoCloseable {
        private final ServerLevel level;
        private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT);
        private boolean closed;
        private final boolean trackOutput;

        public CloseableCommandBlockSource(ServerLevel level, boolean trackOutput) {
            this.level = level;
            this.trackOutput = trackOutput;
        }

        @DoNotUse
        @Deprecated
        public CloseableCommandBlockSource(ServerLevel level) {
            this(level, true);
        }

        @Override
        public boolean acceptsSuccess() {
            return !this.closed && this.level.getGameRules().get(GameRules.SEND_COMMAND_FEEDBACK) != false;
        }

        @Override
        public boolean acceptsFailure() {
            return this.trackOutput && !this.closed;
        }

        @Override
        public boolean shouldInformAdmins() {
            return !this.closed && this.level.getGameRules().get(GameRules.COMMAND_BLOCK_OUTPUT) != false;
        }

        @Override
        public void sendSystemMessage(Component message) {
            if (this.trackOutput && !this.closed) {
                AsyncCatcher.catchOp("sendSystemMessage to a command block");
                BaseCommandBlock.this.lastOutput = Component.literal("[" + TIME_FORMAT.format(ZonedDateTime.now()) + "] ").append(message);
                BaseCommandBlock.this.onUpdated(this.level);
            }
        }

        @Override
        public void close() throws Exception {
            this.closed = true;
        }

        @Override
        public CommandSender getBukkitSender(CommandSourceStack wrapper) {
            return BaseCommandBlock.this.getBukkitSender(wrapper);
        }
    }
}

