/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.GlobalConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class ChorusPlantBlock
extends PipeBlock {
    public static final MapCodec<ChorusPlantBlock> CODEC = ChorusPlantBlock.simpleCodec(ChorusPlantBlock::new);

    public MapCodec<ChorusPlantBlock> codec() {
        return CODEC;
    }

    protected ChorusPlantBlock(BlockBehaviour.Properties properties) {
        super(10.0f, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(UP, false)).setValue(DOWN, false));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (GlobalConfiguration.get().blockUpdates.disableChorusPlantUpdates) {
            return this.defaultBlockState();
        }
        return ChorusPlantBlock.getStateWithConnections(context.getLevel(), context.getClickedPos(), this.defaultBlockState());
    }

    public static BlockState getStateWithConnections(BlockGetter level, BlockPos pos, BlockState state) {
        BlockState blockState = level.getBlockState(pos.below());
        BlockState blockState1 = level.getBlockState(pos.above());
        BlockState blockState2 = level.getBlockState(pos.north());
        BlockState blockState3 = level.getBlockState(pos.east());
        BlockState blockState4 = level.getBlockState(pos.south());
        BlockState blockState5 = level.getBlockState(pos.west());
        Block block = state.getBlock();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.trySetValue(DOWN, blockState.is(block) || blockState.is(Blocks.CHORUS_FLOWER) || blockState.is(Blocks.END_STONE))).trySetValue(UP, blockState1.is(block) || blockState1.is(Blocks.CHORUS_FLOWER))).trySetValue(NORTH, blockState2.is(block) || blockState2.is(Blocks.CHORUS_FLOWER))).trySetValue(EAST, blockState3.is(block) || blockState3.is(Blocks.CHORUS_FLOWER))).trySetValue(SOUTH, blockState4.is(block) || blockState4.is(Blocks.CHORUS_FLOWER))).trySetValue(WEST, blockState5.is(block) || blockState5.is(Blocks.CHORUS_FLOWER));
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableChorusPlantUpdates) {
            return state;
        }
        if (!state.canSurvive(level, pos)) {
            scheduledTickAccess.scheduleTick(pos, this, 1);
            return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        boolean flag = neighborState.is(this) || neighborState.is(Blocks.CHORUS_FLOWER) || direction == Direction.DOWN && neighborState.is(Blocks.END_STONE);
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), flag);
    }

    @Override
    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableChorusPlantUpdates) {
            return;
        }
        if (!state.canSurvive(level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (GlobalConfiguration.get().blockUpdates.disableChorusPlantUpdates) {
            return true;
        }
        BlockState blockState = level.getBlockState(pos.below());
        boolean flag = !level.getBlockState(pos.above()).isAir() && !blockState.isAir();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState1 = level.getBlockState(blockPos);
            if (!blockState1.is(this)) continue;
            if (flag) {
                return false;
            }
            BlockState blockState2 = level.getBlockState(blockPos.below());
            if (!blockState2.is(this) && !blockState2.is(Blocks.END_STONE)) continue;
            return true;
        }
        return blockState.is(this) || blockState.is(Blocks.END_STONE);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(NORTH, EAST, SOUTH, WEST, UP, DOWN);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

