/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.GlobalConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.block.NotePlayEvent;
import org.jspecify.annotations.Nullable;

public class NoteBlock
extends Block {
    public static final MapCodec<NoteBlock> CODEC = NoteBlock.simpleCodec(NoteBlock::new);
    public static final EnumProperty<NoteBlockInstrument> INSTRUMENT = BlockStateProperties.NOTEBLOCK_INSTRUMENT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final IntegerProperty NOTE = BlockStateProperties.NOTE;
    public static final int NOTE_VOLUME = 3;

    public MapCodec<NoteBlock> codec() {
        return CODEC;
    }

    public NoteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(INSTRUMENT, NoteBlockInstrument.HARP)).setValue(NOTE, 0)).setValue(POWERED, false));
    }

    private BlockState setInstrument(LevelReader level, BlockPos pos, BlockState state) {
        NoteBlockInstrument noteBlockInstrument = level.getBlockState(pos.above()).instrument();
        if (noteBlockInstrument.worksAboveNoteBlock()) {
            return (BlockState)state.setValue(INSTRUMENT, noteBlockInstrument);
        }
        NoteBlockInstrument noteBlockInstrument1 = level.getBlockState(pos.below()).instrument();
        NoteBlockInstrument noteBlockInstrument2 = noteBlockInstrument1.worksAboveNoteBlock() ? NoteBlockInstrument.HARP : noteBlockInstrument1;
        return (BlockState)state.setValue(INSTRUMENT, noteBlockInstrument2);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return this.defaultBlockState();
        }
        return this.setInstrument(context.getLevel(), context.getClickedPos(), this.defaultBlockState());
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return state;
        }
        boolean flag = direction.getAxis() == Direction.Axis.Y;
        return flag ? this.setInstrument(level, pos, state) : super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return;
        }
        boolean hasNeighborSignal = level.hasNeighborSignal(pos);
        if (hasNeighborSignal != state.getValue(POWERED)) {
            if (hasNeighborSignal) {
                this.playNote(null, state, level, pos);
                state = level.getBlockState(pos);
            }
            level.setBlock(pos, (BlockState)state.setValue(POWERED, hasNeighborSignal), 3);
        }
    }

    private void playNote(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        if (state.getValue(INSTRUMENT).worksAboveNoteBlock() || level.getBlockState(pos.above()).isAir()) {
            level.blockEvent(pos, this, 0, 0);
            level.gameEvent(entity, GameEvent.NOTE_BLOCK_PLAY, pos);
        }
    }

    @Override
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return stack.is(ItemTags.NOTE_BLOCK_TOP_INSTRUMENTS) && hitResult.getDirection() == Direction.UP ? InteractionResult.PASS : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (!GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
                state = (BlockState)state.cycle(NOTE);
            }
            level.setBlock(pos, state, 3);
            this.playNote(player, state, level, pos);
            player.awardStat(Stats.TUNE_NOTEBLOCK);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.isClientSide()) {
            this.playNote(player, state, level, pos);
            player.awardStat(Stats.PLAY_NOTEBLOCK);
        }
    }

    public static float getPitchFromNote(int note) {
        return (float)Math.pow(2.0, (double)(note - 12) / 12.0);
    }

    @Override
    protected boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        Holder<SoundEvent> holder;
        float pitchFromNote;
        NoteBlockInstrument noteBlockInstrument = state.getValue(INSTRUMENT);
        NotePlayEvent event = CraftEventFactory.callNotePlayEvent(level, pos, noteBlockInstrument, state.getValue(NOTE));
        if (event.isCancelled()) {
            return false;
        }
        if (noteBlockInstrument.isTunable()) {
            byte noteValue = event.getNote().getId();
            pitchFromNote = NoteBlock.getPitchFromNote(noteValue);
            level.addParticle(ParticleTypes.NOTE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, (double)noteValue / 24.0, 0.0, 0.0);
        } else {
            pitchFromNote = 1.0f;
        }
        if (noteBlockInstrument.hasCustomSound()) {
            Identifier customSoundId = this.getCustomSoundId(level, pos);
            if (customSoundId == null) {
                return false;
            }
            holder = Holder.direct(SoundEvent.createVariableRangeEvent(customSoundId));
        } else {
            holder = CraftBlockData.toNMS(event.getInstrument(), NoteBlockInstrument.class).getSoundEvent();
        }
        level.playSeededSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, holder, SoundSource.RECORDS, 3.0f, pitchFromNote, level.random.nextLong());
        return true;
    }

    private @Nullable Identifier getCustomSoundId(Level level, BlockPos pos) {
        Identifier identifier;
        BlockEntity blockEntity = level.getBlockEntity(pos.above());
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skullBlockEntity = (SkullBlockEntity)blockEntity;
            identifier = skullBlockEntity.getNoteBlockSound();
        } else {
            identifier = null;
        }
        return identifier;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(INSTRUMENT, POWERED, NOTE);
    }
}

