/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.jspecify.annotations.Nullable;

public abstract class SignBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.column(8.0, 0.0, 16.0);
    private final WoodType type;

    protected SignBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
    }

    protected abstract MapCodec<? extends SignBlock> codec();

    @Override
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (state.getValue(WATERLOGGED).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SignBlockEntity(pos, state);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SignBlockEntity) {
            boolean flag;
            SignApplicator signApplicator;
            SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity;
            Item item = stack.getItem();
            SignApplicator signApplicator1 = item instanceof SignApplicator ? (signApplicator = (SignApplicator)((Object)item)) : null;
            boolean bl = flag = signApplicator1 != null && player.mayBuild();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (flag && !signBlockEntity.isWaxed() && !this.otherPlayerIsEditingSign(player, signBlockEntity)) {
                    boolean isFacingFrontText = signBlockEntity.isFacingFrontText(player);
                    if (signApplicator1.canApplyToSign(signBlockEntity.getText(isFacingFrontText), player) && signApplicator1.tryApplyToSign(serverLevel, signBlockEntity, isFacingFrontText, player)) {
                        signBlockEntity.executeClickCommandsIfPresent(serverLevel, player, pos, isFacingFrontText);
                        player.awardStat(Stats.ITEM_USED.get(stack.getItem()));
                        serverLevel.gameEvent(GameEvent.BLOCK_CHANGE, signBlockEntity.getBlockPos(), GameEvent.Context.of(player, signBlockEntity.getBlockState()));
                        stack.consume(1, player);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            return !flag && !signBlockEntity.isWaxed() ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                boolean isFacingFrontText = signBlockEntity.isFacingFrontText(player);
                boolean flag = signBlockEntity.executeClickCommandsIfPresent(serverLevel, player, pos, isFacingFrontText);
                if (signBlockEntity.isWaxed()) {
                    serverLevel.playSound(null, signBlockEntity.getBlockPos(), signBlockEntity.getSignInteractionFailedSoundEvent(), SoundSource.BLOCKS);
                    return InteractionResult.SUCCESS_SERVER;
                }
                if (flag) {
                    return InteractionResult.SUCCESS_SERVER;
                }
                if (!this.otherPlayerIsEditingSign(player, signBlockEntity) && player.mayBuild() && this.hasEditableText(player, signBlockEntity, isFacingFrontText)) {
                    this.openTextEdit(player, signBlockEntity, isFacingFrontText, PlayerOpenSignEvent.Cause.INTERACT);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.PASS;
            }
            Util.pauseInIde(new IllegalStateException("Expected to only call this on server"));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private boolean hasEditableText(Player player, SignBlockEntity signEntity, boolean isFrontText) {
        SignText text = signEntity.getText(isFrontText);
        return Arrays.stream(text.getMessages(player.isTextFilteringEnabled())).allMatch(line -> line.equals(CommonComponents.EMPTY) || line.getContents() instanceof PlainTextContents);
    }

    public abstract float getYRotationDegrees(BlockState var1);

    public Vec3 getSignHitboxCenterPosition(BlockState state) {
        return new Vec3(0.5, 0.5, 0.5);
    }

    @Override
    protected FluidState getFluidState(BlockState state) {
        return state.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public WoodType type() {
        return this.type;
    }

    public static WoodType getWoodType(Block block) {
        WoodType woodType = block instanceof SignBlock ? ((SignBlock)block).type() : WoodType.OAK;
        return woodType;
    }

    @Deprecated
    @DoNotUse
    public void openTextEdit(Player player, SignBlockEntity signEntity, boolean isFrontText) {
        this.openTextEdit(player, signEntity, isFrontText, PlayerOpenSignEvent.Cause.UNKNOWN);
    }

    public void openTextEdit(Player player, SignBlockEntity signEntity, boolean isFrontText, PlayerOpenSignEvent.Cause cause) {
        CraftBlock bukkitBlock;
        CraftSign bukkitSign;
        org.bukkit.entity.Player bukkitPlayer = (org.bukkit.entity.Player)player.getBukkitEntity();
        PlayerOpenSignEvent event = new PlayerOpenSignEvent(bukkitPlayer, (Sign)(bukkitSign = (CraftSign)CraftBlockStates.getBlockState(bukkitBlock = CraftBlock.at(signEntity.getLevel(), signEntity.getBlockPos()))), isFrontText ? Side.FRONT : Side.BACK, cause);
        if (!event.callEvent()) {
            return;
        }
        if (PlayerSignOpenEvent.getHandlerList().getRegisteredListeners().length > 0) {
            PlayerSignOpenEvent.Cause legacyCause;
            switch (cause) {
                default: {
                    throw new MatchException(null, null);
                }
                case PLACE: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.PLACE;
                    break;
                }
                case PLUGIN: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.PLUGIN;
                    break;
                }
                case INTERACT: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.INTERACT;
                    break;
                }
                case UNKNOWN: {
                    PlayerSignOpenEvent.Cause cause2 = legacyCause = PlayerSignOpenEvent.Cause.UNKNOWN;
                }
            }
            if (!CraftEventFactory.callPlayerSignOpenEvent(player, signEntity, isFrontText, legacyCause)) {
                return;
            }
        }
        signEntity.setAllowedPlayerEditor(player.getUUID());
        player.openTextEdit(signEntity, isFrontText);
    }

    private boolean otherPlayerIsEditingSign(Player player, SignBlockEntity signEntity) {
        UUID playerWhoMayEdit = signEntity.getPlayerWhoMayEdit();
        return playerWhoMayEdit != null && !playerWhoMayEdit.equals(player.getUUID());
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return null;
    }
}

