/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.block.TargetHitEvent;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.entity.Projectile;

public class TargetBlock
extends Block {
    public static final MapCodec<TargetBlock> CODEC = TargetBlock.simpleCodec(TargetBlock::new);
    private static final IntegerProperty OUTPUT_POWER = BlockStateProperties.POWER;
    private static final int ACTIVATION_TICKS_ARROWS = 20;
    private static final int ACTIVATION_TICKS_OTHER = 8;

    public MapCodec<TargetBlock> codec() {
        return CODEC;
    }

    public TargetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(OUTPUT_POWER, 0));
    }

    @Override
    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, net.minecraft.world.entity.projectile.Projectile projectile) {
        int i = TargetBlock.updateRedstoneOutput(level, state, hit, projectile);
    }

    private static void awardTargetHitCriteria(net.minecraft.world.entity.projectile.Projectile projectile, BlockHitResult hit, int i) {
        Entity entity = projectile.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.awardStat(Stats.TARGET_HIT);
            CriteriaTriggers.TARGET_BLOCK_HIT.trigger(serverPlayer, projectile, hit.getLocation(), i);
        }
    }

    private static int updateRedstoneOutput(LevelAccessor level, BlockState state, BlockHitResult hit, Entity projectile) {
        int redstoneStrength = TargetBlock.getRedstoneStrength(hit, hit.getLocation());
        int i = projectile instanceof AbstractArrow ? 20 : 8;
        boolean shouldAward = false;
        if (projectile instanceof net.minecraft.world.entity.projectile.Projectile) {
            CraftBlock craftBlock = CraftBlock.at(level, hit.getBlockPos());
            BlockFace blockFace = CraftBlock.notchToBlockFace(hit.getDirection());
            TargetHitEvent targetHitEvent = new TargetHitEvent((Projectile)projectile.getBukkitEntity(), (org.bukkit.block.Block)craftBlock, blockFace, redstoneStrength);
            if (targetHitEvent.callEvent()) {
                redstoneStrength = targetHitEvent.getSignalStrength();
                shouldAward = true;
            } else {
                return redstoneStrength;
            }
        }
        if (!level.getBlockTicks().hasScheduledTick(hit.getBlockPos(), state.getBlock())) {
            TargetBlock.setOutputPower(level, state, redstoneStrength, hit.getBlockPos(), i);
        }
        if (shouldAward) {
            TargetBlock.awardTargetHitCriteria((net.minecraft.world.entity.projectile.Projectile)projectile, hit, redstoneStrength);
        }
        return redstoneStrength;
    }

    private static int getRedstoneStrength(BlockHitResult hit, Vec3 hitLocation) {
        Direction direction = hit.getDirection();
        double abs = Math.abs(Mth.frac(hitLocation.x) - 0.5);
        double abs1 = Math.abs(Mth.frac(hitLocation.y) - 0.5);
        double abs2 = Math.abs(Mth.frac(hitLocation.z) - 0.5);
        Direction.Axis axis = direction.getAxis();
        double max = axis == Direction.Axis.Y ? Math.max(abs, abs2) : (axis == Direction.Axis.Z ? Math.max(abs, abs1) : Math.max(abs1, abs2));
        return Math.max(1, Mth.ceil(15.0 * Mth.clamp((0.5 - max) / 0.5, 0.0, 1.0)));
    }

    private static void setOutputPower(LevelAccessor level, BlockState state, int power, BlockPos pos, int waitTime) {
        level.setBlock(pos, (BlockState)state.setValue(OUTPUT_POWER, power), 3);
        level.scheduleTick(pos, state.getBlock(), waitTime);
    }

    @Override
    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (state.getValue(OUTPUT_POWER) != 0) {
            level.setBlock(pos, (BlockState)state.setValue(OUTPUT_POWER, 0), 3);
        }
    }

    @Override
    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return state.getValue(OUTPUT_POWER);
    }

    @Override
    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(OUTPUT_POWER);
    }

    @Override
    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!(level.isClientSide() || state.is(oldState.getBlock()) || state.getValue(OUTPUT_POWER) <= 0 || level.getBlockTicks().hasScheduledTick(pos, this))) {
            level.setBlock(pos, (BlockState)state.setValue(OUTPUT_POWER, 0), 18);
        }
    }
}

