/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.apache.commons.lang3.function.TriFunction;

public record WeatheringCopperBlocks(Block unaffected, Block exposed, Block weathered, Block oxidized, Block waxed, Block waxedExposed, Block waxedWeathered, Block waxedOxidized) {
    public static <WaxedBlock extends Block, WeatheringBlock extends Block> WeatheringCopperBlocks create(String name, TriFunction<String, Function<BlockBehaviour.Properties, Block>, BlockBehaviour.Properties, Block> register, Function<BlockBehaviour.Properties, WaxedBlock> block, BiFunction<WeatheringCopper.WeatherState, BlockBehaviour.Properties, WeatheringBlock> weatheringBlock, Function<WeatheringCopper.WeatherState, BlockBehaviour.Properties> properties) {
        return new WeatheringCopperBlocks((Block)register.apply((Object)name, properties1 -> (Block)weatheringBlock.apply(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties1), (Object)properties.apply(WeatheringCopper.WeatherState.UNAFFECTED)), (Block)register.apply((Object)("exposed_" + name), properties1 -> (Block)weatheringBlock.apply(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties1), (Object)properties.apply(WeatheringCopper.WeatherState.EXPOSED)), (Block)register.apply((Object)("weathered_" + name), properties1 -> (Block)weatheringBlock.apply(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties1), (Object)properties.apply(WeatheringCopper.WeatherState.WEATHERED)), (Block)register.apply((Object)("oxidized_" + name), properties1 -> (Block)weatheringBlock.apply(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties1), (Object)properties.apply(WeatheringCopper.WeatherState.OXIDIZED)), (Block)register.apply((Object)("waxed_" + name), block::apply, (Object)properties.apply(WeatheringCopper.WeatherState.UNAFFECTED)), (Block)register.apply((Object)("waxed_exposed_" + name), block::apply, (Object)properties.apply(WeatheringCopper.WeatherState.EXPOSED)), (Block)register.apply((Object)("waxed_weathered_" + name), block::apply, (Object)properties.apply(WeatheringCopper.WeatherState.WEATHERED)), (Block)register.apply((Object)("waxed_oxidized_" + name), block::apply, (Object)properties.apply(WeatheringCopper.WeatherState.OXIDIZED)));
    }

    public ImmutableBiMap<Block, Block> weatheringMapping() {
        return ImmutableBiMap.of((Object)this.unaffected, (Object)this.exposed, (Object)this.exposed, (Object)this.weathered, (Object)this.weathered, (Object)this.oxidized);
    }

    public ImmutableBiMap<Block, Block> waxedMapping() {
        return ImmutableBiMap.of((Object)this.unaffected, (Object)this.waxed, (Object)this.exposed, (Object)this.waxedExposed, (Object)this.weathered, (Object)this.waxedWeathered, (Object)this.oxidized, (Object)this.waxedOxidized);
    }

    public ImmutableList<Block> asList() {
        return ImmutableList.of((Object)this.unaffected, (Object)this.waxed, (Object)this.exposed, (Object)this.waxedExposed, (Object)this.weathered, (Object)this.waxedWeathered, (Object)this.oxidized, (Object)this.waxedOxidized);
    }

    public void forEach(Consumer<Block> action) {
        action.accept(this.unaffected);
        action.accept(this.exposed);
        action.accept(this.weathered);
        action.accept(this.oxidized);
        action.accept(this.waxed);
        action.accept(this.waxedExposed);
        action.accept(this.waxedWeathered);
        action.accept(this.waxedOxidized);
    }
}

