/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.block.BrewingStartEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;

public class BrewingStandBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
    public static final int FUEL_USES = 20;
    public static final int DATA_BREW_TIME = 0;
    public static final int DATA_FUEL_USES = 1;
    public static final int NUM_DATA_VALUES = 2;
    private static final short DEFAULT_BREW_TIME = 0;
    private static final byte DEFAULT_FUEL = 0;
    private static final Component DEFAULT_NAME = Component.translatable("container.brewing");
    private NonNullList<net.minecraft.world.item.ItemStack> items = NonNullList.withSize(5, net.minecraft.world.item.ItemStack.EMPTY);
    public int brewTime;
    public int recipeBrewTime = 400;
    private boolean[] lastPotionCount;
    private Item ingredient;
    public int fuel;
    protected final ContainerData dataAccess = new ContainerData(){

        @Override
        public int get(int index) {
            return switch (index) {
                case 0 -> BrewingStandBlockEntity.this.brewTime;
                case 1 -> BrewingStandBlockEntity.this.fuel;
                case 2 -> BrewingStandBlockEntity.this.recipeBrewTime;
                default -> 0;
            };
        }

        @Override
        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    BrewingStandBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    BrewingStandBlockEntity.this.fuel = value;
                    break;
                }
                case 2: {
                    BrewingStandBlockEntity.this.recipeBrewTime = value;
                }
            }
        }

        @Override
        public int getCount() {
            return 3;
        }
    };
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.items;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public BrewingStandBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityType.BREWING_STAND, pos, blockState);
    }

    @Override
    protected Component getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<net.minecraft.world.item.ItemStack> items) {
        this.items = items;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BrewingStandBlockEntity blockEntity) {
        net.minecraft.world.item.ItemStack itemStack = blockEntity.items.get(4);
        if (blockEntity.fuel <= 0 && itemStack.is(ItemTags.BREWING_FUEL)) {
            BrewingStandFuelEvent event = new BrewingStandFuelEvent((Block)CraftBlock.at(level, pos), (ItemStack)CraftItemStack.asCraftMirror(itemStack), 20);
            if (!event.callEvent()) {
                return;
            }
            blockEntity.fuel = event.getFuelPower();
            if (blockEntity.fuel > 0 && event.isConsuming()) {
                itemStack.shrink(1);
            }
            BrewingStandBlockEntity.setChanged(level, pos, state);
        }
        boolean isBrewable = BrewingStandBlockEntity.isBrewable(level.potionBrewing(), blockEntity.items);
        boolean flag = blockEntity.brewTime > 0;
        net.minecraft.world.item.ItemStack itemStack1 = blockEntity.items.get(3);
        if (flag) {
            boolean flag1;
            --blockEntity.brewTime;
            boolean bl = flag1 = blockEntity.brewTime == 0;
            if (flag1 && isBrewable) {
                BrewingStandBlockEntity.doBrew(level, pos, blockEntity.items, blockEntity);
            } else if (!isBrewable || !itemStack1.is(blockEntity.ingredient)) {
                blockEntity.brewTime = 0;
            }
            BrewingStandBlockEntity.setChanged(level, pos, state);
        } else if (isBrewable && blockEntity.fuel > 0) {
            --blockEntity.fuel;
            BrewingStartEvent event = new BrewingStartEvent((Block)CraftBlock.at(level, pos), (ItemStack)CraftItemStack.asCraftMirror(itemStack1), 400);
            event.callEvent();
            blockEntity.recipeBrewTime = event.getRecipeBrewTime();
            blockEntity.brewTime = event.getBrewingTime();
            blockEntity.ingredient = itemStack1.getItem();
            BrewingStandBlockEntity.setChanged(level, pos, state);
        }
        boolean[] potionBits = blockEntity.getPotionBits();
        if (!Arrays.equals(potionBits, blockEntity.lastPotionCount)) {
            blockEntity.lastPotionCount = potionBits;
            BlockState blockState = state;
            if (!(state.getBlock() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.HAS_BOTTLE.length; ++i) {
                blockState = (BlockState)blockState.setValue(BrewingStandBlock.HAS_BOTTLE[i], potionBits[i]);
            }
            level.setBlock(pos, blockState, 2);
        }
    }

    private boolean[] getPotionBits() {
        boolean[] flags = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (this.items.get(i).isEmpty()) continue;
            flags[i] = true;
        }
        return flags;
    }

    private static boolean isBrewable(PotionBrewing potionBrewing, NonNullList<net.minecraft.world.item.ItemStack> items) {
        net.minecraft.world.item.ItemStack itemStack = items.get(3);
        if (itemStack.isEmpty()) {
            return false;
        }
        if (!potionBrewing.isIngredient(itemStack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            net.minecraft.world.item.ItemStack itemStack1 = items.get(i);
            if (itemStack1.isEmpty() || !potionBrewing.hasMix(itemStack1, itemStack)) continue;
            return true;
        }
        return false;
    }

    private static void doBrew(Level level, BlockPos pos, NonNullList<net.minecraft.world.item.ItemStack> items, BrewingStandBlockEntity brewingStandBlockEntity) {
        net.minecraft.world.item.ItemStack itemStack = items.get(3);
        PotionBrewing potionBrewing = level.potionBrewing();
        InventoryHolder owner = brewingStandBlockEntity.getOwner();
        ArrayList<CraftItemStack> brewResults = new ArrayList<CraftItemStack>(3);
        for (int i = 0; i < 3; ++i) {
            brewResults.add(i, CraftItemStack.asCraftMirror(potionBrewing.mix(itemStack, items.get(i))));
        }
        if (owner != null) {
            BrewEvent event = new BrewEvent((Block)CraftBlock.at(level, pos), (BrewerInventory)owner.getInventory(), brewResults, brewingStandBlockEntity.fuel);
            if (!event.callEvent()) {
                return;
            }
            for (int i = 0; i < 3; ++i) {
                if (i < brewResults.size()) {
                    items.set(i, CraftItemStack.asNMSCopy((ItemStack)brewResults.get(i)));
                    continue;
                }
                items.set(i, net.minecraft.world.item.ItemStack.EMPTY);
            }
        }
        itemStack.shrink(1);
        net.minecraft.world.item.ItemStack craftingRemainder = itemStack.getItem().getCraftingRemainder();
        if (!craftingRemainder.isEmpty()) {
            if (itemStack.isEmpty()) {
                itemStack = craftingRemainder;
            } else {
                Containers.dropItemStack(level, pos.getX(), pos.getY(), pos.getZ(), craftingRemainder);
            }
        }
        items.set(3, itemStack);
        level.levelEvent(1035, pos, 0);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.items = NonNullList.withSize(this.getContainerSize(), net.minecraft.world.item.ItemStack.EMPTY);
        ContainerHelper.loadAllItems(input, this.items);
        this.brewTime = input.getShortOr("BrewTime", (short)0);
        if (this.brewTime > 0) {
            this.ingredient = this.items.get(3).getItem();
        }
        this.fuel = input.getByteOr("Fuel", (byte)0);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putShort("BrewTime", (short)this.brewTime);
        ContainerHelper.saveAllItems(output, this.items);
        output.putByte("Fuel", (byte)this.fuel);
    }

    @Override
    public boolean canPlaceItem(int index, net.minecraft.world.item.ItemStack stack) {
        PotionBrewing potionBrewing;
        PotionBrewing potionBrewing2 = potionBrewing = this.level != null ? this.level.potionBrewing() : PotionBrewing.EMPTY;
        if (index == 3) {
            return potionBrewing.isIngredient(stack);
        }
        return index == 4 ? stack.is(ItemTags.BREWING_FUEL) : (stack.is(Items.POTION) || stack.is(Items.SPLASH_POTION) || stack.is(Items.LINGERING_POTION) || stack.is(Items.GLASS_BOTTLE) || potionBrewing.isCustomInput(stack)) && this.getItem(index).isEmpty();
    }

    @Override
    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_SIDES;
    }

    @Override
    public boolean canPlaceItemThroughFace(int index, net.minecraft.world.item.ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    @Override
    public boolean canTakeItemThroughFace(int index, net.minecraft.world.item.ItemStack stack, Direction direction) {
        return index != 3 || stack.is(Items.GLASS_BOTTLE);
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new BrewingStandMenu(id, player, this, this.dataAccess);
    }
}

