/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestCommand;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FileUtil;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BeaconBeamOwner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.bukkit.event.entity.EntityRemoveEvent;

public class TestInstanceBlockEntity
extends BlockEntity
implements BeaconBeamOwner,
BoundingBoxRenderable {
    private static final Component INVALID_TEST_NAME = Component.translatable("test_instance_block.invalid_test");
    private static final List<BeaconBeamOwner.Section> BEAM_CLEARED = List.of();
    private static final List<BeaconBeamOwner.Section> BEAM_RUNNING = List.of(new BeaconBeamOwner.Section(ARGB.color(128, 128, 128)));
    private static final List<BeaconBeamOwner.Section> BEAM_SUCCESS = List.of(new BeaconBeamOwner.Section(ARGB.color(0, 255, 0)));
    private static final List<BeaconBeamOwner.Section> BEAM_REQUIRED_FAILED = List.of(new BeaconBeamOwner.Section(ARGB.color(255, 0, 0)));
    private static final List<BeaconBeamOwner.Section> BEAM_OPTIONAL_FAILED = List.of(new BeaconBeamOwner.Section(ARGB.color(255, 128, 0)));
    private static final Vec3i STRUCTURE_OFFSET = new Vec3i(0, 1, 1);
    private Data data;
    private final List<ErrorMarker> errorMarkers = new ArrayList<ErrorMarker>();

    public TestInstanceBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityType.TEST_INSTANCE_BLOCK, pos, blockState);
        this.data = new Data(Optional.empty(), Vec3i.ZERO, Rotation.NONE, false, Status.CLEARED, Optional.empty());
    }

    public void set(Data data) {
        this.data = data;
        this.setChanged();
    }

    public static Optional<Vec3i> getStructureSize(ServerLevel level, ResourceKey<GameTestInstance> testKey) {
        return TestInstanceBlockEntity.getStructureTemplate(level, testKey).map(StructureTemplate::getSize);
    }

    public BoundingBox getStructureBoundingBox() {
        BlockPos structurePos = this.getStructurePos();
        BlockPos blockPos = structurePos.offset(this.getTransformedSize()).offset(-1, -1, -1);
        return BoundingBox.fromCorners(structurePos, blockPos);
    }

    public AABB getStructureBounds() {
        return AABB.of(this.getStructureBoundingBox());
    }

    private static Optional<StructureTemplate> getStructureTemplate(ServerLevel level, ResourceKey<GameTestInstance> testKey) {
        return level.registryAccess().get(testKey).map(reference -> ((GameTestInstance)reference.value()).structure()).flatMap(identifier -> level.getStructureManager().get((Identifier)identifier));
    }

    public Optional<ResourceKey<GameTestInstance>> test() {
        return this.data.test();
    }

    public Component getTestName() {
        return this.test().map(resourceKey -> Component.literal(resourceKey.identifier().toString())).orElse(INVALID_TEST_NAME);
    }

    private Optional<Holder.Reference<GameTestInstance>> getTestHolder() {
        return this.test().flatMap(this.level.registryAccess()::get);
    }

    public boolean ignoreEntities() {
        return this.data.ignoreEntities();
    }

    public Vec3i getSize() {
        return this.data.size();
    }

    public Rotation getRotation() {
        return this.getTestHolder().map(Holder::value).map(GameTestInstance::rotation).orElse(Rotation.NONE).getRotated(this.data.rotation());
    }

    public Optional<Component> errorMessage() {
        return this.data.errorMessage();
    }

    public void setErrorMessage(Component errorMessage) {
        this.set(this.data.withError(errorMessage));
    }

    public void setSuccess() {
        this.set(this.data.withStatus(Status.FINISHED));
    }

    public void setRunning() {
        this.set(this.data.withStatus(Status.RUNNING));
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level instanceof ServerLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.read("data", Data.CODEC).ifPresent(this::set);
        this.errorMarkers.clear();
        this.errorMarkers.addAll(input.read("errors", ErrorMarker.LIST_CODEC).orElse(List.of()));
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        output.store("data", Data.CODEC, this.data);
        if (!this.errorMarkers.isEmpty()) {
            output.store("errors", ErrorMarker.LIST_CODEC, this.errorMarkers);
        }
    }

    @Override
    public BoundingBoxRenderable.Mode renderMode() {
        return BoundingBoxRenderable.Mode.BOX;
    }

    public BlockPos getStructurePos() {
        return TestInstanceBlockEntity.getStructurePos(this.getBlockPos());
    }

    public static BlockPos getStructurePos(BlockPos pos) {
        return pos.offset(STRUCTURE_OFFSET);
    }

    @Override
    public BoundingBoxRenderable.RenderableBox getRenderableBox() {
        return new BoundingBoxRenderable.RenderableBox(new BlockPos(STRUCTURE_OFFSET), this.getTransformedSize());
    }

    @Override
    public List<BeaconBeamOwner.Section> getBeamSections() {
        return switch (this.data.status().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BEAM_CLEARED;
            case 1 -> BEAM_RUNNING;
            case 2 -> this.errorMessage().isEmpty() ? BEAM_SUCCESS : (this.getTestHolder().map(Holder::value).map(GameTestInstance::required).orElse(true) != false ? BEAM_REQUIRED_FAILED : BEAM_OPTIONAL_FAILED);
        };
    }

    private Vec3i getTransformedSize() {
        Vec3i size = this.getSize();
        Rotation rotation = this.getRotation();
        boolean flag = rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90;
        int i = flag ? size.getZ() : size.getX();
        int i1 = flag ? size.getX() : size.getZ();
        return new Vec3i(i, size.getY(), i1);
    }

    public void resetTest(Consumer<Component> messageSender) {
        this.removeBarriers();
        this.clearErrorMarkers();
        boolean flag = this.placeStructure();
        if (flag) {
            messageSender.accept(Component.translatable("test_instance_block.reset_success", this.getTestName()).withStyle(ChatFormatting.GREEN));
        }
        this.set(this.data.withStatus(Status.CLEARED));
    }

    public Optional<Identifier> saveTest(Consumer<Component> messageSender) {
        Optional<Holder.Reference<GameTestInstance>> testHolder = this.getTestHolder();
        Optional<Identifier> optional = testHolder.isPresent() ? Optional.of(testHolder.get().value().structure()) : this.test().map(ResourceKey::identifier);
        if (optional.isEmpty()) {
            BlockPos blockPos = this.getBlockPos();
            messageSender.accept(Component.translatable("test_instance_block.error.unable_to_save", blockPos.getX(), blockPos.getY(), blockPos.getZ()).withStyle(ChatFormatting.RED));
            return optional;
        }
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            StructureBlockEntity.saveStructure(serverLevel, optional.get(), this.getStructurePos(), this.getSize(), this.ignoreEntities(), "", true, List.of(Blocks.AIR));
        }
        return optional;
    }

    public boolean exportTest(Consumer<Component> messageSender) {
        ServerLevel serverLevel;
        Level level;
        Optional<Identifier> optional = this.saveTest(messageSender);
        return !optional.isEmpty() && (level = this.level) instanceof ServerLevel && TestInstanceBlockEntity.export(serverLevel = (ServerLevel)level, optional.get(), messageSender);
    }

    public static boolean export(ServerLevel level, Identifier test, Consumer<Component> messageSender) {
        Path path = StructureUtils.testStructuresDir;
        Path path1 = level.getStructureManager().createAndValidatePathToGeneratedStructure(test, ".nbt");
        Path path2 = NbtToSnbt.convertStructure(CachedOutput.NO_CACHE, path1, test.getPath(), path.resolve(test.getNamespace()).resolve("structure"));
        if (path2 == null) {
            messageSender.accept(Component.literal("Failed to export " + String.valueOf(path1)).withStyle(ChatFormatting.RED));
            return true;
        }
        try {
            FileUtil.createDirectoriesSafe(path2.getParent());
        }
        catch (IOException var7) {
            messageSender.accept(Component.literal("Could not create folder " + String.valueOf(path2.getParent())).withStyle(ChatFormatting.RED));
            return true;
        }
        messageSender.accept(Component.literal("Exported " + String.valueOf(test) + " to " + String.valueOf(path2.toAbsolutePath())));
        return false;
    }

    public void runTest(Consumer<Component> messageSender) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional<Holder.Reference<GameTestInstance>> var7 = this.getTestHolder();
            BlockPos blockPos = this.getBlockPos();
            if (var7.isEmpty()) {
                messageSender.accept(Component.translatable("test_instance_block.error.no_test", blockPos.getX(), blockPos.getY(), blockPos.getZ()).withStyle(ChatFormatting.RED));
            } else if (!this.placeStructure()) {
                messageSender.accept(Component.translatable("test_instance_block.error.no_test_structure", blockPos.getX(), blockPos.getY(), blockPos.getZ()).withStyle(ChatFormatting.RED));
            } else {
                this.clearErrorMarkers();
                GameTestTicker.SINGLETON.clear();
                FailedTestTracker.forgetFailedTests();
                messageSender.accept(Component.translatable("test_instance_block.starting", var7.get().getRegisteredName()));
                GameTestInfo gameTestInfo = new GameTestInfo(var7.get(), this.data.rotation(), serverLevel, RetryOptions.noRetries());
                gameTestInfo.setTestBlockPos(blockPos);
                GameTestRunner gameTestRunner = GameTestRunner.Builder.fromInfo(List.of(gameTestInfo), serverLevel).build();
                TestCommand.trackAndStartRunner(serverLevel.getServer().createCommandSourceStack(), gameTestRunner);
            }
        }
    }

    public boolean placeStructure() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional optional = this.data.test().flatMap(resourceKey -> TestInstanceBlockEntity.getStructureTemplate(serverLevel, resourceKey));
            if (optional.isPresent()) {
                this.placeStructure(serverLevel, (StructureTemplate)optional.get());
                return true;
            }
        }
        return false;
    }

    private void placeStructure(ServerLevel level, StructureTemplate structureTemplate) {
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().setRotation(this.getRotation()).setIgnoreEntities(this.data.ignoreEntities()).setKnownShape(true);
        BlockPos startCorner = this.getStartCorner();
        this.forceLoadChunks();
        StructureUtils.clearSpaceForStructure(this.getStructureBoundingBox(), level);
        this.removeEntities();
        structureTemplate.placeInWorld(level, startCorner, startCorner, structurePlaceSettings, level.getRandom(), 818);
    }

    private void removeEntities() {
        this.level.getEntities(null, this.getStructureBounds()).stream().filter(entity -> !(entity instanceof Player)).forEach(entity -> entity.discard(EntityRemoveEvent.Cause.DISCARD));
    }

    private void forceLoadChunks() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getStructureBoundingBox().intersectingChunks().forEach(pos -> serverLevel.setChunkForced(pos.x, pos.z, true));
        }
    }

    public BlockPos getStartCorner() {
        Vec3i size = this.getSize();
        Rotation rotation = this.getRotation();
        BlockPos structurePos = this.getStructurePos();
        return switch (rotation) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> structurePos;
            case Rotation.CLOCKWISE_90 -> structurePos.offset(size.getZ() - 1, 0, 0);
            case Rotation.CLOCKWISE_180 -> structurePos.offset(size.getX() - 1, 0, size.getZ() - 1);
            case Rotation.COUNTERCLOCKWISE_90 -> structurePos.offset(0, 0, size.getX() - 1);
        };
    }

    public void encaseStructure() {
        this.processStructureBoundary(pos -> {
            if (!this.level.getBlockState((BlockPos)pos).is(Blocks.TEST_INSTANCE_BLOCK)) {
                this.level.setBlockAndUpdate((BlockPos)pos, Blocks.BARRIER.defaultBlockState());
            }
        });
    }

    public void removeBarriers() {
        this.processStructureBoundary(pos -> {
            if (this.level.getBlockState((BlockPos)pos).is(Blocks.BARRIER)) {
                this.level.setBlockAndUpdate((BlockPos)pos, Blocks.AIR.defaultBlockState());
            }
        });
    }

    public void processStructureBoundary(Consumer<BlockPos> processor) {
        AABB structureBounds = this.getStructureBounds();
        boolean flag = this.getTestHolder().map(reference -> ((GameTestInstance)reference.value()).skyAccess()).orElse(false) == false;
        BlockPos blockPos = BlockPos.containing(structureBounds.minX, structureBounds.minY, structureBounds.minZ).offset(-1, -1, -1);
        BlockPos blockPos1 = BlockPos.containing(structureBounds.maxX, structureBounds.maxY, structureBounds.maxZ);
        BlockPos.betweenClosedStream(blockPos, blockPos1).forEach(blockPos2 -> {
            boolean flag2;
            boolean flag1 = blockPos2.getX() == blockPos.getX() || blockPos2.getX() == blockPos1.getX() || blockPos2.getZ() == blockPos.getZ() || blockPos2.getZ() == blockPos1.getZ() || blockPos2.getY() == blockPos.getY();
            boolean bl = flag2 = blockPos2.getY() == blockPos1.getY();
            if (flag1 || flag2 && flag) {
                processor.accept((BlockPos)blockPos2);
            }
        });
    }

    public void markError(BlockPos pos, Component text) {
        this.errorMarkers.add(new ErrorMarker(pos, text));
        this.setChanged();
    }

    public void clearErrorMarkers() {
        if (!this.errorMarkers.isEmpty()) {
            this.errorMarkers.clear();
            this.setChanged();
        }
    }

    public List<ErrorMarker> getErrorMarkers() {
        return this.errorMarkers;
    }

    public record Data(Optional<ResourceKey<GameTestInstance>> test, Vec3i size, Rotation rotation, boolean ignoreEntities, Status status, Optional<Component> errorMessage) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec(Registries.TEST_INSTANCE).optionalFieldOf("test").forGetter(Data::test), (App)Vec3i.CODEC.fieldOf("size").forGetter(Data::size), (App)Rotation.CODEC.fieldOf("rotation").forGetter(Data::rotation), (App)Codec.BOOL.fieldOf("ignore_entities").forGetter(Data::ignoreEntities), (App)Status.CODEC.fieldOf("status").forGetter(Data::status), (App)ComponentSerialization.CODEC.optionalFieldOf("error_message").forGetter(Data::errorMessage)).apply((Applicative)instance, Data::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ResourceKey.streamCodec(Registries.TEST_INSTANCE)), Data::test, Vec3i.STREAM_CODEC, Data::size, Rotation.STREAM_CODEC, Data::rotation, ByteBufCodecs.BOOL, Data::ignoreEntities, Status.STREAM_CODEC, Data::status, ByteBufCodecs.optional(ComponentSerialization.STREAM_CODEC), Data::errorMessage, Data::new);

        public Data withSize(Vec3i size) {
            return new Data(this.test, size, this.rotation, this.ignoreEntities, this.status, this.errorMessage);
        }

        public Data withStatus(Status status) {
            return new Data(this.test, this.size, this.rotation, this.ignoreEntities, status, Optional.empty());
        }

        public Data withError(Component error) {
            return new Data(this.test, this.size, this.rotation, this.ignoreEntities, Status.FINISHED, Optional.of(error));
        }
    }

    public static enum Status implements StringRepresentable
    {
        CLEARED("cleared", 0),
        RUNNING("running", 1),
        FINISHED("finished", 2);

        private static final IntFunction<Status> ID_MAP;
        public static final Codec<Status> CODEC;
        public static final StreamCodec<ByteBuf, Status> STREAM_CODEC;
        private final String id;
        private final int index;

        private Status(String id, int index) {
            this.id = id;
            this.index = index;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        public static Status byIndex(int index) {
            return ID_MAP.apply(index);
        }

        static {
            ID_MAP = ByIdMap.continuous(status -> status.index, Status.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(Status::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(Status::byIndex, status -> status.index);
        }
    }

    public record ErrorMarker(BlockPos pos, Component text) {
        public static final Codec<ErrorMarker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(ErrorMarker::pos), (App)ComponentSerialization.CODEC.fieldOf("text").forGetter(ErrorMarker::text)).apply((Applicative)instance, ErrorMarker::new));
        public static final Codec<List<ErrorMarker>> LIST_CODEC = CODEC.listOf();
    }
}

