/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public class BlockPatternBuilder {
    private final List<String[]> pattern = Lists.newArrayList();
    private final Map<Character, Predicate<@Nullable BlockInWorld>> lookup = Maps.newHashMap();
    private int height;
    private int width;
    private final CharSet unknownCharacters = new CharOpenHashSet();

    private BlockPatternBuilder() {
        this.lookup.put(Character.valueOf(' '), blockInWorld -> true);
    }

    public BlockPatternBuilder aisle(String ... aisle) {
        if (!ArrayUtils.isEmpty((Object[])aisle) && !StringUtils.isEmpty((CharSequence)aisle[0])) {
            if (this.pattern.isEmpty()) {
                this.height = aisle.length;
                this.width = aisle[0].length();
            }
            if (aisle.length != this.height) {
                throw new IllegalArgumentException("Expected aisle with height of " + this.height + ", but was given one with a height of " + aisle.length + ")");
            }
            for (String string : aisle) {
                if (string.length() != this.width) {
                    throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.width + ", found one with " + string.length() + ")");
                }
                for (char c : string.toCharArray()) {
                    if (this.lookup.containsKey(Character.valueOf(c))) continue;
                    this.unknownCharacters.add(c);
                }
            }
            this.pattern.add(aisle);
            return this;
        }
        throw new IllegalArgumentException("Empty pattern for aisle");
    }

    public static BlockPatternBuilder start() {
        return new BlockPatternBuilder();
    }

    public BlockPatternBuilder where(char symbol, Predicate<@Nullable BlockInWorld> blockMatcher) {
        this.lookup.put(Character.valueOf(symbol), blockMatcher);
        this.unknownCharacters.remove(symbol);
        return this;
    }

    public BlockPattern build() {
        return new BlockPattern(this.createPattern());
    }

    private Predicate<BlockInWorld>[][][] createPattern() {
        if (!this.unknownCharacters.isEmpty()) {
            throw new IllegalStateException("Predicates for character(s) " + String.valueOf(this.unknownCharacters) + " are missing");
        }
        Predicate[][][] predicates = (Predicate[][][])Array.newInstance(Predicate.class, this.pattern.size(), this.height, this.width);
        for (int i = 0; i < this.pattern.size(); ++i) {
            for (int i1 = 0; i1 < this.height; ++i1) {
                for (int i2 = 0; i2 < this.width; ++i2) {
                    predicates[i][i1][i2] = this.lookup.get(Character.valueOf(this.pattern.get(i)[i1].charAt(i2)));
                }
            }
        }
        return predicates;
    }
}

