/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.world.StructuresLocateEvent;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.FeatureCountTracker;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.RandomSourceWrapper;
import org.bukkit.event.Event;
import org.bukkit.event.world.AsyncStructureSpawnEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.generator.structure.Structure;
import org.jspecify.annotations.Nullable;
import org.spigotmc.SpigotWorldConfig;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> CODEC = BuiltInRegistries.CHUNK_GENERATOR.byNameCodec().dispatchStable(ChunkGenerator::codec, Function.identity());
    protected final BiomeSource biomeSource;
    private final Supplier<List<FeatureSorter.StepFeatureData>> featuresPerStep;
    public final Function<Holder<Biome>, BiomeGenerationSettings> generationSettingsGetter;

    public ChunkGenerator(BiomeSource biomeSource) {
        this(biomeSource, biome -> ((Biome)biome.value()).getGenerationSettings());
    }

    public ChunkGenerator(BiomeSource biomeSource, Function<Holder<Biome>, BiomeGenerationSettings> generationSettingsGetter) {
        this.biomeSource = biomeSource;
        this.generationSettingsGetter = generationSettingsGetter;
        this.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)generationSettingsGetter.apply((Holder<Biome>)biome)).features(), true));
    }

    public void validate() {
        this.featuresPerStep.get();
    }

    protected abstract MapCodec<? extends ChunkGenerator> codec();

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> structureSetLookup, RandomState randomState, long seed, SpigotWorldConfig conf) {
        return ChunkGeneratorStructureState.createForNormal(randomState, seed, this.biomeSource, structureSetLookup, conf);
    }

    public Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> getTypeNameForDataFixer() {
        return BuiltInRegistries.CHUNK_GENERATOR.getResourceKey(this.codec());
    }

    public CompletableFuture<ChunkAccess> createBiomes(RandomState randomState, Blender blender, StructureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.supplyAsync(() -> {
            chunk.fillBiomesFromNoise(this.biomeSource, randomState.sampler());
            return chunk;
        }, Runnable::run);
    }

    public abstract void applyCarvers(WorldGenRegion var1, long var2, RandomState var4, BiomeManager var5, StructureManager var6, ChunkAccess var7);

    public @Nullable Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> findNearestMapStructure(ServerLevel level, HolderSet<net.minecraft.world.level.levelgen.structure.Structure> structure, BlockPos pos, int radius, boolean skipKnownStructures) {
        if (SharedConstants.DEBUG_DISABLE_FEATURES) {
            return null;
        }
        CraftWorld bukkitWorld = level.getWorld();
        Location origin = CraftLocation.toBukkit((Vec3i)pos, (Level)level);
        List<Structure> apiStructures = structure.stream().map(CraftStructure::minecraftHolderToBukkit).toList();
        if (!apiStructures.isEmpty()) {
            StructuresLocateEvent event = new StructuresLocateEvent((World)bukkitWorld, origin, apiStructures, radius, skipKnownStructures);
            if (!event.callEvent()) {
                return null;
            }
            if (event.getResult() != null) {
                return Pair.of((Object)MCUtil.toBlockPos(event.getResult().pos()), level.registryAccess().lookupOrThrow(Registries.STRUCTURE).wrapAsHolder(CraftStructure.bukkitToMinecraft(event.getResult().structure())));
            }
            pos = CraftLocation.toBlockPosition(event.getOrigin());
            radius = event.getRadius();
            skipKnownStructures = event.shouldFindUnexplored();
            structure = HolderSet.direct(api -> level.registryAccess().lookupOrThrow(Registries.STRUCTURE).wrapAsHolder(CraftStructure.bukkitToMinecraft(api)), event.getStructures());
        }
        ChunkGeneratorStructureState generatorState = level.getChunkSource().getGeneratorState();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Holder holder : structure) {
            for (StructurePlacement structurePlacement : generatorState.getPlacementsForStructure(holder)) {
                map.computeIfAbsent(structurePlacement, key -> new ObjectArraySet()).add(holder);
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair = null;
        double d = Double.MAX_VALUE;
        StructureManager structureManager = level.structureManager();
        ArrayList list = new ArrayList(map.size());
        for (Map.Entry entry : map.entrySet()) {
            StructurePlacement structurePlacement1 = (StructurePlacement)entry.getKey();
            if (structurePlacement1 instanceof ConcentricRingsStructurePlacement) {
                BlockPos blockPos;
                double d1;
                ConcentricRingsStructurePlacement concentricRingsStructurePlacement = (ConcentricRingsStructurePlacement)structurePlacement1;
                Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> nearestGeneratedStructure = this.getNearestGeneratedStructure((Set)entry.getValue(), level, structureManager, pos, skipKnownStructures, concentricRingsStructurePlacement);
                if (nearestGeneratedStructure == null || !((d1 = pos.distSqr(blockPos = (BlockPos)nearestGeneratedStructure.getFirst())) < d)) continue;
                d = d1;
                pair = nearestGeneratedStructure;
                continue;
            }
            if (!(structurePlacement1 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int sectionPosX = SectionPos.blockToSectionCoord(pos.getX());
            int sectionPosZ = SectionPos.blockToSectionCoord(pos.getZ());
            for (int i = 0; i <= radius; ++i) {
                boolean flag = false;
                for (Map.Entry entry : list) {
                    RandomSpreadStructurePlacement randomSpreadStructurePlacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> nearestGeneratedStructure1 = ChunkGenerator.getNearestGeneratedStructure((Set)entry.getValue(), level, structureManager, sectionPosX, sectionPosZ, i, skipKnownStructures, generatorState.getLevelSeed(), randomSpreadStructurePlacement);
                    if (nearestGeneratedStructure1 == null) continue;
                    flag = true;
                    double d2 = pos.distSqr((Vec3i)nearestGeneratedStructure1.getFirst());
                    if (!(d2 < d)) continue;
                    d = d2;
                    pair = nearestGeneratedStructure1;
                }
                if (!flag) continue;
                return pair;
            }
        }
        return pair;
    }

    private @Nullable Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> getNearestGeneratedStructure(Set<Holder<net.minecraft.world.level.levelgen.structure.Structure>> structureHoldersSet, ServerLevel level, StructureManager structureManager, BlockPos pos, boolean skipKnownStructures, ConcentricRingsStructurePlacement placement) {
        List<ChunkPos> ringPositionsFor = level.getChunkSource().getGeneratorState().getRingPositionsFor(placement);
        if (ringPositionsFor == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair = null;
        double d = Double.MAX_VALUE;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (ChunkPos chunkPos : ringPositionsFor) {
            Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> structureGeneratingAt;
            if (!level.paperConfig().environment.locateStructuresOutsideWorldBorder && !level.getWorldBorder().isChunkInBounds(chunkPos.x, chunkPos.z)) continue;
            mutableBlockPos.set(SectionPos.sectionToBlockCoord(chunkPos.x, 8), 32, SectionPos.sectionToBlockCoord(chunkPos.z, 8));
            double d1 = mutableBlockPos.distSqr(pos);
            boolean flag = pair == null || d1 < d;
            if (!flag || (structureGeneratingAt = ChunkGenerator.getStructureGeneratingAt(structureHoldersSet, level, structureManager, skipKnownStructures, placement, chunkPos)) == null) continue;
            pair = structureGeneratingAt;
            d = d1;
        }
        return pair;
    }

    private static @Nullable Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> getNearestGeneratedStructure(Set<Holder<net.minecraft.world.level.levelgen.structure.Structure>> structureHoldersSet, LevelReader level, StructureManager structureManager, int x, int y, int z, boolean skipKnownStructures, long seed, RandomSpreadStructurePlacement spreadPlacement) {
        int spacing = spreadPlacement.spacing();
        for (int i = -z; i <= z; ++i) {
            boolean flag;
            int radius = z;
            boolean onBorderAlongZAxis = flag = i == -z || i == z;
            for (int i1 = -radius; i1 <= radius; i1 += onBorderAlongZAxis ? 1 : radius * 2) {
                int i2 = x + spacing * i;
                int i3 = y + spacing * i1;
                ChunkPos potentialStructureChunk = spreadPlacement.getPotentialStructureChunk(seed, i2, i3);
                Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> structureGeneratingAt = ChunkGenerator.getStructureGeneratingAt(structureHoldersSet, level, structureManager, skipKnownStructures, spreadPlacement, potentialStructureChunk);
                if (structureGeneratingAt == null) continue;
                return structureGeneratingAt;
            }
        }
        return null;
    }

    private static @Nullable Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> getStructureGeneratingAt(Set<Holder<net.minecraft.world.level.levelgen.structure.Structure>> structureHoldersSet, LevelReader level, StructureManager structureManager, boolean skipKnownStructures, StructurePlacement placement, ChunkPos chunkPos) {
        for (Holder<net.minecraft.world.level.levelgen.structure.Structure> holder : structureHoldersSet) {
            StructureCheckResult structureCheckResult = structureManager.checkStructurePresence(chunkPos, holder.value(), placement, skipKnownStructures);
            if (structureCheckResult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!skipKnownStructures && structureCheckResult == StructureCheckResult.START_PRESENT) {
                return Pair.of((Object)placement.getLocatePos(chunkPos), holder);
            }
            ChunkAccess chunk = level.moonrise$syncLoadNonFull(chunkPos.x, chunkPos.z, ChunkStatus.STRUCTURE_STARTS);
            StructureStart startForStructure = structureManager.getStartForStructure(SectionPos.bottomOf(chunk), holder.value(), chunk);
            if (startForStructure == null || !startForStructure.isValid() || skipKnownStructures && !ChunkGenerator.tryAddReference(structureManager, startForStructure)) continue;
            return Pair.of((Object)placement.getLocatePos(startForStructure.getChunkPos()), holder);
        }
        return null;
    }

    private static boolean tryAddReference(StructureManager structureManager, StructureStart structureStart) {
        if (structureStart.canBeReferenced()) {
            structureManager.addReference(structureStart);
            return true;
        }
        return false;
    }

    public void addVanillaDecorations(WorldGenLevel level, ChunkAccess chunk, StructureManager structureManager) {
        ChunkPos pos = chunk.getPos();
        if (!SharedConstants.debugVoidTerrain(pos)) {
            SectionPos sectionPos = SectionPos.of(pos, level.getMinSectionY());
            BlockPos blockPos = sectionPos.origin();
            HolderLookup.RegistryLookup registry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            Map<Integer, List<net.minecraft.world.level.levelgen.structure.Structure>> map = registry.stream().collect(Collectors.groupingBy(structure1 -> structure1.step().ordinal()));
            List<FeatureSorter.StepFeatureData> list = this.featuresPerStep.get();
            WorldgenRandom worldgenRandom = new WorldgenRandom(new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
            long l = worldgenRandom.setDecorationSeed(level.getSeed(), blockPos.getX(), blockPos.getZ());
            ObjectArraySet set = new ObjectArraySet();
            ChunkPos.rangeClosed(sectionPos.chunk(), 1).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$7(level, (Set)set, arg_0));
            set.retainAll(this.biomeSource.possibleBiomes());
            int size = list.size();
            try {
                HolderLookup.RegistryLookup registry1 = level.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE);
                int max = Math.max(GenerationStep.Decoration.values().length, size);
                for (int i = 0; i < max; ++i) {
                    int i1 = 0;
                    if (structureManager.shouldGenerateStructures()) {
                        for (net.minecraft.world.level.levelgen.structure.Structure structure : map.getOrDefault(i, Collections.emptyList())) {
                            worldgenRandom.setFeatureSeed(l, i1, i);
                            Supplier<String> supplier = () -> ChunkGenerator.lambda$addVanillaDecorations$8((Registry)registry, structure);
                            try {
                                level.setCurrentlyGenerating(supplier);
                                structureManager.startsForStructure(sectionPos, structure).forEach(structureStart -> structureStart.placeInChunk(level, structureManager, this, worldgenRandom, ChunkGenerator.getWritableArea(chunk), pos));
                            }
                            catch (Exception var29) {
                                CrashReport crashReport = CrashReport.forThrowable(var29, "Feature placement");
                                crashReport.addCategory("Feature").setDetail("Description", supplier::get);
                                throw new ReportedException(crashReport);
                            }
                            ++i1;
                        }
                    }
                    if (i >= size) continue;
                    IntArraySet set1 = new IntArraySet();
                    for (Holder holder : set) {
                        List<HolderSet<PlacedFeature>> list2 = this.generationSettingsGetter.apply(holder).features();
                        if (i >= list2.size()) continue;
                        HolderSet<PlacedFeature> holderSet = list2.get(i);
                        FeatureSorter.StepFeatureData stepFeatureData = list.get(i);
                        holderSet.stream().map(Holder::value).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$10((IntSet)set1, stepFeatureData, arg_0));
                    }
                    int size1 = set1.size();
                    int[] ints = set1.toIntArray();
                    Arrays.sort(ints);
                    FeatureSorter.StepFeatureData stepFeatureData1 = list.get(i);
                    for (int i2 = 0; i2 < size1; ++i2) {
                        int i3 = ints[i2];
                        PlacedFeature placedFeature = stepFeatureData1.features().get(i3);
                        Supplier<String> supplier1 = () -> ChunkGenerator.lambda$addVanillaDecorations$11((Registry)registry1, placedFeature);
                        long featurePopulationSeed = l;
                        long configFeatureSeed = level.getMinecraftWorld().paperConfig().featureSeeds.features.getLong(placedFeature.feature());
                        if (configFeatureSeed != -1L) {
                            featurePopulationSeed = worldgenRandom.setDecorationSeed(configFeatureSeed, blockPos.getX(), blockPos.getZ());
                        }
                        worldgenRandom.setFeatureSeed(featurePopulationSeed, i3, i);
                        try {
                            level.setCurrentlyGenerating(supplier1);
                            placedFeature.placeWithBiomeCheck(level, this, worldgenRandom, blockPos);
                            continue;
                        }
                        catch (Exception var30) {
                            CrashReport crashReport1 = CrashReport.forThrowable(var30, "Feature placement");
                            crashReport1.addCategory("Feature").setDetail("Description", supplier1::get);
                            throw new ReportedException(crashReport1);
                        }
                    }
                }
                level.setCurrentlyGenerating(null);
                if (SharedConstants.DEBUG_FEATURE_COUNT) {
                    FeatureCountTracker.chunkDecorated(level.getLevel());
                }
            }
            catch (Exception var31) {
                CrashReport crashReport2 = CrashReport.forThrowable(var31, "Biome decoration");
                crashReport2.addCategory("Generation").setDetail("CenterX", pos.x).setDetail("CenterZ", pos.z).setDetail("Decoration Seed", l);
                throw new ReportedException(crashReport2);
            }
        }
    }

    public void applyBiomeDecoration(WorldGenLevel level, ChunkAccess chunk, StructureManager structureManager) {
        this.applyBiomeDecoration(level, chunk, structureManager, true);
    }

    public void applyBiomeDecoration(WorldGenLevel level, ChunkAccess chunk, StructureManager structureManager, boolean addVanillaDecorations) {
        CraftWorld world;
        if (addVanillaDecorations) {
            this.addVanillaDecorations(level, chunk, structureManager);
        }
        if (!(world = level.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(level, chunk.getPos());
            int x = chunk.getPos().x;
            int z = chunk.getPos().z;
            for (BlockPopulator populator : world.getPopulators()) {
                WorldgenRandom seededrandom = new WorldgenRandom(new LegacyRandomSource(level.getSeed()));
                seededrandom.setDecorationSeed(level.getSeed(), x, z);
                populator.populate((WorldInfo)world, (Random)new RandomSourceWrapper.RandomWrapper(seededrandom), x, z, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    private static BoundingBox getWritableArea(ChunkAccess chunk) {
        ChunkPos pos = chunk.getPos();
        int minBlockX = pos.getMinBlockX();
        int minBlockZ = pos.getMinBlockZ();
        LevelHeightAccessor heightAccessorForGeneration = chunk.getHeightAccessorForGeneration();
        int i = heightAccessorForGeneration.getMinY() + 1;
        int maxY = heightAccessorForGeneration.getMaxY();
        return new BoundingBox(minBlockX, i, minBlockZ, minBlockX + 15, maxY, minBlockZ + 15);
    }

    public abstract void buildSurface(WorldGenRegion var1, StructureManager var2, RandomState var3, ChunkAccess var4);

    public abstract void spawnOriginalMobs(WorldGenRegion var1);

    public int getSpawnHeight(LevelHeightAccessor level) {
        return 64;
    }

    public BiomeSource getBiomeSource() {
        return this.biomeSource;
    }

    public abstract int getGenDepth();

    public WeightedList<MobSpawnSettings.SpawnerData> getMobsAt(Holder<Biome> biome, StructureManager structureManager, MobCategory category, BlockPos pos) {
        Map<net.minecraft.world.level.levelgen.structure.Structure, LongSet> allStructuresAt = structureManager.getAllStructuresAt(pos);
        for (Map.Entry<net.minecraft.world.level.levelgen.structure.Structure, LongSet> entry : allStructuresAt.entrySet()) {
            net.minecraft.world.level.levelgen.structure.Structure structure = entry.getKey();
            StructureSpawnOverride structureSpawnOverride = structure.spawnOverrides().get(category);
            if (structureSpawnOverride == null) continue;
            MutableBoolean mutableBoolean = new MutableBoolean(false);
            Predicate<StructureStart> predicate = structureSpawnOverride.boundingBox() == StructureSpawnOverride.BoundingBoxType.PIECE ? structureStart -> structureManager.structureHasPieceAt(pos, (StructureStart)structureStart) : structureStart -> structureStart.getBoundingBox().isInside(pos);
            structureManager.fillStartsForStructure(structure, entry.getValue(), structureStart -> {
                if (mutableBoolean.isFalse() && predicate.test((StructureStart)structureStart)) {
                    mutableBoolean.setTrue();
                }
            });
            if (!mutableBoolean.isTrue()) continue;
            return structureSpawnOverride.spawns();
        }
        return biome.value().getMobSettings().getMobs(category);
    }

    public void createStructures(RegistryAccess registryAccess, ChunkGeneratorStructureState structureState, StructureManager structureManager, ChunkAccess chunk, StructureTemplateManager structureTemplateManager, ResourceKey<Level> level) {
        if (!SharedConstants.DEBUG_DISABLE_STRUCTURES) {
            ChunkPos pos = chunk.getPos();
            SectionPos sectionPos = SectionPos.bottomOf(chunk);
            RandomState randomState = structureState.randomState();
            structureState.possibleStructureSets().forEach(structures -> {
                ResourceKey<StructureSet> resourceKey;
                StructurePlacement structurePlacement = ((StructureSet)structures.value()).placement();
                List<StructureSet.StructureSelectionEntry> list = ((StructureSet)structures.value()).structures();
                for (StructureSet.StructureSelectionEntry structureSelectionEntry : list) {
                    StructureStart startForStructure = structureManager.getStartForStructure(sectionPos, structureSelectionEntry.structure().value(), chunk);
                    if (startForStructure == null || !startForStructure.isValid()) continue;
                    return;
                }
                int n = pos.x;
                int n2 = pos.z;
                if (structurePlacement instanceof ChunkGeneratorStructureState.KeyedRandomSpreadStructurePlacement) {
                    ChunkGeneratorStructureState.KeyedRandomSpreadStructurePlacement keyed = (ChunkGeneratorStructureState.KeyedRandomSpreadStructurePlacement)structurePlacement;
                    resourceKey = keyed.key;
                } else {
                    resourceKey = null;
                }
                if (structurePlacement.isStructureChunk(structureState, n, n2, resourceKey)) {
                    if (list.size() == 1) {
                        this.tryGenerateStructure(list.get(0), structureManager, registryAccess, randomState, structureTemplateManager, structureState.getLevelSeed(), chunk, pos, sectionPos, level);
                    } else {
                        ArrayList<StructureSet.StructureSelectionEntry> list1 = new ArrayList<StructureSet.StructureSelectionEntry>(list.size());
                        list1.addAll(list);
                        WorldgenRandom worldgenRandom = new WorldgenRandom(new LegacyRandomSource(0L));
                        worldgenRandom.setLargeFeatureSeed(structureState.getLevelSeed(), pos.x, pos.z);
                        int i = 0;
                        for (StructureSet.StructureSelectionEntry structureSelectionEntry1 : list1) {
                            i += structureSelectionEntry1.weight();
                        }
                        while (!list1.isEmpty()) {
                            StructureSet.StructureSelectionEntry structureSelectionEntry2;
                            int randomInt = worldgenRandom.nextInt(i);
                            int i1 = 0;
                            Iterator iterator = list1.iterator();
                            while (iterator.hasNext() && (randomInt -= (structureSelectionEntry2 = (StructureSet.StructureSelectionEntry)iterator.next()).weight()) >= 0) {
                                ++i1;
                            }
                            StructureSet.StructureSelectionEntry structureSelectionEntry3 = (StructureSet.StructureSelectionEntry)list1.get(i1);
                            if (this.tryGenerateStructure(structureSelectionEntry3, structureManager, registryAccess, randomState, structureTemplateManager, structureState.getLevelSeed(), chunk, pos, sectionPos, level)) {
                                return;
                            }
                            list1.remove(i1);
                            i -= structureSelectionEntry3.weight();
                        }
                    }
                }
            });
        }
    }

    private boolean tryGenerateStructure(StructureSet.StructureSelectionEntry structureSelectionEntry, StructureManager structureManager, RegistryAccess registryAccess, RandomState random, StructureTemplateManager structureTemplateManager, long seed, ChunkAccess chunk, ChunkPos chunkPos, SectionPos sectionPos, ResourceKey<Level> level) {
        net.minecraft.world.level.levelgen.structure.Structure structure = structureSelectionEntry.structure().value();
        int i = ChunkGenerator.fetchReferences(structureManager, chunk, sectionPos, structure);
        HolderSet<Biome> holderSet = structure.biomes();
        Predicate<Holder<Biome>> predicate = holderSet::contains;
        StructureStart structureStart = structure.generate(structureSelectionEntry.structure(), level, registryAccess, this, this.biomeSource, random, structureTemplateManager, seed, chunkPos, i, chunk, predicate);
        if (structureStart.isValid()) {
            BoundingBox box = structureStart.getBoundingBox();
            AsyncStructureSpawnEvent event = new AsyncStructureSpawnEvent((World)structureManager.level.getMinecraftWorld().getWorld(), CraftStructure.minecraftToBukkit(structure), new org.bukkit.util.BoundingBox((double)box.minX(), (double)box.minY(), (double)box.minZ(), (double)box.maxX(), (double)box.maxY(), (double)box.maxZ()), chunkPos.x, chunkPos.z);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return true;
            }
            structureManager.setStartForStructure(sectionPos, structure, structureStart, chunk);
            return true;
        }
        return false;
    }

    private static int fetchReferences(StructureManager structureManager, ChunkAccess chunk, SectionPos sectionPos, net.minecraft.world.level.levelgen.structure.Structure structure) {
        StructureStart startForStructure = structureManager.getStartForStructure(sectionPos, structure, chunk);
        return startForStructure != null ? startForStructure.getReferences() : 0;
    }

    public void createReferences(WorldGenLevel level, StructureManager structureManager, ChunkAccess chunk) {
        int i = 8;
        ChunkPos pos = chunk.getPos();
        int i1 = pos.x;
        int i2 = pos.z;
        int minBlockX = pos.getMinBlockX();
        int minBlockZ = pos.getMinBlockZ();
        SectionPos sectionPos = SectionPos.bottomOf(chunk);
        for (int i3 = i1 - 8; i3 <= i1 + 8; ++i3) {
            for (int i4 = i2 - 8; i4 <= i2 + 8; ++i4) {
                long packedChunkPos = ChunkPos.asLong(i3, i4);
                for (StructureStart structureStart : level.getChunk(i3, i4).getAllStarts().values()) {
                    try {
                        if (!structureStart.isValid() || !structureStart.getBoundingBox().intersects(minBlockX, minBlockZ, minBlockX + 15, minBlockZ + 15)) continue;
                        structureManager.addReferenceForStructure(sectionPos, structureStart.getStructure(), packedChunkPos, chunk);
                    }
                    catch (Exception var21) {
                        CrashReport crashReport = CrashReport.forThrowable(var21, "Generating structure reference");
                        CrashReportCategory crashReportCategory = crashReport.addCategory("Structure");
                        Optional<Registry<net.minecraft.world.level.levelgen.structure.Structure>> optional = level.registryAccess().lookup(Registries.STRUCTURE);
                        crashReportCategory.setDetail("Id", () -> optional.map(registry -> registry.getKey(structureStart.getStructure()).toString()).orElse("UNKNOWN"));
                        crashReportCategory.setDetail("Name", () -> BuiltInRegistries.STRUCTURE_TYPE.getKey(structureStart.getStructure().type()).toString());
                        crashReportCategory.setDetail("Class", () -> structureStart.getStructure().getClass().getCanonicalName());
                        throw new ReportedException(crashReport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<ChunkAccess> fillFromNoise(Blender var1, RandomState var2, StructureManager var3, ChunkAccess var4);

    public abstract int getSeaLevel();

    public abstract int getMinY();

    public abstract int getBaseHeight(int var1, int var2, Heightmap.Types var3, LevelHeightAccessor var4, RandomState var5);

    public abstract NoiseColumn getBaseColumn(int var1, int var2, LevelHeightAccessor var3, RandomState var4);

    public int getFirstFreeHeight(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState random) {
        return this.getBaseHeight(x, z, type, level, random);
    }

    public int getFirstOccupiedHeight(int x, int z, Heightmap.Types types, LevelHeightAccessor level, RandomState random) {
        return this.getBaseHeight(x, z, types, level, random) - 1;
    }

    public abstract void addDebugScreenInfo(List<String> var1, RandomState var2, BlockPos var3);

    @Deprecated
    public BiomeGenerationSettings getBiomeGenerationSettings(Holder<Biome> biome) {
        return this.generationSettingsGetter.apply(biome);
    }

    private static /* synthetic */ String lambda$addVanillaDecorations$11(Registry registry1, PlacedFeature placedFeature) {
        return registry1.getResourceKey(placedFeature).map(Object::toString).orElseGet(placedFeature::toString);
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$10(IntSet set1, FeatureSorter.StepFeatureData stepFeatureData, PlacedFeature feature) {
        set1.add(stepFeatureData.indexMapping().applyAsInt(feature));
    }

    private static /* synthetic */ String lambda$addVanillaDecorations$8(Registry registry, net.minecraft.world.level.levelgen.structure.Structure structure) {
        return registry.getResourceKey(structure).map(Object::toString).orElseGet(structure::toString);
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$7(WorldGenLevel level, Set set, ChunkPos chunkPos) {
        ChunkAccess chunk1 = level.getChunk(chunkPos.x, chunkPos.z);
        for (LevelChunkSection levelChunkSection : chunk1.getSections()) {
            levelChunkSection.getBiomes().getAll(set::add);
        }
    }
}

