/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.patches.fast_palette.FastPalette;
import ca.spottedleaf.moonrise.patches.fast_palette.FastPaletteData;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import org.apache.commons.lang3.Validate;
import org.jspecify.annotations.Nullable;

public class SingleValuePalette<T>
implements Palette<T>,
FastPalette<T> {
    private @Nullable T value;
    private T[] rawPalette;

    @Override
    public final T[] moonrise$getRawPalette(FastPaletteData<T> container) {
        if (this.rawPalette != null) {
            return this.rawPalette;
        }
        this.rawPalette = new Object[]{this.value};
        return this.rawPalette;
    }

    public SingleValuePalette(List<T> values) {
        if (!values.isEmpty()) {
            Validate.isTrue((values.size() <= 1 ? 1 : 0) != 0, (String)"Can't initialize SingleValuePalette with %d values.", (long)values.size());
            this.value = values.getFirst();
        }
    }

    public static <A> Palette<A> create(int bits, List<A> values) {
        return new SingleValuePalette<A>(values);
    }

    @Override
    public int idFor(T state, PaletteResize<T> resizeHandler) {
        if (this.value != null && this.value != state) {
            return resizeHandler.onResize(1, state);
        }
        this.value = state;
        if (this.rawPalette != null) {
            this.rawPalette[0] = state;
        }
        return 0;
    }

    @Override
    public boolean maybeHas(Predicate<T> filter) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return filter.test(this.value);
    }

    @Override
    public T valueFor(int id) {
        if (this.value != null && id == 0) {
            return this.value;
        }
        throw new IllegalStateException("Missing Palette entry for id " + id + ".");
    }

    @Override
    public void read(FriendlyByteBuf buffer, IdMap<T> map) {
        this.value = map.byIdOrThrow(buffer.readVarInt());
        if (this.rawPalette != null) {
            this.rawPalette[0] = this.value;
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer, IdMap<T> map) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        buffer.writeVarInt(map.getId(this.value));
    }

    @Override
    public int getSerializedSize(IdMap<T> map) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return VarInt.getByteSize(map.getId(this.value));
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public Palette<T> copy() {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return this;
    }
}

