/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import java.util.function.Consumer;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import org.jspecify.annotations.Nullable;

public class DynamicGameEventListener<T extends GameEventListener> {
    private final T listener;
    private @Nullable SectionPos lastSection;

    public DynamicGameEventListener(T listener) {
        this.listener = listener;
    }

    public void add(ServerLevel level) {
        this.move(level);
    }

    public T getListener() {
        return this.listener;
    }

    public void remove(ServerLevel level) {
        DynamicGameEventListener.ifChunkExists(level, this.lastSection, listenerRegistry -> listenerRegistry.unregister((GameEventListener)this.listener));
        this.lastSection = null;
    }

    public void move(ServerLevel level) {
        this.listener.getListenerSource().getPosition(level).map(SectionPos::of).ifPresent(sectionPos -> {
            if (this.lastSection == null || !this.lastSection.equals(sectionPos)) {
                DynamicGameEventListener.ifChunkExists(level, this.lastSection, listenerRegistry -> listenerRegistry.unregister((GameEventListener)this.listener));
                this.lastSection = sectionPos;
                DynamicGameEventListener.ifChunkExists(level, this.lastSection, listenerRegistry -> listenerRegistry.register((GameEventListener)this.listener));
            }
        });
    }

    private static void ifChunkExists(LevelReader level, @Nullable SectionPos sectionPos, Consumer<GameEventListenerRegistry> dispatcherConsumer) {
        ChunkAccess chunk;
        if (sectionPos != null && (chunk = level.getChunkIfLoadedImmediately(sectionPos.getX(), sectionPos.getZ())) != null) {
            dispatcherConsumer.accept(chunk.getListenerRegistry(sectionPos.y()));
        }
    }
}

