/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gamerules;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.gamerules.GameRule;
import org.jspecify.annotations.Nullable;

public final class GameRuleMap {
    public static final Codec<GameRuleMap> CODEC = Codec.dispatchedMap(BuiltInRegistries.GAME_RULE.byNameCodec(), GameRule::valueCodec).xmap(GameRuleMap::ofTrusted, GameRuleMap::map);
    private final Reference2ObjectMap<GameRule<?>, Object> map;
    private final @Nullable Object[] idAccess;

    GameRuleMap(Reference2ObjectMap<GameRule<?>, Object> map) {
        this.map = map;
        this.idAccess = new Object[GameRule.LAST_GAMERULE_INDEX];
        for (Map.Entry entry : map.entrySet()) {
            this.idAccess[((GameRule)entry.getKey()).gameRuleIndex] = entry.getValue();
        }
    }

    private static GameRuleMap ofTrusted(Map<GameRule<?>, Object> rules) {
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)new Reference2ObjectOpenHashMap(rules));
    }

    public static GameRuleMap of() {
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)new Reference2ObjectOpenHashMap());
    }

    public static GameRuleMap of(Stream<GameRule<?>> rules) {
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        rules.forEach(gameRule -> map.put(gameRule, gameRule.defaultValue()));
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)map);
    }

    public static GameRuleMap copyOf(GameRuleMap rules) {
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)new Reference2ObjectOpenHashMap(rules.map));
    }

    public boolean has(GameRule<?> rule) {
        return this.idAccess[rule.gameRuleIndex] != null;
    }

    public <T> @Nullable T get(GameRule<T> rule) {
        return (T)this.idAccess[rule.gameRuleIndex];
    }

    public <T> void set(GameRule<T> rule, T value) {
        this.map.put(rule, value);
        this.idAccess[rule.gameRuleIndex] = value;
    }

    public <T> @Nullable T remove(GameRule<T> rule) {
        this.idAccess[rule.gameRuleIndex] = null;
        return (T)this.map.remove(rule);
    }

    public Set<GameRule<?>> keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public GameRuleMap withOther(GameRuleMap rules) {
        GameRuleMap gameRuleMap = GameRuleMap.copyOf(this);
        gameRuleMap.setFromIf(rules, gameRule -> true);
        return gameRuleMap;
    }

    public void setFromIf(GameRuleMap rules, Predicate<GameRule<?>> predicate) {
        for (GameRule<?> gameRule : rules.keySet()) {
            if (!predicate.test(gameRule)) continue;
            GameRuleMap.setGameRule(rules, gameRule, this);
        }
    }

    private static <T> void setGameRule(GameRuleMap from, GameRule<T> rule, GameRuleMap to) {
        to.set(rule, Objects.requireNonNull(from.get(rule)));
    }

    private Reference2ObjectMap<GameRule<?>, Object> map() {
        return this.map;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            GameRuleMap gameRuleMap = (GameRuleMap)other;
            return Objects.equals(this.map, gameRuleMap.map);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public static class Builder {
        final Reference2ObjectMap<GameRule<?>, Object> map = new Reference2ObjectOpenHashMap();

        public <T> Builder set(GameRule<T> rule, T value) {
            this.map.put(rule, value);
            return this;
        }

        public GameRuleMap build() {
            return new GameRuleMap(this.map);
        }
    }
}

