/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class WorldGenerationContext {
    private final int minY;
    private final int height;
    @Nullable
    private final Level serverLevel;

    public WorldGenerationContext(ChunkGenerator generator, LevelHeightAccessor level) {
        this(generator, level, null);
    }

    public WorldGenerationContext(ChunkGenerator generator, LevelHeightAccessor level, @Nullable Level serverLevel) {
        this.serverLevel = serverLevel;
        this.minY = Math.max(level.getMinY(), generator.getMinY());
        this.height = Math.min(level.getHeight(), generator.getGenDepth());
    }

    public int getMinGenY() {
        return this.minY;
    }

    public int getGenDepth() {
        return this.height;
    }

    public Level level() {
        if (this.serverLevel == null) {
            throw new NullPointerException("WorldGenerationContext was initialized without a Level, but WorldGenerationContext#level was called");
        }
        return this.serverLevel;
    }
}

