/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class LeaveVineDecorator
extends TreeDecorator {
    public static final MapCodec<LeaveVineDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(LeaveVineDecorator::new, decorator -> Float.valueOf(decorator.probability));
    private final float probability;

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.LEAVE_VINE;
    }

    public LeaveVineDecorator(float probability) {
        this.probability = probability;
    }

    @Override
    public void place(TreeDecorator.Context context) {
        RandomSource randomSource = context.random();
        context.leaves().forEach(blockPos -> {
            BlockPos blockPos1;
            if (randomSource.nextFloat() < this.probability && context.isAir(blockPos1 = blockPos.west())) {
                LeaveVineDecorator.addHangingVine(blockPos1, VineBlock.EAST, context);
            }
            if (randomSource.nextFloat() < this.probability && context.isAir(blockPos1 = blockPos.east())) {
                LeaveVineDecorator.addHangingVine(blockPos1, VineBlock.WEST, context);
            }
            if (randomSource.nextFloat() < this.probability && context.isAir(blockPos1 = blockPos.north())) {
                LeaveVineDecorator.addHangingVine(blockPos1, VineBlock.SOUTH, context);
            }
            if (randomSource.nextFloat() < this.probability && context.isAir(blockPos1 = blockPos.south())) {
                LeaveVineDecorator.addHangingVine(blockPos1, VineBlock.NORTH, context);
            }
        });
    }

    private static void addHangingVine(BlockPos pos, BooleanProperty sideProperty, TreeDecorator.Context context) {
        context.placeVine(pos, sideProperty);
        BlockPos var4 = pos.below();
        for (int i = 4; context.isAir(var4) && i > 0; --i) {
            context.placeVine(var4, sideProperty);
            var4 = var4.below();
        }
    }
}

