/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.bukkit.entity.EntityType;
import org.jspecify.annotations.Nullable;

public class StrongholdPieces {
    private static final int SMALL_DOOR_WIDTH = 3;
    private static final int SMALL_DOOR_HEIGHT = 3;
    private static final int MAX_DEPTH = 50;
    private static final int LOWEST_Y_POSITION = 10;
    private static final boolean CHECK_AIR = true;
    public static final int MAGIC_START_Y = 64;
    private static final PieceWeight[] STRONGHOLD_PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(PrisonHall.class, 5, 5), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 6), new PieceWeight(StraightStairsDown.class, 5, 5), new PieceWeight(StairsDown.class, 5, 5), new PieceWeight(FiveCrossing.class, 5, 4), new PieceWeight(ChestCorridor.class, 5, 4), new PieceWeight(Library.class, 10, 2){

        @Override
        public boolean doPlace(int genDepth) {
            return super.doPlace(genDepth) && genDepth > 4;
        }
    }, new PieceWeight(PortalRoom.class, 20, 1){

        @Override
        public boolean doPlace(int genDepth) {
            return super.doPlace(genDepth) && genDepth > 5;
        }
    }};
    private static List<PieceWeight> currentPieces;
    static @Nullable Class<? extends StrongholdPiece> imposedPiece;
    private static int totalWeight;
    static final SmoothStoneSelector SMOOTH_STONE_SELECTOR;

    public static void resetPieces() {
        currentPieces = Lists.newArrayList();
        for (PieceWeight pieceWeight : STRONGHOLD_PIECE_WEIGHTS) {
            pieceWeight.placeCount = 0;
            currentPieces.add(pieceWeight);
        }
        imposedPiece = null;
    }

    private static boolean updatePieceWeight() {
        boolean flag = false;
        totalWeight = 0;
        for (PieceWeight pieceWeight : currentPieces) {
            if (pieceWeight.maxPlaceCount > 0 && pieceWeight.placeCount < pieceWeight.maxPlaceCount) {
                flag = true;
            }
            totalWeight += pieceWeight.weight;
        }
        return flag;
    }

    private static @Nullable StrongholdPiece findAndCreatePieceFactory(Class<? extends StrongholdPiece> pieceClass, StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction direction, int genDepth) {
        StrongholdPiece strongholdPiece = null;
        if (pieceClass == Straight.class) {
            strongholdPiece = Straight.createPiece(pieces, random, x, y, z, direction, genDepth);
        } else if (pieceClass == PrisonHall.class) {
            strongholdPiece = PrisonHall.createPiece(pieces, random, x, y, z, direction, genDepth);
        } else if (pieceClass == LeftTurn.class) {
            strongholdPiece = LeftTurn.createPiece(pieces, random, x, y, z, direction, genDepth);
        } else if (pieceClass == RightTurn.class) {
            strongholdPiece = RightTurn.createPiece(pieces, random, x, y, z, direction, genDepth);
        } else if (pieceClass == RoomCrossing.class) {
            strongholdPiece = RoomCrossing.createPiece(pieces, random, x, y, z, direction, genDepth);
        } else if (pieceClass == StraightStairsDown.class) {
            strongholdPiece = StraightStairsDown.createPiece(pieces, random, x, y, z, direction, genDepth);
        } else if (pieceClass == StairsDown.class) {
            strongholdPiece = StairsDown.createPiece(pieces, random, x, y, z, direction, genDepth);
        } else if (pieceClass == FiveCrossing.class) {
            strongholdPiece = FiveCrossing.createPiece(pieces, random, x, y, z, direction, genDepth);
        } else if (pieceClass == ChestCorridor.class) {
            strongholdPiece = ChestCorridor.createPiece(pieces, random, x, y, z, direction, genDepth);
        } else if (pieceClass == Library.class) {
            strongholdPiece = Library.createPiece(pieces, random, x, y, z, direction, genDepth);
        } else if (pieceClass == PortalRoom.class) {
            strongholdPiece = PortalRoom.createPiece(pieces, x, y, z, direction, genDepth);
        }
        return strongholdPiece;
    }

    private static @Nullable StrongholdPiece generatePieceFromSmallDoor(StartPiece piece, StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction direction, int genDepth) {
        if (!StrongholdPieces.updatePieceWeight()) {
            return null;
        }
        if (imposedPiece != null) {
            StrongholdPiece strongholdPiece = StrongholdPieces.findAndCreatePieceFactory(imposedPiece, pieces, random, x, y, z, direction, genDepth);
            imposedPiece = null;
            if (strongholdPiece != null) {
                return strongholdPiece;
            }
        }
        int i = 0;
        block0: while (i < 5) {
            ++i;
            int randomInt = random.nextInt(totalWeight);
            for (PieceWeight pieceWeight : currentPieces) {
                if ((randomInt -= pieceWeight.weight) >= 0) continue;
                if (!pieceWeight.doPlace(genDepth) || pieceWeight == piece.previousPiece) continue block0;
                StrongholdPiece strongholdPiece1 = StrongholdPieces.findAndCreatePieceFactory(pieceWeight.pieceClass, pieces, random, x, y, z, direction, genDepth);
                if (strongholdPiece1 == null) continue;
                ++pieceWeight.placeCount;
                piece.previousPiece = pieceWeight;
                if (!pieceWeight.isValid()) {
                    currentPieces.remove(pieceWeight);
                }
                return strongholdPiece1;
            }
        }
        BoundingBox boundingBox = FillerCorridor.findPieceBox(pieces, random, x, y, z, direction);
        return boundingBox != null && boundingBox.minY() > 1 ? new FillerCorridor(genDepth, boundingBox, direction) : null;
    }

    static @Nullable StructurePiece generateAndAddPiece(StartPiece piece, StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction direction, int genDepth) {
        if (genDepth > 50) {
            return null;
        }
        if (Math.abs(x - piece.getBoundingBox().minX()) <= 112 && Math.abs(z - piece.getBoundingBox().minZ()) <= 112) {
            StrongholdPiece structurePiece = StrongholdPieces.generatePieceFromSmallDoor(piece, pieces, random, x, y, z, direction, genDepth + 1);
            if (structurePiece != null) {
                pieces.addPiece(structurePiece);
                piece.pendingChildren.add(structurePiece);
            }
            return structurePiece;
        }
        return null;
    }

    static {
        SMOOTH_STONE_SELECTOR = new SmoothStoneSelector();
    }

    static class PieceWeight {
        public final Class<? extends StrongholdPiece> pieceClass;
        public final int weight;
        public int placeCount;
        public final int maxPlaceCount;

        public PieceWeight(Class<? extends StrongholdPiece> pieceClass, int weight, int maxPlaceCount) {
            this.pieceClass = pieceClass;
            this.weight = weight;
            this.maxPlaceCount = maxPlaceCount;
        }

        public boolean doPlace(int genDepth) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    public static class Straight
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 5;
        private static final int DEPTH = 7;
        private final boolean leftChild;
        private final boolean rightChild;

        public Straight(int genDepth, RandomSource random, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT, genDepth, box);
            this.setOrientation(orientation);
            this.entryDoor = this.randomSmallDoor(random);
            this.leftChild = random.nextInt(2) == 0;
            this.rightChild = random.nextInt(2) == 0;
        }

        public Straight(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT, tag);
            this.leftChild = tag.getBooleanOr("Left", false);
            this.rightChild = tag.getBooleanOr("Right", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putBoolean("Left", this.leftChild);
            tag.putBoolean("Right", this.rightChild);
        }

        @Override
        public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            this.generateSmallDoorChildForward((StartPiece)piece, pieces, random, 1, 1);
            if (this.leftChild) {
                this.generateSmallDoorChildLeft((StartPiece)piece, pieces, random, 1, 2);
            }
            if (this.rightChild) {
                this.generateSmallDoorChildRight((StartPiece)piece, pieces, random, 1, 2);
            }
        }

        public static @Nullable Straight createPiece(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction direction, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -1, -1, 0, 5, 5, 7, direction);
            return Straight.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null ? new Straight(genDepth, random, boundingBox, direction) : null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            this.generateBox(level, box, 0, 0, 0, 4, 4, 6, true, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, this.entryDoor, 1, 1, 0);
            this.generateSmallDoor(level, random, box, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 6);
            BlockState blockState = (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.EAST);
            BlockState blockState1 = (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.WEST);
            this.maybeGenerateBlock(level, box, random, 0.1f, 1, 2, 1, blockState);
            this.maybeGenerateBlock(level, box, random, 0.1f, 3, 2, 1, blockState1);
            this.maybeGenerateBlock(level, box, random, 0.1f, 1, 2, 5, blockState);
            this.maybeGenerateBlock(level, box, random, 0.1f, 3, 2, 5, blockState1);
            if (this.leftChild) {
                this.generateBox(level, box, 0, 1, 2, 0, 3, 4, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightChild) {
                this.generateBox(level, box, 4, 1, 2, 4, 3, 4, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class PrisonHall
    extends StrongholdPiece {
        protected static final int WIDTH = 9;
        protected static final int HEIGHT = 5;
        protected static final int DEPTH = 11;

        public PrisonHall(int genDepth, RandomSource random, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_PRISON_HALL, genDepth, box);
            this.setOrientation(orientation);
            this.entryDoor = this.randomSmallDoor(random);
        }

        public PrisonHall(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_PRISON_HALL, tag);
        }

        @Override
        public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            this.generateSmallDoorChildForward((StartPiece)piece, pieces, random, 1, 1);
        }

        public static @Nullable PrisonHall createPiece(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction orientation, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -1, -1, 0, 9, 5, 11, orientation);
            return PrisonHall.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null ? new PrisonHall(genDepth, random, boundingBox, orientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            this.generateBox(level, box, 0, 0, 0, 8, 4, 10, true, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, this.entryDoor, 1, 1, 0);
            this.generateBox(level, box, 1, 1, 10, 3, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(level, box, 4, 1, 1, 4, 3, 1, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 4, 1, 3, 4, 3, 3, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 4, 1, 7, 4, 3, 7, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 4, 1, 9, 4, 3, 9, false, random, SMOOTH_STONE_SELECTOR);
            for (int i = 1; i <= 3; ++i) {
                this.placeBlock(level, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, i, 4, box);
                this.placeBlock(level, (BlockState)((BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)).setValue(IronBarsBlock.EAST, true), 4, i, 5, box);
                this.placeBlock(level, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, i, 6, box);
                this.placeBlock(level, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true), 5, i, 5, box);
                this.placeBlock(level, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true), 6, i, 5, box);
                this.placeBlock(level, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true), 7, i, 5, box);
            }
            this.placeBlock(level, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, 3, 2, box);
            this.placeBlock(level, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, 3, 8, box);
            BlockState blockState = (BlockState)Blocks.IRON_DOOR.defaultBlockState().setValue(DoorBlock.FACING, Direction.WEST);
            BlockState blockState1 = (BlockState)((BlockState)Blocks.IRON_DOOR.defaultBlockState().setValue(DoorBlock.FACING, Direction.WEST)).setValue(DoorBlock.HALF, DoubleBlockHalf.UPPER);
            this.placeBlock(level, blockState, 4, 1, 2, box);
            this.placeBlock(level, blockState1, 4, 2, 2, box);
            this.placeBlock(level, blockState, 4, 1, 8, box);
            this.placeBlock(level, blockState1, 4, 2, 8, box);
        }
    }

    public static class LeftTurn
    extends Turn {
        public LeftTurn(int genDepth, RandomSource random, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_LEFT_TURN, genDepth, box);
            this.setOrientation(orientation);
            this.entryDoor = this.randomSmallDoor(random);
        }

        public LeftTurn(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_LEFT_TURN, tag);
        }

        @Override
        public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            Direction orientation = this.getOrientation();
            if (orientation != Direction.NORTH && orientation != Direction.EAST) {
                this.generateSmallDoorChildRight((StartPiece)piece, pieces, random, 1, 1);
            } else {
                this.generateSmallDoorChildLeft((StartPiece)piece, pieces, random, 1, 1);
            }
        }

        public static @Nullable LeftTurn createPiece(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction orientation, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -1, -1, 0, 5, 5, 5, orientation);
            return LeftTurn.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null ? new LeftTurn(genDepth, random, boundingBox, orientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            this.generateBox(level, box, 0, 0, 0, 4, 4, 4, true, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, this.entryDoor, 1, 1, 0);
            Direction orientation = this.getOrientation();
            if (orientation != Direction.NORTH && orientation != Direction.EAST) {
                this.generateBox(level, box, 4, 1, 1, 4, 3, 3, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(level, box, 0, 1, 1, 0, 3, 3, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class RightTurn
    extends Turn {
        public RightTurn(int genDepth, RandomSource random, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_RIGHT_TURN, genDepth, box);
            this.setOrientation(orientation);
            this.entryDoor = this.randomSmallDoor(random);
        }

        public RightTurn(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_RIGHT_TURN, tag);
        }

        @Override
        public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            Direction orientation = this.getOrientation();
            if (orientation != Direction.NORTH && orientation != Direction.EAST) {
                this.generateSmallDoorChildLeft((StartPiece)piece, pieces, random, 1, 1);
            } else {
                this.generateSmallDoorChildRight((StartPiece)piece, pieces, random, 1, 1);
            }
        }

        public static @Nullable RightTurn createPiece(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction orientation, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -1, -1, 0, 5, 5, 5, orientation);
            return RightTurn.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null ? new RightTurn(genDepth, random, boundingBox, orientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            this.generateBox(level, box, 0, 0, 0, 4, 4, 4, true, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, this.entryDoor, 1, 1, 0);
            Direction orientation = this.getOrientation();
            if (orientation != Direction.NORTH && orientation != Direction.EAST) {
                this.generateBox(level, box, 0, 1, 1, 0, 3, 3, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(level, box, 4, 1, 1, 4, 3, 3, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class RoomCrossing
    extends StrongholdPiece {
        protected static final int WIDTH = 11;
        protected static final int HEIGHT = 7;
        protected static final int DEPTH = 11;
        protected final int type;

        public RoomCrossing(int genDepth, RandomSource random, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_ROOM_CROSSING, genDepth, box);
            this.setOrientation(orientation);
            this.entryDoor = this.randomSmallDoor(random);
            this.type = random.nextInt(5);
        }

        public RoomCrossing(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_ROOM_CROSSING, tag);
            this.type = tag.getIntOr("Type", 0);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putInt("Type", this.type);
        }

        @Override
        public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            this.generateSmallDoorChildForward((StartPiece)piece, pieces, random, 4, 1);
            this.generateSmallDoorChildLeft((StartPiece)piece, pieces, random, 1, 4);
            this.generateSmallDoorChildRight((StartPiece)piece, pieces, random, 1, 4);
        }

        public static @Nullable RoomCrossing createPiece(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction orientation, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -4, -1, 0, 11, 7, 11, orientation);
            return RoomCrossing.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null ? new RoomCrossing(genDepth, random, boundingBox, orientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            this.generateBox(level, box, 0, 0, 0, 10, 6, 10, true, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, this.entryDoor, 4, 1, 0);
            this.generateBox(level, box, 4, 1, 10, 6, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(level, box, 0, 1, 4, 0, 3, 6, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(level, box, 10, 1, 4, 10, 3, 6, CAVE_AIR, CAVE_AIR, false);
            switch (this.type) {
                case 0: {
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 5, 1, 5, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 5, 2, 5, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 5, 3, 5, box);
                    this.placeBlock(level, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.WEST), 4, 3, 5, box);
                    this.placeBlock(level, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.EAST), 6, 3, 5, box);
                    this.placeBlock(level, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.SOUTH), 5, 3, 4, box);
                    this.placeBlock(level, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.NORTH), 5, 3, 6, box);
                    this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 4, box);
                    this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 5, box);
                    this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 6, box);
                    this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 4, box);
                    this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 5, box);
                    this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 6, box);
                    this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 5, 1, 4, box);
                    this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 5, 1, 6, box);
                    break;
                }
                case 1: {
                    for (int i = 0; i < 5; ++i) {
                        this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 3, 1, 3 + i, box);
                        this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 7, 1, 3 + i, box);
                        this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 3 + i, 1, 3, box);
                        this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 3 + i, 1, 7, box);
                    }
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 5, 1, 5, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 5, 2, 5, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 5, 3, 5, box);
                    this.placeBlock(level, Blocks.WATER.defaultBlockState(), 5, 4, 5, box);
                    break;
                }
                case 2: {
                    int i;
                    for (i = 1; i <= 9; ++i) {
                        this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 1, 3, i, box);
                        this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 9, 3, i, box);
                    }
                    for (i = 1; i <= 9; ++i) {
                        this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), i, 3, 1, box);
                        this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), i, 3, 9, box);
                    }
                    this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 5, 1, 4, box);
                    this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 5, 1, 6, box);
                    this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 5, 3, 4, box);
                    this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 5, 3, 6, box);
                    this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 4, 1, 5, box);
                    this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 6, 1, 5, box);
                    this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 4, 3, 5, box);
                    this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 6, 3, 5, box);
                    for (i = 1; i <= 3; ++i) {
                        this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 4, i, 4, box);
                        this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 6, i, 4, box);
                        this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 4, i, 6, box);
                        this.placeBlock(level, Blocks.COBBLESTONE.defaultBlockState(), 6, i, 6, box);
                    }
                    this.placeBlock(level, Blocks.WALL_TORCH.defaultBlockState(), 5, 3, 5, box);
                    for (i = 2; i <= 8; ++i) {
                        this.placeBlock(level, Blocks.OAK_PLANKS.defaultBlockState(), 2, 3, i, box);
                        this.placeBlock(level, Blocks.OAK_PLANKS.defaultBlockState(), 3, 3, i, box);
                        if (i <= 3 || i >= 7) {
                            this.placeBlock(level, Blocks.OAK_PLANKS.defaultBlockState(), 4, 3, i, box);
                            this.placeBlock(level, Blocks.OAK_PLANKS.defaultBlockState(), 5, 3, i, box);
                            this.placeBlock(level, Blocks.OAK_PLANKS.defaultBlockState(), 6, 3, i, box);
                        }
                        this.placeBlock(level, Blocks.OAK_PLANKS.defaultBlockState(), 7, 3, i, box);
                        this.placeBlock(level, Blocks.OAK_PLANKS.defaultBlockState(), 8, 3, i, box);
                    }
                    BlockState blockState = (BlockState)Blocks.LADDER.defaultBlockState().setValue(LadderBlock.FACING, Direction.WEST);
                    this.placeBlock(level, blockState, 9, 1, 3, box);
                    this.placeBlock(level, blockState, 9, 2, 3, box);
                    this.placeBlock(level, blockState, 9, 3, 3, box);
                    this.createChest(level, box, random, 3, 4, 8, BuiltInLootTables.STRONGHOLD_CROSSING);
                }
            }
        }
    }

    public static class StraightStairsDown
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 8;

        public StraightStairsDown(int genDepth, RandomSource random, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT_STAIRS_DOWN, genDepth, box);
            this.setOrientation(orientation);
            this.entryDoor = this.randomSmallDoor(random);
        }

        public StraightStairsDown(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT_STAIRS_DOWN, tag);
        }

        @Override
        public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            this.generateSmallDoorChildForward((StartPiece)piece, pieces, random, 1, 1);
        }

        public static @Nullable StraightStairsDown createPiece(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction orientation, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -1, -7, 0, 5, 11, 8, orientation);
            return StraightStairsDown.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null ? new StraightStairsDown(genDepth, random, boundingBox, orientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            this.generateBox(level, box, 0, 0, 0, 4, 10, 7, true, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, this.entryDoor, 1, 7, 0);
            this.generateSmallDoor(level, random, box, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 7);
            BlockState blockState = (BlockState)Blocks.COBBLESTONE_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.SOUTH);
            for (int i = 0; i < 6; ++i) {
                this.placeBlock(level, blockState, 1, 6 - i, 1 + i, box);
                this.placeBlock(level, blockState, 2, 6 - i, 1 + i, box);
                this.placeBlock(level, blockState, 3, 6 - i, 1 + i, box);
                if (i >= 5) continue;
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5 - i, 1 + i, box);
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 2, 5 - i, 1 + i, box);
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 3, 5 - i, 1 + i, box);
            }
        }
    }

    public static class StairsDown
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 5;
        private final boolean isSource;

        public StairsDown(StructurePieceType type, int genDepth, int x, int z, Direction orientation) {
            super(type, genDepth, StairsDown.makeBoundingBox(x, 64, z, orientation, 5, 11, 5));
            this.isSource = true;
            this.setOrientation(orientation);
            this.entryDoor = StrongholdPiece.SmallDoorType.OPENING;
        }

        public StairsDown(int genDepth, RandomSource random, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_STAIRS_DOWN, genDepth, box);
            this.isSource = false;
            this.setOrientation(orientation);
            this.entryDoor = this.randomSmallDoor(random);
        }

        public StairsDown(StructurePieceType type, CompoundTag tag) {
            super(type, tag);
            this.isSource = tag.getBooleanOr("Source", false);
        }

        public StairsDown(CompoundTag tag) {
            this(StructurePieceType.STRONGHOLD_STAIRS_DOWN, tag);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putBoolean("Source", this.isSource);
        }

        @Override
        public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            if (this.isSource) {
                imposedPiece = FiveCrossing.class;
            }
            this.generateSmallDoorChildForward((StartPiece)piece, pieces, random, 1, 1);
        }

        public static @Nullable StairsDown createPiece(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction orientation, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -1, -7, 0, 5, 11, 5, orientation);
            return StairsDown.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null ? new StairsDown(genDepth, random, boundingBox, orientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            this.generateBox(level, box, 0, 0, 0, 4, 10, 4, true, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, this.entryDoor, 1, 7, 0);
            this.generateSmallDoor(level, random, box, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 4);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 2, 6, 1, box);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5, 1, box);
            this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 6, 1, box);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5, 2, box);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 1, 4, 3, box);
            this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 5, 3, box);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 2, 4, 3, box);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 3, 3, 3, box);
            this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 3, 4, 3, box);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 3, 3, 2, box);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 3, 2, 1, box);
            this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 3, 3, 1, box);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 2, 2, 1, box);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 1, 1, 1, box);
            this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 2, 1, box);
            this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 1, 1, 2, box);
            this.placeBlock(level, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 1, 3, box);
        }
    }

    public static class FiveCrossing
    extends StrongholdPiece {
        protected static final int WIDTH = 10;
        protected static final int HEIGHT = 9;
        protected static final int DEPTH = 11;
        private final boolean leftLow;
        private final boolean leftHigh;
        private final boolean rightLow;
        private final boolean rightHigh;

        public FiveCrossing(int genDepth, RandomSource random, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_FIVE_CROSSING, genDepth, box);
            this.setOrientation(orientation);
            this.entryDoor = this.randomSmallDoor(random);
            this.leftLow = random.nextBoolean();
            this.leftHigh = random.nextBoolean();
            this.rightLow = random.nextBoolean();
            this.rightHigh = random.nextInt(3) > 0;
        }

        public FiveCrossing(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_FIVE_CROSSING, tag);
            this.leftLow = tag.getBooleanOr("leftLow", false);
            this.leftHigh = tag.getBooleanOr("leftHigh", false);
            this.rightLow = tag.getBooleanOr("rightLow", false);
            this.rightHigh = tag.getBooleanOr("rightHigh", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putBoolean("leftLow", this.leftLow);
            tag.putBoolean("leftHigh", this.leftHigh);
            tag.putBoolean("rightLow", this.rightLow);
            tag.putBoolean("rightHigh", this.rightHigh);
        }

        @Override
        public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            int i = 3;
            int i1 = 5;
            Direction orientation = this.getOrientation();
            if (orientation == Direction.WEST || orientation == Direction.NORTH) {
                i = 8 - i;
                i1 = 8 - i1;
            }
            this.generateSmallDoorChildForward((StartPiece)piece, pieces, random, 5, 1);
            if (this.leftLow) {
                this.generateSmallDoorChildLeft((StartPiece)piece, pieces, random, i, 1);
            }
            if (this.leftHigh) {
                this.generateSmallDoorChildLeft((StartPiece)piece, pieces, random, i1, 7);
            }
            if (this.rightLow) {
                this.generateSmallDoorChildRight((StartPiece)piece, pieces, random, i, 1);
            }
            if (this.rightHigh) {
                this.generateSmallDoorChildRight((StartPiece)piece, pieces, random, i1, 7);
            }
        }

        public static @Nullable FiveCrossing createPiece(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction orientation, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -4, -3, 0, 10, 9, 11, orientation);
            return FiveCrossing.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null ? new FiveCrossing(genDepth, random, boundingBox, orientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            this.generateBox(level, box, 0, 0, 0, 9, 8, 10, true, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, this.entryDoor, 4, 3, 0);
            if (this.leftLow) {
                this.generateBox(level, box, 0, 3, 1, 0, 5, 3, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightLow) {
                this.generateBox(level, box, 9, 3, 1, 9, 5, 3, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.leftHigh) {
                this.generateBox(level, box, 0, 5, 7, 0, 7, 9, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightHigh) {
                this.generateBox(level, box, 9, 5, 7, 9, 7, 9, CAVE_AIR, CAVE_AIR, false);
            }
            this.generateBox(level, box, 5, 1, 10, 7, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(level, box, 1, 2, 1, 8, 2, 6, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 4, 1, 5, 4, 4, 9, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 8, 1, 5, 8, 4, 9, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 1, 4, 7, 3, 4, 9, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 1, 3, 5, 3, 3, 6, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 1, 3, 4, 3, 3, 4, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(level, box, 1, 4, 6, 3, 4, 6, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(level, box, 5, 1, 7, 7, 1, 8, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 5, 1, 9, 7, 1, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(level, box, 5, 2, 7, 7, 2, 7, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(level, box, 4, 5, 7, 4, 5, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(level, box, 8, 5, 7, 8, 5, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(level, box, 5, 5, 7, 7, 5, 9, (BlockState)Blocks.SMOOTH_STONE_SLAB.defaultBlockState().setValue(SlabBlock.TYPE, SlabType.DOUBLE), (BlockState)Blocks.SMOOTH_STONE_SLAB.defaultBlockState().setValue(SlabBlock.TYPE, SlabType.DOUBLE), false);
            this.placeBlock(level, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.SOUTH), 6, 5, 6, box);
        }
    }

    public static class ChestCorridor
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 5;
        private static final int DEPTH = 7;
        private boolean hasPlacedChest;

        public ChestCorridor(int genDepth, RandomSource random, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_CHEST_CORRIDOR, genDepth, box);
            this.setOrientation(orientation);
            this.entryDoor = this.randomSmallDoor(random);
        }

        public ChestCorridor(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_CHEST_CORRIDOR, tag);
            this.hasPlacedChest = tag.getBooleanOr("Chest", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putBoolean("Chest", this.hasPlacedChest);
        }

        @Override
        public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            this.generateSmallDoorChildForward((StartPiece)piece, pieces, random, 1, 1);
        }

        public static @Nullable ChestCorridor createPiece(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction orientation, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -1, -1, 0, 5, 5, 7, orientation);
            return ChestCorridor.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null ? new ChestCorridor(genDepth, random, boundingBox, orientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            this.generateBox(level, box, 0, 0, 0, 4, 4, 6, true, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, this.entryDoor, 1, 1, 0);
            this.generateSmallDoor(level, random, box, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 6);
            this.generateBox(level, box, 3, 1, 2, 3, 1, 4, Blocks.STONE_BRICKS.defaultBlockState(), Blocks.STONE_BRICKS.defaultBlockState(), false);
            this.placeBlock(level, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 1, 1, box);
            this.placeBlock(level, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 1, 5, box);
            this.placeBlock(level, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 2, 2, box);
            this.placeBlock(level, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 2, 4, box);
            for (int i = 2; i <= 4; ++i) {
                this.placeBlock(level, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 2, 1, i, box);
            }
            if (!this.hasPlacedChest && box.isInside(this.getWorldPos(3, 2, 3))) {
                this.hasPlacedChest = true;
                this.createChest(level, box, random, 3, 2, 3, BuiltInLootTables.STRONGHOLD_CORRIDOR);
            }
        }
    }

    public static class Library
    extends StrongholdPiece {
        protected static final int WIDTH = 14;
        protected static final int HEIGHT = 6;
        protected static final int TALL_HEIGHT = 11;
        protected static final int DEPTH = 15;
        private final boolean isTall;

        public Library(int genDepth, RandomSource random, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_LIBRARY, genDepth, box);
            this.setOrientation(orientation);
            this.entryDoor = this.randomSmallDoor(random);
            this.isTall = box.getYSpan() > 6;
        }

        public Library(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_LIBRARY, tag);
            this.isTall = tag.getBooleanOr("Tall", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putBoolean("Tall", this.isTall);
        }

        public static @Nullable Library createPiece(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction orientation, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -4, -1, 0, 14, 11, 15, orientation);
            if (!(Library.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null || Library.isOkBox(boundingBox = BoundingBox.orientBox(x, y, z, -4, -1, 0, 14, 6, 15, orientation)) && pieces.findCollisionPiece(boundingBox) == null)) {
                return null;
            }
            return new Library(genDepth, random, boundingBox, orientation);
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            int i = 11;
            if (!this.isTall) {
                i = 6;
            }
            this.generateBox(level, box, 0, 0, 0, 13, i - 1, 14, true, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, this.entryDoor, 4, 1, 0);
            this.generateMaybeBox(level, box, random, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.COBWEB.defaultBlockState(), Blocks.COBWEB.defaultBlockState(), false, false);
            boolean i1 = true;
            int i2 = 12;
            for (int i3 = 1; i3 <= 13; ++i3) {
                if ((i3 - 1) % 4 == 0) {
                    this.generateBox(level, box, 1, 1, i3, 1, 4, i3, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.generateBox(level, box, 12, 1, i3, 12, 4, i3, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.placeBlock(level, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.EAST), 2, 3, i3, box);
                    this.placeBlock(level, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.WEST), 11, 3, i3, box);
                    if (!this.isTall) continue;
                    this.generateBox(level, box, 1, 6, i3, 1, 9, i3, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.generateBox(level, box, 12, 6, i3, 12, 9, i3, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    continue;
                }
                this.generateBox(level, box, 1, 1, i3, 1, 4, i3, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(level, box, 12, 1, i3, 12, 4, i3, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                if (!this.isTall) continue;
                this.generateBox(level, box, 1, 6, i3, 1, 9, i3, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(level, box, 12, 6, i3, 12, 9, i3, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
            }
            for (int i3x = 3; i3x < 12; i3x += 2) {
                this.generateBox(level, box, 3, 1, i3x, 4, 3, i3x, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(level, box, 6, 1, i3x, 7, 3, i3x, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(level, box, 9, 1, i3x, 10, 3, i3x, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
            }
            if (this.isTall) {
                this.generateBox(level, box, 1, 5, 1, 3, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(level, box, 10, 5, 1, 12, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(level, box, 4, 5, 1, 9, 5, 2, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(level, box, 4, 5, 12, 9, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.placeBlock(level, Blocks.OAK_PLANKS.defaultBlockState(), 9, 5, 11, box);
                this.placeBlock(level, Blocks.OAK_PLANKS.defaultBlockState(), 8, 5, 11, box);
                this.placeBlock(level, Blocks.OAK_PLANKS.defaultBlockState(), 9, 5, 10, box);
                BlockState blockState = (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
                BlockState blockState1 = (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
                this.generateBox(level, box, 3, 6, 3, 3, 6, 11, blockState1, blockState1, false);
                this.generateBox(level, box, 10, 6, 3, 10, 6, 9, blockState1, blockState1, false);
                this.generateBox(level, box, 4, 6, 2, 9, 6, 2, blockState, blockState, false);
                this.generateBox(level, box, 4, 6, 12, 7, 6, 12, blockState, blockState, false);
                this.placeBlock(level, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.EAST, true), 3, 6, 2, box);
                this.placeBlock(level, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.EAST, true), 3, 6, 12, box);
                this.placeBlock(level, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.WEST, true), 10, 6, 2, box);
                for (int i4 = 0; i4 <= 2; ++i4) {
                    this.placeBlock(level, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.WEST, true), 8 + i4, 6, 12 - i4, box);
                    if (i4 == 2) continue;
                    this.placeBlock(level, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.EAST, true), 8 + i4, 6, 11 - i4, box);
                }
                BlockState blockState2 = (BlockState)Blocks.LADDER.defaultBlockState().setValue(LadderBlock.FACING, Direction.SOUTH);
                this.placeBlock(level, blockState2, 10, 1, 13, box);
                this.placeBlock(level, blockState2, 10, 2, 13, box);
                this.placeBlock(level, blockState2, 10, 3, 13, box);
                this.placeBlock(level, blockState2, 10, 4, 13, box);
                this.placeBlock(level, blockState2, 10, 5, 13, box);
                this.placeBlock(level, blockState2, 10, 6, 13, box);
                this.placeBlock(level, blockState2, 10, 7, 13, box);
                int i5 = 7;
                int i6 = 7;
                BlockState blockState3 = (BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true);
                this.placeBlock(level, blockState3, 6, 9, 7, box);
                BlockState blockState4 = (BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true);
                this.placeBlock(level, blockState4, 7, 9, 7, box);
                this.placeBlock(level, blockState3, 6, 8, 7, box);
                this.placeBlock(level, blockState4, 7, 8, 7, box);
                BlockState blockState5 = (BlockState)((BlockState)blockState1.setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
                this.placeBlock(level, blockState5, 6, 7, 7, box);
                this.placeBlock(level, blockState5, 7, 7, 7, box);
                this.placeBlock(level, blockState3, 5, 7, 7, box);
                this.placeBlock(level, blockState4, 8, 7, 7, box);
                this.placeBlock(level, (BlockState)blockState3.setValue(FenceBlock.NORTH, true), 6, 7, 6, box);
                this.placeBlock(level, (BlockState)blockState3.setValue(FenceBlock.SOUTH, true), 6, 7, 8, box);
                this.placeBlock(level, (BlockState)blockState4.setValue(FenceBlock.NORTH, true), 7, 7, 6, box);
                this.placeBlock(level, (BlockState)blockState4.setValue(FenceBlock.SOUTH, true), 7, 7, 8, box);
                BlockState blockState6 = Blocks.TORCH.defaultBlockState();
                this.placeBlock(level, blockState6, 5, 8, 7, box);
                this.placeBlock(level, blockState6, 8, 8, 7, box);
                this.placeBlock(level, blockState6, 6, 8, 6, box);
                this.placeBlock(level, blockState6, 6, 8, 8, box);
                this.placeBlock(level, blockState6, 7, 8, 6, box);
                this.placeBlock(level, blockState6, 7, 8, 8, box);
            }
            this.createChest(level, box, random, 3, 3, 5, BuiltInLootTables.STRONGHOLD_LIBRARY);
            if (this.isTall) {
                this.placeBlock(level, CAVE_AIR, 12, 9, 1, box);
                this.createChest(level, box, random, 12, 8, 1, BuiltInLootTables.STRONGHOLD_LIBRARY);
            }
        }
    }

    public static class PortalRoom
    extends StrongholdPiece {
        protected static final int WIDTH = 11;
        protected static final int HEIGHT = 8;
        protected static final int DEPTH = 16;
        private boolean hasPlacedSpawner;

        public PortalRoom(int genDepth, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_PORTAL_ROOM, genDepth, box);
            this.setOrientation(orientation);
        }

        public PortalRoom(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_PORTAL_ROOM, tag);
            this.hasPlacedSpawner = tag.getBooleanOr("Mob", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putBoolean("Mob", this.hasPlacedSpawner);
        }

        @Override
        public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            if (piece != null) {
                ((StartPiece)piece).portalRoomPiece = this;
            }
        }

        public static @Nullable PortalRoom createPiece(StructurePieceAccessor pieces, int x, int y, int z, Direction orientation, int genDepth) {
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -4, -1, 0, 11, 8, 16, orientation);
            return PortalRoom.isOkBox(boundingBox) && pieces.findCollisionPiece(boundingBox) == null ? new PortalRoom(genDepth, boundingBox, orientation) : null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            BlockPos.MutableBlockPos worldPos;
            int i1;
            this.generateBox(level, box, 0, 0, 0, 10, 7, 15, false, random, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(level, random, box, StrongholdPiece.SmallDoorType.GRATES, 4, 1, 0);
            int i = 6;
            this.generateBox(level, box, 1, 6, 1, 1, 6, 14, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 9, 6, 1, 9, 6, 14, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 2, 6, 1, 8, 6, 2, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 2, 6, 14, 8, 6, 14, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 1, 1, 1, 2, 1, 4, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 8, 1, 1, 9, 1, 4, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 1, 1, 1, 1, 1, 3, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            this.generateBox(level, box, 9, 1, 1, 9, 1, 3, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            this.generateBox(level, box, 3, 1, 8, 7, 1, 12, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 4, 1, 9, 6, 1, 11, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            BlockState blockState = (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true);
            BlockState blockState1 = (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true);
            for (i1 = 3; i1 < 14; i1 += 2) {
                this.generateBox(level, box, 0, 3, i1, 0, 4, i1, blockState, blockState, false);
                this.generateBox(level, box, 10, 3, i1, 10, 4, i1, blockState, blockState, false);
            }
            for (i1 = 2; i1 < 9; i1 += 2) {
                this.generateBox(level, box, i1, 3, 15, i1, 4, 15, blockState1, blockState1, false);
            }
            BlockState blockState2 = (BlockState)Blocks.STONE_BRICK_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.NORTH);
            this.generateBox(level, box, 4, 1, 5, 6, 1, 7, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 4, 2, 6, 6, 2, 7, false, random, SMOOTH_STONE_SELECTOR);
            this.generateBox(level, box, 4, 3, 7, 6, 3, 7, false, random, SMOOTH_STONE_SELECTOR);
            for (int i2 = 4; i2 <= 6; ++i2) {
                this.placeBlock(level, blockState2, i2, 1, 4, box);
                this.placeBlock(level, blockState2, i2, 2, 5, box);
                this.placeBlock(level, blockState2, i2, 3, 6, box);
            }
            BlockState blockState3 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.NORTH);
            BlockState blockState4 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.SOUTH);
            BlockState blockState5 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.EAST);
            BlockState blockState6 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.WEST);
            boolean flag = true;
            boolean[] flags = new boolean[12];
            for (int i3 = 0; i3 < flags.length; ++i3) {
                flags[i3] = random.nextFloat() > 0.9f;
                flag &= flags[i3];
            }
            this.placeBlock(level, (BlockState)blockState3.setValue(EndPortalFrameBlock.HAS_EYE, flags[0]), 4, 3, 8, box);
            this.placeBlock(level, (BlockState)blockState3.setValue(EndPortalFrameBlock.HAS_EYE, flags[1]), 5, 3, 8, box);
            this.placeBlock(level, (BlockState)blockState3.setValue(EndPortalFrameBlock.HAS_EYE, flags[2]), 6, 3, 8, box);
            this.placeBlock(level, (BlockState)blockState4.setValue(EndPortalFrameBlock.HAS_EYE, flags[3]), 4, 3, 12, box);
            this.placeBlock(level, (BlockState)blockState4.setValue(EndPortalFrameBlock.HAS_EYE, flags[4]), 5, 3, 12, box);
            this.placeBlock(level, (BlockState)blockState4.setValue(EndPortalFrameBlock.HAS_EYE, flags[5]), 6, 3, 12, box);
            this.placeBlock(level, (BlockState)blockState5.setValue(EndPortalFrameBlock.HAS_EYE, flags[6]), 3, 3, 9, box);
            this.placeBlock(level, (BlockState)blockState5.setValue(EndPortalFrameBlock.HAS_EYE, flags[7]), 3, 3, 10, box);
            this.placeBlock(level, (BlockState)blockState5.setValue(EndPortalFrameBlock.HAS_EYE, flags[8]), 3, 3, 11, box);
            this.placeBlock(level, (BlockState)blockState6.setValue(EndPortalFrameBlock.HAS_EYE, flags[9]), 7, 3, 9, box);
            this.placeBlock(level, (BlockState)blockState6.setValue(EndPortalFrameBlock.HAS_EYE, flags[10]), 7, 3, 10, box);
            this.placeBlock(level, (BlockState)blockState6.setValue(EndPortalFrameBlock.HAS_EYE, flags[11]), 7, 3, 11, box);
            if (flag) {
                BlockState blockState7 = Blocks.END_PORTAL.defaultBlockState();
                this.placeBlock(level, blockState7, 4, 3, 9, box);
                this.placeBlock(level, blockState7, 5, 3, 9, box);
                this.placeBlock(level, blockState7, 6, 3, 9, box);
                this.placeBlock(level, blockState7, 4, 3, 10, box);
                this.placeBlock(level, blockState7, 5, 3, 10, box);
                this.placeBlock(level, blockState7, 6, 3, 10, box);
                this.placeBlock(level, blockState7, 4, 3, 11, box);
                this.placeBlock(level, blockState7, 5, 3, 11, box);
                this.placeBlock(level, blockState7, 6, 3, 11, box);
            }
            if (!this.hasPlacedSpawner && box.isInside(worldPos = this.getWorldPos(5, 3, 6))) {
                this.hasPlacedSpawner = true;
                this.placeCraftSpawner(level, worldPos, EntityType.SILVERFISH, 2);
            }
        }
    }

    static abstract class StrongholdPiece
    extends StructurePiece {
        protected SmallDoorType entryDoor = SmallDoorType.OPENING;

        protected StrongholdPiece(StructurePieceType type, int genDepth, BoundingBox boundingBox) {
            super(type, genDepth, boundingBox);
        }

        public StrongholdPiece(StructurePieceType type, CompoundTag tag) {
            super(type, tag);
            this.entryDoor = tag.read("EntryDoor", SmallDoorType.LEGACY_CODEC).orElseThrow();
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            tag.store("EntryDoor", SmallDoorType.LEGACY_CODEC, this.entryDoor);
        }

        protected void generateSmallDoor(WorldGenLevel level, RandomSource random, BoundingBox box, SmallDoorType type, int x, int y, int z) {
            switch (type.ordinal()) {
                case 0: {
                    this.generateBox(level, box, x, y, z, x + 3 - 1, y + 3 - 1, z, CAVE_AIR, CAVE_AIR, false);
                    break;
                }
                case 1: {
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x, y, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x, y + 1, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x, y + 2, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x + 1, y + 2, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x + 2, y + 2, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x + 2, y + 1, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x + 2, y, z, box);
                    this.placeBlock(level, Blocks.OAK_DOOR.defaultBlockState(), x + 1, y, z, box);
                    this.placeBlock(level, (BlockState)Blocks.OAK_DOOR.defaultBlockState().setValue(DoorBlock.HALF, DoubleBlockHalf.UPPER), x + 1, y + 1, z, box);
                    break;
                }
                case 2: {
                    this.placeBlock(level, Blocks.CAVE_AIR.defaultBlockState(), x + 1, y, z, box);
                    this.placeBlock(level, Blocks.CAVE_AIR.defaultBlockState(), x + 1, y + 1, z, box);
                    this.placeBlock(level, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true), x, y, z, box);
                    this.placeBlock(level, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true), x, y + 1, z, box);
                    this.placeBlock(level, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true), x, y + 2, z, box);
                    this.placeBlock(level, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true), x + 1, y + 2, z, box);
                    this.placeBlock(level, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true), x + 2, y + 2, z, box);
                    this.placeBlock(level, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true), x + 2, y + 1, z, box);
                    this.placeBlock(level, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true), x + 2, y, z, box);
                    break;
                }
                case 3: {
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x, y, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x, y + 1, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x, y + 2, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x + 1, y + 2, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x + 2, y + 2, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x + 2, y + 1, z, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), x + 2, y, z, box);
                    this.placeBlock(level, Blocks.IRON_DOOR.defaultBlockState(), x + 1, y, z, box);
                    this.placeBlock(level, (BlockState)Blocks.IRON_DOOR.defaultBlockState().setValue(DoorBlock.HALF, DoubleBlockHalf.UPPER), x + 1, y + 1, z, box);
                    this.placeBlock(level, (BlockState)Blocks.STONE_BUTTON.defaultBlockState().setValue(ButtonBlock.FACING, Direction.NORTH), x + 2, y + 1, z + 1, box);
                    this.placeBlock(level, (BlockState)Blocks.STONE_BUTTON.defaultBlockState().setValue(ButtonBlock.FACING, Direction.SOUTH), x + 2, y + 1, z - 1, box);
                }
            }
        }

        protected SmallDoorType randomSmallDoor(RandomSource random) {
            int randomInt = random.nextInt(5);
            switch (randomInt) {
                default: {
                    return SmallDoorType.OPENING;
                }
                case 2: {
                    return SmallDoorType.WOOD_DOOR;
                }
                case 3: {
                    return SmallDoorType.GRATES;
                }
                case 4: 
            }
            return SmallDoorType.IRON_DOOR;
        }

        protected @Nullable StructurePiece generateSmallDoorChildForward(StartPiece startPiece, StructurePieceAccessor pieces, RandomSource random, int offsetX, int offsetY) {
            Direction orientation = this.getOrientation();
            if (orientation != null) {
                switch (orientation) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.minX() + offsetX, this.boundingBox.minY() + offsetY, this.boundingBox.minZ() - 1, orientation, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.minX() + offsetX, this.boundingBox.minY() + offsetY, this.boundingBox.maxZ() + 1, orientation, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.minX() - 1, this.boundingBox.minY() + offsetY, this.boundingBox.minZ() + offsetX, orientation, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.maxX() + 1, this.boundingBox.minY() + offsetY, this.boundingBox.minZ() + offsetX, orientation, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        protected @Nullable StructurePiece generateSmallDoorChildLeft(StartPiece startPiece, StructurePieceAccessor pieces, RandomSource random, int offsetY, int offsetX) {
            Direction orientation = this.getOrientation();
            if (orientation != null) {
                switch (orientation) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.minX() - 1, this.boundingBox.minY() + offsetY, this.boundingBox.minZ() + offsetX, Direction.WEST, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.minX() - 1, this.boundingBox.minY() + offsetY, this.boundingBox.minZ() + offsetX, Direction.WEST, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.minX() + offsetX, this.boundingBox.minY() + offsetY, this.boundingBox.minZ() - 1, Direction.NORTH, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.minX() + offsetX, this.boundingBox.minY() + offsetY, this.boundingBox.minZ() - 1, Direction.NORTH, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        protected @Nullable StructurePiece generateSmallDoorChildRight(StartPiece startPiece, StructurePieceAccessor pieces, RandomSource random, int offsetY, int offsetX) {
            Direction orientation = this.getOrientation();
            if (orientation != null) {
                switch (orientation) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.maxX() + 1, this.boundingBox.minY() + offsetY, this.boundingBox.minZ() + offsetX, Direction.EAST, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.maxX() + 1, this.boundingBox.minY() + offsetY, this.boundingBox.minZ() + offsetX, Direction.EAST, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.minX() + offsetX, this.boundingBox.minY() + offsetY, this.boundingBox.maxZ() + 1, Direction.SOUTH, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(startPiece, pieces, random, this.boundingBox.minX() + offsetX, this.boundingBox.minY() + offsetY, this.boundingBox.maxZ() + 1, Direction.SOUTH, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        protected static boolean isOkBox(BoundingBox box) {
            return box.minY() > 10;
        }

        protected static enum SmallDoorType {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

            @Deprecated
            public static final Codec<SmallDoorType> LEGACY_CODEC;

            static {
                LEGACY_CODEC = ExtraCodecs.legacyEnum(SmallDoorType::valueOf);
            }
        }
    }

    public static class StartPiece
    extends StairsDown {
        public @Nullable PieceWeight previousPiece;
        public @Nullable PortalRoom portalRoomPiece;
        public final List<StructurePiece> pendingChildren = Lists.newArrayList();

        public StartPiece(RandomSource random, int x, int z) {
            super(StructurePieceType.STRONGHOLD_START, 0, x, z, StartPiece.getRandomHorizontalDirection(random));
        }

        public StartPiece(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_START, tag);
        }

        @Override
        public BlockPos getLocatorPosition() {
            return this.portalRoomPiece != null ? this.portalRoomPiece.getLocatorPosition() : super.getLocatorPosition();
        }
    }

    public static class FillerCorridor
    extends StrongholdPiece {
        private final int steps;

        public FillerCorridor(int genDepth, BoundingBox box, Direction orientation) {
            super(StructurePieceType.STRONGHOLD_FILLER_CORRIDOR, genDepth, box);
            this.setOrientation(orientation);
            this.steps = orientation != Direction.NORTH && orientation != Direction.SOUTH ? box.getXSpan() : box.getZSpan();
        }

        public FillerCorridor(CompoundTag tag) {
            super(StructurePieceType.STRONGHOLD_FILLER_CORRIDOR, tag);
            this.steps = tag.getIntOr("Steps", 0);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putInt("Steps", this.steps);
        }

        public static @Nullable BoundingBox findPieceBox(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction orientation) {
            int i = 3;
            BoundingBox boundingBox = BoundingBox.orientBox(x, y, z, -1, -1, 0, 5, 5, 4, orientation);
            StructurePiece structurePiece = pieces.findCollisionPiece(boundingBox);
            if (structurePiece == null) {
                return null;
            }
            if (structurePiece.getBoundingBox().minY() == boundingBox.minY()) {
                for (int i1 = 2; i1 >= 1; --i1) {
                    boundingBox = BoundingBox.orientBox(x, y, z, -1, -1, 0, 5, 5, i1, orientation);
                    if (structurePiece.getBoundingBox().intersects(boundingBox)) continue;
                    return BoundingBox.orientBox(x, y, z, -1, -1, 0, 5, 5, i1 + 1, orientation);
                }
            }
            return null;
        }

        @Override
        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            for (int i = 0; i < this.steps; ++i) {
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 0, 0, i, box);
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 1, 0, i, box);
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 2, 0, i, box);
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 3, 0, i, box);
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 4, 0, i, box);
                for (int i1 = 1; i1 <= 3; ++i1) {
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 0, i1, i, box);
                    this.placeBlock(level, Blocks.CAVE_AIR.defaultBlockState(), 1, i1, i, box);
                    this.placeBlock(level, Blocks.CAVE_AIR.defaultBlockState(), 2, i1, i, box);
                    this.placeBlock(level, Blocks.CAVE_AIR.defaultBlockState(), 3, i1, i, box);
                    this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 4, i1, i, box);
                }
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 0, 4, i, box);
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 1, 4, i, box);
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 2, 4, i, box);
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 3, 4, i, box);
                this.placeBlock(level, Blocks.STONE_BRICKS.defaultBlockState(), 4, 4, i, box);
            }
        }
    }

    static class SmoothStoneSelector
    extends StructurePiece.BlockSelector {
        SmoothStoneSelector() {
        }

        @Override
        public void next(RandomSource random, int x, int y, int z, boolean wall) {
            float randomFloat;
            this.next = wall ? ((randomFloat = random.nextFloat()) < 0.2f ? Blocks.CRACKED_STONE_BRICKS.defaultBlockState() : (randomFloat < 0.5f ? Blocks.MOSSY_STONE_BRICKS.defaultBlockState() : (randomFloat < 0.55f ? Blocks.INFESTED_STONE_BRICKS.defaultBlockState() : Blocks.STONE_BRICKS.defaultBlockState()))) : Blocks.CAVE_AIR.defaultBlockState();
        }
    }

    public static abstract class Turn
    extends StrongholdPiece {
        protected static final int WIDTH = 5;
        protected static final int HEIGHT = 5;
        protected static final int DEPTH = 5;

        protected Turn(StructurePieceType type, int genDepth, BoundingBox boundingBox) {
            super(type, genDepth, boundingBox);
        }

        public Turn(StructurePieceType type, CompoundTag tag) {
            super(type, tag);
        }
    }
}

