/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import org.jspecify.annotations.Nullable;

public class FlyNodeEvaluator
extends WalkNodeEvaluator {
    private final Long2ObjectMap<PathType> pathTypeByPosCache = new Long2ObjectOpenHashMap();
    private static final float SMALL_MOB_SIZE = 1.0f;
    private static final float SMALL_MOB_INFLATED_START_NODE_BOUNDING_BOX = 1.1f;
    private static final int MAX_START_NODE_CANDIDATES = 10;

    @Override
    public void prepare(PathNavigationRegion level, Mob mob) {
        super.prepare(level, mob);
        this.pathTypeByPosCache.clear();
        mob.onPathfindingStart();
    }

    @Override
    public void done() {
        this.mob.onPathfindingDone();
        this.pathTypeByPosCache.clear();
        super.done();
    }

    @Override
    public Node getStart() {
        BlockPos blockPos;
        int blockY;
        if (this.canFloat() && this.mob.isInWater()) {
            blockY = this.mob.getBlockY();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.mob.getX(), (double)blockY, this.mob.getZ());
            BlockState blockState = this.currentContext.getBlockState(mutableBlockPos);
            while (blockState.is(Blocks.WATER)) {
                mutableBlockPos.set(this.mob.getX(), (double)(++blockY), this.mob.getZ());
                blockState = this.currentContext.getBlockState(mutableBlockPos);
            }
        } else {
            blockY = Mth.floor(this.mob.getY() + 0.5);
        }
        if (!this.canStartAt(blockPos = BlockPos.containing(this.mob.getX(), blockY, this.mob.getZ()))) {
            for (BlockPos blockPos1 : this.iteratePathfindingStartNodeCandidatePositions(this.mob)) {
                if (!this.canStartAt(blockPos1)) continue;
                return super.getStartNode(blockPos1);
            }
        }
        return super.getStartNode(blockPos);
    }

    @Override
    protected boolean canStartAt(BlockPos pos) {
        PathType cachedPathType = this.getCachedPathType(pos.getX(), pos.getY(), pos.getZ());
        return this.mob.getPathfindingMalus(cachedPathType) >= 0.0f;
    }

    @Override
    public Target getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    @Override
    public int getNeighbors(Node[] outputArray, Node node) {
        Node node26;
        Node node25;
        Node node24;
        Node node23;
        Node node22;
        Node node21;
        Node node20;
        Node node19;
        Node node18;
        Node node17;
        Node node16;
        Node node15;
        Node node14;
        Node node13;
        Node node12;
        Node node11;
        Node node10;
        Node node9;
        Node node8;
        Node node7;
        Node node6;
        Node node5;
        Node node4;
        Node node3;
        Node node2;
        int i = 0;
        Node node1 = this.findAcceptedNode(node.x, node.y, node.z + 1);
        if (this.isOpen(node1)) {
            outputArray[i++] = node1;
        }
        if (this.isOpen(node2 = this.findAcceptedNode(node.x - 1, node.y, node.z))) {
            outputArray[i++] = node2;
        }
        if (this.isOpen(node3 = this.findAcceptedNode(node.x + 1, node.y, node.z))) {
            outputArray[i++] = node3;
        }
        if (this.isOpen(node4 = this.findAcceptedNode(node.x, node.y, node.z - 1))) {
            outputArray[i++] = node4;
        }
        if (this.isOpen(node5 = this.findAcceptedNode(node.x, node.y + 1, node.z))) {
            outputArray[i++] = node5;
        }
        if (this.isOpen(node6 = this.findAcceptedNode(node.x, node.y - 1, node.z))) {
            outputArray[i++] = node6;
        }
        if (this.isOpen(node7 = this.findAcceptedNode(node.x, node.y + 1, node.z + 1)) && this.hasMalus(node1) && this.hasMalus(node5)) {
            outputArray[i++] = node7;
        }
        if (this.isOpen(node8 = this.findAcceptedNode(node.x - 1, node.y + 1, node.z)) && this.hasMalus(node2) && this.hasMalus(node5)) {
            outputArray[i++] = node8;
        }
        if (this.isOpen(node9 = this.findAcceptedNode(node.x + 1, node.y + 1, node.z)) && this.hasMalus(node3) && this.hasMalus(node5)) {
            outputArray[i++] = node9;
        }
        if (this.isOpen(node10 = this.findAcceptedNode(node.x, node.y + 1, node.z - 1)) && this.hasMalus(node4) && this.hasMalus(node5)) {
            outputArray[i++] = node10;
        }
        if (this.isOpen(node11 = this.findAcceptedNode(node.x, node.y - 1, node.z + 1)) && this.hasMalus(node1) && this.hasMalus(node6)) {
            outputArray[i++] = node11;
        }
        if (this.isOpen(node12 = this.findAcceptedNode(node.x - 1, node.y - 1, node.z)) && this.hasMalus(node2) && this.hasMalus(node6)) {
            outputArray[i++] = node12;
        }
        if (this.isOpen(node13 = this.findAcceptedNode(node.x + 1, node.y - 1, node.z)) && this.hasMalus(node3) && this.hasMalus(node6)) {
            outputArray[i++] = node13;
        }
        if (this.isOpen(node14 = this.findAcceptedNode(node.x, node.y - 1, node.z - 1)) && this.hasMalus(node4) && this.hasMalus(node6)) {
            outputArray[i++] = node14;
        }
        if (this.isOpen(node15 = this.findAcceptedNode(node.x + 1, node.y, node.z - 1)) && this.hasMalus(node4) && this.hasMalus(node3)) {
            outputArray[i++] = node15;
        }
        if (this.isOpen(node16 = this.findAcceptedNode(node.x + 1, node.y, node.z + 1)) && this.hasMalus(node1) && this.hasMalus(node3)) {
            outputArray[i++] = node16;
        }
        if (this.isOpen(node17 = this.findAcceptedNode(node.x - 1, node.y, node.z - 1)) && this.hasMalus(node4) && this.hasMalus(node2)) {
            outputArray[i++] = node17;
        }
        if (this.isOpen(node18 = this.findAcceptedNode(node.x - 1, node.y, node.z + 1)) && this.hasMalus(node1) && this.hasMalus(node2)) {
            outputArray[i++] = node18;
        }
        if (this.isOpen(node19 = this.findAcceptedNode(node.x + 1, node.y + 1, node.z - 1)) && this.hasMalus(node15) && this.hasMalus(node4) && this.hasMalus(node3) && this.hasMalus(node5) && this.hasMalus(node10) && this.hasMalus(node9)) {
            outputArray[i++] = node19;
        }
        if (this.isOpen(node20 = this.findAcceptedNode(node.x + 1, node.y + 1, node.z + 1)) && this.hasMalus(node16) && this.hasMalus(node1) && this.hasMalus(node3) && this.hasMalus(node5) && this.hasMalus(node7) && this.hasMalus(node9)) {
            outputArray[i++] = node20;
        }
        if (this.isOpen(node21 = this.findAcceptedNode(node.x - 1, node.y + 1, node.z - 1)) && this.hasMalus(node17) && this.hasMalus(node4) && this.hasMalus(node2) && this.hasMalus(node5) && this.hasMalus(node10) && this.hasMalus(node8)) {
            outputArray[i++] = node21;
        }
        if (this.isOpen(node22 = this.findAcceptedNode(node.x - 1, node.y + 1, node.z + 1)) && this.hasMalus(node18) && this.hasMalus(node1) && this.hasMalus(node2) && this.hasMalus(node5) && this.hasMalus(node7) && this.hasMalus(node8)) {
            outputArray[i++] = node22;
        }
        if (this.isOpen(node23 = this.findAcceptedNode(node.x + 1, node.y - 1, node.z - 1)) && this.hasMalus(node15) && this.hasMalus(node4) && this.hasMalus(node3) && this.hasMalus(node6) && this.hasMalus(node14) && this.hasMalus(node13)) {
            outputArray[i++] = node23;
        }
        if (this.isOpen(node24 = this.findAcceptedNode(node.x + 1, node.y - 1, node.z + 1)) && this.hasMalus(node16) && this.hasMalus(node1) && this.hasMalus(node3) && this.hasMalus(node6) && this.hasMalus(node11) && this.hasMalus(node13)) {
            outputArray[i++] = node24;
        }
        if (this.isOpen(node25 = this.findAcceptedNode(node.x - 1, node.y - 1, node.z - 1)) && this.hasMalus(node17) && this.hasMalus(node4) && this.hasMalus(node2) && this.hasMalus(node6) && this.hasMalus(node14) && this.hasMalus(node12)) {
            outputArray[i++] = node25;
        }
        if (this.isOpen(node26 = this.findAcceptedNode(node.x - 1, node.y - 1, node.z + 1)) && this.hasMalus(node18) && this.hasMalus(node1) && this.hasMalus(node2) && this.hasMalus(node6) && this.hasMalus(node11) && this.hasMalus(node12)) {
            outputArray[i++] = node26;
        }
        return i;
    }

    private boolean hasMalus(@Nullable Node node) {
        return node != null && node.costMalus >= 0.0f;
    }

    private boolean isOpen(@Nullable Node node) {
        return node != null && !node.closed;
    }

    protected @Nullable Node findAcceptedNode(int x, int y, int z) {
        Node node = null;
        PathType cachedPathType = this.getCachedPathType(x, y, z);
        float pathfindingMalus = this.mob.getPathfindingMalus(cachedPathType);
        if (pathfindingMalus >= 0.0f) {
            node = this.getNode(x, y, z);
            node.type = cachedPathType;
            node.costMalus = Math.max(node.costMalus, pathfindingMalus);
            if (cachedPathType == PathType.WALKABLE) {
                node.costMalus += 1.0f;
            }
        }
        return node;
    }

    @Override
    protected PathType getCachedPathType(int x, int y, int z) {
        return (PathType)((Object)this.pathTypeByPosCache.computeIfAbsent(BlockPos.asLong(x, y, z), l -> this.getPathTypeOfMob(this.currentContext, x, y, z, this.mob)));
    }

    @Override
    public PathType getPathType(PathfindingContext context, int x, int y, int z) {
        PathType pathTypeFromState = context.getPathTypeFromState(x, y, z);
        if (pathTypeFromState == PathType.OPEN && y >= context.level().getMinY() + 1) {
            BlockPos blockPos = new BlockPos(x, y - 1, z);
            PathType pathTypeFromState1 = context.getPathTypeFromState(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            if (pathTypeFromState1 == PathType.DAMAGE_FIRE || pathTypeFromState1 == PathType.LAVA) {
                pathTypeFromState = PathType.DAMAGE_FIRE;
            } else if (pathTypeFromState1 == PathType.DAMAGE_OTHER) {
                pathTypeFromState = PathType.DAMAGE_OTHER;
            } else if (pathTypeFromState1 == PathType.COCOA) {
                pathTypeFromState = PathType.COCOA;
            } else if (pathTypeFromState1 == PathType.FENCE) {
                if (!blockPos.equals(context.mobPosition())) {
                    pathTypeFromState = PathType.FENCE;
                }
            } else {
                PathType pathType = pathTypeFromState = pathTypeFromState1 != PathType.WALKABLE && pathTypeFromState1 != PathType.OPEN && pathTypeFromState1 != PathType.WATER ? PathType.WALKABLE : PathType.OPEN;
            }
        }
        if (pathTypeFromState == PathType.WALKABLE || pathTypeFromState == PathType.OPEN) {
            pathTypeFromState = FlyNodeEvaluator.checkNeighbourBlocks(context, x, y, z, pathTypeFromState);
        }
        return pathTypeFromState;
    }

    private Iterable<BlockPos> iteratePathfindingStartNodeCandidatePositions(Mob mob) {
        boolean flag;
        AABB boundingBox = mob.getBoundingBox();
        boolean bl = flag = boundingBox.getSize() < 1.0;
        if (!flag) {
            return List.of(BlockPos.containing(boundingBox.minX, mob.getBlockY(), boundingBox.minZ), BlockPos.containing(boundingBox.minX, mob.getBlockY(), boundingBox.maxZ), BlockPos.containing(boundingBox.maxX, mob.getBlockY(), boundingBox.minZ), BlockPos.containing(boundingBox.maxX, mob.getBlockY(), boundingBox.maxZ));
        }
        double max = Math.max(0.0, (double)1.1f - boundingBox.getZsize());
        double max1 = Math.max(0.0, (double)1.1f - boundingBox.getXsize());
        double max2 = Math.max(0.0, (double)1.1f - boundingBox.getYsize());
        AABB aabb = boundingBox.inflate(max1, max2, max);
        return BlockPos.randomBetweenClosed(mob.getRandom(), 10, Mth.floor(aabb.minX), Mth.floor(aabb.minY), Mth.floor(aabb.minZ), Mth.floor(aabb.maxX), Mth.floor(aabb.maxY), Mth.floor(aabb.maxZ));
    }
}

