/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import io.papermc.paper.configuration.WorldConfiguration;
import net.minecraft.core.Direction;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.redstone.Orientation;
import org.jspecify.annotations.Nullable;

public class ExperimentalRedstoneUtils {
    public static @Nullable Orientation initialOrientation(Level level, @Nullable Direction front, @Nullable Direction up) {
        if (level.enabledFeatures().contains(FeatureFlags.REDSTONE_EXPERIMENTS)) {
            Orientation orientation = Orientation.random(level.random).withSideBias(Orientation.SideBias.LEFT);
            if (up != null) {
                orientation = orientation.withUp(up);
            }
            if (front != null) {
                orientation = orientation.withFront(front);
            } else if (level.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                orientation = orientation.withFront(Direction.WEST);
            }
            return orientation;
        }
        return null;
    }

    public static @Nullable Orientation withFront(@Nullable Orientation orientation, Direction direction) {
        return orientation == null ? null : orientation.withFront(direction);
    }
}

