/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import java.util.Locale;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.jspecify.annotations.Nullable;

public interface NeighborUpdater {
    public static final Direction[] UPDATE_ORDER = new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH};

    public void shapeUpdate(Direction var1, BlockState var2, BlockPos var3, BlockPos var4, @Block.UpdateFlags int var5, int var6);

    public void neighborChanged(BlockPos var1, Block var2, @Nullable Orientation var3);

    public void neighborChanged(BlockState var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5);

    default public void updateNeighborsAtExceptFromFacing(BlockPos pos, Block block, @Nullable Direction facing, @Nullable Orientation orientation) {
        for (Direction direction : UPDATE_ORDER) {
            if (direction == facing) continue;
            this.neighborChanged(pos.relative(direction), block, null);
        }
    }

    public static void executeShapeUpdate(LevelAccessor level, Direction direction, BlockPos pos, BlockPos neighborPos, BlockState neighborState, @Block.UpdateFlags int flags, int recursionLeft) {
        BlockState blockState = level.getBlockState(pos);
        if ((flags & 0x80) == 0 || !blockState.is(Blocks.REDSTONE_WIRE)) {
            BlockState blockState1 = blockState.updateShape(level, level, pos, direction, neighborPos, neighborState, level.getRandom());
            Block.updateOrDestroy(blockState, blockState1, level, pos, flags, recursionLeft);
        }
    }

    public static void executeUpdate(Level level, BlockState state, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        NeighborUpdater.executeUpdate(level, state, pos, neighborBlock, orientation, movedByPiston, pos);
    }

    public static void executeUpdate(Level level, BlockState state, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston, BlockPos sourcePos) {
        try {
            BlockPhysicsEvent event = new BlockPhysicsEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), (BlockData)CraftBlockData.fromData(state), (org.bukkit.block.Block)CraftBlock.at(level, sourcePos));
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            state.handleNeighborChanged(level, pos, neighborBlock, orientation, movedByPiston);
        }
        catch (StackOverflowError ex) {
            Level.lastPhysicsProblem = pos.immutable();
        }
        catch (Throwable var9) {
            CrashReport crashReport = CrashReport.forThrowable(var9, "Exception while updating neighbours");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Block being updated");
            crashReportCategory.setDetail("Source block type", () -> {
                try {
                    return String.format(Locale.ROOT, "ID #%s (%s // %s)", BuiltInRegistries.BLOCK.getKey(neighborBlock), neighborBlock.getDescriptionId(), neighborBlock.getClass().getCanonicalName());
                }
                catch (Throwable var2x) {
                    return "ID #" + String.valueOf(BuiltInRegistries.BLOCK.getKey(neighborBlock));
                }
            });
            CrashReportCategory.populateBlockDetails(crashReportCategory, level, pos, state);
            throw new ReportedException(crashReport);
        }
    }
}

