/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jspecify.annotations.Nullable;

public class CommandStorage {
    private static final String ID_PREFIX = "command_storage_";
    private final Map<String, Container> namespaces = new HashMap<String, Container>();
    private final DimensionDataStorage storage;

    public CommandStorage(DimensionDataStorage storage) {
        this.storage = storage;
    }

    public CompoundTag get(Identifier id) {
        Container container = this.getContainer(id.getNamespace());
        return container != null ? container.get(id.getPath()) : new CompoundTag();
    }

    private @Nullable Container getContainer(String namespace) {
        Container container = this.namespaces.get(namespace);
        if (container != null) {
            return container;
        }
        Container container1 = this.storage.get(Container.type(namespace));
        if (container1 != null) {
            this.namespaces.put(namespace, container1);
        }
        return container1;
    }

    private Container getOrCreateContainer(String namespace) {
        Container container = this.namespaces.get(namespace);
        if (container != null) {
            return container;
        }
        Container container1 = this.storage.computeIfAbsent(Container.type(namespace));
        this.namespaces.put(namespace, container1);
        return container1;
    }

    public void set(Identifier id, CompoundTag tag) {
        this.getOrCreateContainer(id.getNamespace()).put(id.getPath(), tag);
    }

    public Stream<Identifier> keys() {
        return this.namespaces.entrySet().stream().flatMap(entry -> ((Container)entry.getValue()).getKeys((String)entry.getKey()));
    }

    static String createId(String namespace) {
        return ID_PREFIX + namespace;
    }

    static class Container
    extends SavedData {
        public static final Codec<Container> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(ExtraCodecs.RESOURCE_PATH_CODEC, CompoundTag.CODEC).fieldOf("contents").forGetter(container -> container.storage)).apply((Applicative)instance, Container::new));
        private final Map<String, CompoundTag> storage;

        private Container(Map<String, CompoundTag> storage) {
            this.storage = new HashMap<String, CompoundTag>(storage);
        }

        private Container() {
            this(new HashMap<String, CompoundTag>());
        }

        public static SavedDataType<Container> type(String namespace) {
            return new SavedDataType<Container>(CommandStorage.createId(namespace), Container::new, CODEC, DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
        }

        public CompoundTag get(String id) {
            CompoundTag compoundTag = this.storage.get(id);
            return compoundTag != null ? compoundTag : new CompoundTag();
        }

        public void put(String id, CompoundTag tag) {
            if (tag.isEmpty()) {
                this.storage.remove(id);
            } else {
                this.storage.put(id, tag);
            }
            this.setDirty();
        }

        public Stream<Identifier> getKeys(String namespace) {
            return this.storage.keySet().stream().map(string -> Identifier.fromNamespaceAndPath(namespace, string));
        }
    }
}

