/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootPool {
    public static final Codec<LootPool> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LootPoolEntries.CODEC.listOf().fieldOf("entries").forGetter(lootPool -> lootPool.entries), (App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(lootPool -> lootPool.conditions), (App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(lootPool -> lootPool.functions), (App)NumberProviders.CODEC.fieldOf("rolls").forGetter(lootPool -> lootPool.rolls), (App)NumberProviders.CODEC.fieldOf("bonus_rolls").orElse((Object)ConstantValue.exactly(0.0f)).forGetter(lootPool -> lootPool.bonusRolls)).apply((Applicative)instance, LootPool::new));
    private final List<LootPoolEntryContainer> entries;
    private final List<LootItemCondition> conditions;
    private final Predicate<LootContext> compositeCondition;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;
    private final NumberProvider rolls;
    private final NumberProvider bonusRolls;

    LootPool(List<LootPoolEntryContainer> entries, List<LootItemCondition> conditions, List<LootItemFunction> functions, NumberProvider rolls, NumberProvider bonusRolls) {
        this.entries = entries;
        this.conditions = conditions;
        this.compositeCondition = Util.allOf(conditions);
        this.functions = functions;
        this.compositeFunction = LootItemFunctions.compose(functions);
        this.rolls = rolls;
        this.bonusRolls = bonusRolls;
    }

    private void addRandomItem(Consumer<ItemStack> stackConsumer, LootContext context) {
        RandomSource random = context.getRandom();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableInt = new MutableInt();
        for (LootPoolEntryContainer lootPoolEntryContainer : this.entries) {
            lootPoolEntryContainer.expand(context, lootPoolEntry1 -> {
                int weight = lootPoolEntry1.getWeight(context.getLuck());
                if (weight > 0) {
                    list.add(lootPoolEntry1);
                    mutableInt.add(weight);
                }
            });
        }
        int size = list.size();
        if (mutableInt.intValue() != 0 && size != 0) {
            if (size == 1) {
                ((LootPoolEntry)list.get(0)).createItemStack(stackConsumer, context);
            } else {
                int randomInt = random.nextInt(mutableInt.intValue());
                for (LootPoolEntry lootPoolEntry : list) {
                    if ((randomInt -= lootPoolEntry.getWeight(context.getLuck())) >= 0) continue;
                    lootPoolEntry.createItemStack(stackConsumer, context);
                    return;
                }
            }
        }
    }

    public void addRandomItems(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        if (this.compositeCondition.test(lootContext)) {
            Consumer<ItemStack> consumer = LootItemFunction.decorate(this.compositeFunction, stackConsumer, lootContext);
            int i = this.rolls.getInt(lootContext) + Mth.floor(this.bonusRolls.getFloat(lootContext) * lootContext.getLuck());
            for (int i1 = 0; i1 < i; ++i1) {
                this.addRandomItem(consumer, lootContext);
            }
        }
    }

    public void validate(ValidationContext context) {
        int i;
        for (i = 0; i < this.conditions.size(); ++i) {
            this.conditions.get(i).validate(context.forChild(new ProblemReporter.IndexedFieldPathElement("conditions", i)));
        }
        for (i = 0; i < this.functions.size(); ++i) {
            this.functions.get(i).validate(context.forChild(new ProblemReporter.IndexedFieldPathElement("functions", i)));
        }
        for (i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).validate(context.forChild(new ProblemReporter.IndexedFieldPathElement("entries", i)));
        }
        this.rolls.validate(context.forChild(new ProblemReporter.FieldPathElement("rolls")));
        this.bonusRolls.validate(context.forChild(new ProblemReporter.FieldPathElement("bonus_rolls")));
    }

    public static Builder lootPool() {
        return new Builder();
    }

    public static class Builder
    implements FunctionUserBuilder<Builder>,
    ConditionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemCondition> conditions = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();
        private NumberProvider rolls = ConstantValue.exactly(1.0f);
        private NumberProvider bonusRolls = ConstantValue.exactly(0.0f);

        public Builder setRolls(NumberProvider rolls) {
            this.rolls = rolls;
            return this;
        }

        @Override
        public Builder unwrap() {
            return this;
        }

        public Builder setBonusRolls(NumberProvider bonusRolls) {
            this.bonusRolls = bonusRolls;
            return this;
        }

        public Builder add(LootPoolEntryContainer.Builder<?> entriesBuilder) {
            this.entries.add((Object)entriesBuilder.build());
            return this;
        }

        @Override
        public Builder when(LootItemCondition.Builder conditionBuilder) {
            this.conditions.add((Object)conditionBuilder.build());
            return this;
        }

        @Override
        public Builder apply(LootItemFunction.Builder functionBuilder) {
            this.functions.add((Object)functionBuilder.build());
            return this;
        }

        public LootPool build() {
            return new LootPool((List<LootPoolEntryContainer>)this.entries.build(), (List<LootItemCondition>)this.conditions.build(), (List<LootItemFunction>)this.functions.build(), this.rolls, this.bonusRolls);
        }
    }
}

