/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class SetNameFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SetNameFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetNameFunction.commonFields(instance).and(instance.group((App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(setNameFunction -> setNameFunction.name), (App)LootContext.EntityTarget.CODEC.optionalFieldOf("entity").forGetter(setNameFunction -> setNameFunction.resolutionContext), (App)Target.CODEC.optionalFieldOf("target", (Object)Target.CUSTOM_NAME).forGetter(setNameFunction -> setNameFunction.target))).apply((Applicative)instance, SetNameFunction::new));
    private final Optional<Component> name;
    private final Optional<LootContext.EntityTarget> resolutionContext;
    private final Target target;

    private SetNameFunction(List<LootItemCondition> predicates, Optional<Component> name, Optional<LootContext.EntityTarget> resolutionContext, Target target) {
        super(predicates);
        this.name = name;
        this.resolutionContext = resolutionContext;
        this.target = target;
    }

    public LootItemFunctionType<SetNameFunction> getType() {
        return LootItemFunctions.SET_NAME;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.resolutionContext.map(entityTarget -> Set.of(entityTarget.contextParam())).orElse(Set.of());
    }

    public static UnaryOperator<Component> createResolver(LootContext lootContext, @Nullable LootContext.EntityTarget resolutionContext) {
        Entity entity;
        if (resolutionContext != null && (entity = lootContext.getOptionalParameter(resolutionContext.contextParam())) != null) {
            CommandSourceStack commandSourceStack = entity.createCommandSourceStackForNameResolution(lootContext.getLevel()).withPermission(LevelBasedPermissionSet.GAMEMASTER);
            return component -> {
                try {
                    return ComponentUtils.updateForEntity(commandSourceStack, component, entity, 0);
                }
                catch (CommandSyntaxException var4) {
                    LOGGER.warn("Failed to resolve text component", (Throwable)var4);
                    return component;
                }
            };
        }
        return component -> component;
    }

    @Override
    public ItemStack run(ItemStack stack, LootContext context) {
        this.name.ifPresent(component -> stack.set(this.target.component(), (Component)SetNameFunction.createResolver(context, this.resolutionContext.orElse(null)).apply((Component)component)));
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> setName(Component name, Target target) {
        return SetNameFunction.simpleBuilder(list -> new SetNameFunction((List<LootItemCondition>)list, Optional.of(name), Optional.empty(), target));
    }

    public static LootItemConditionalFunction.Builder<?> setName(Component name, Target target, LootContext.EntityTarget resolutionContext) {
        return SetNameFunction.simpleBuilder(list -> new SetNameFunction((List<LootItemCondition>)list, Optional.of(name), Optional.of(resolutionContext), target));
    }

    public static enum Target implements StringRepresentable
    {
        CUSTOM_NAME("custom_name"),
        ITEM_NAME("item_name");

        public static final Codec<Target> CODEC;
        private final String name;

        private Target(String name) {
            this.name = name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public DataComponentType<Component> component() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> DataComponents.CUSTOM_NAME;
                case 1 -> DataComponents.ITEM_NAME;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(Target::values);
        }
    }
}

