/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.util.Holderable;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.Instrument;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftSound;
import org.jetbrains.annotations.NotNull;

public class CraftMusicInstrument
extends MusicInstrument
implements Holderable<Instrument> {
    private final Holder<Instrument> holder;

    public static MusicInstrument minecraftHolderToBukkit(Holder<Instrument> minecraft) {
        return (MusicInstrument)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.INSTRUMENT);
    }

    public static Holder<Instrument> bukkitToMinecraftHolder(MusicInstrument bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit);
    }

    public static Object bukkitToString(MusicInstrument bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((CraftMusicInstrument)bukkit).toBukkitSerializationObject(Instrument.DIRECT_CODEC);
    }

    public static MusicInstrument stringToBukkit(Object string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        return (MusicInstrument)Holderable.fromBukkitSerializationObject(string, Instrument.CODEC, RegistryKey.INSTRUMENT);
    }

    public boolean equals(Object o) {
        return this.implEquals(o);
    }

    public int hashCode() {
        return this.implHashCode();
    }

    public String toString() {
        return this.implToString();
    }

    public CraftMusicInstrument(Holder<Instrument> holder) {
        this.holder = holder;
    }

    @Override
    public Holder<Instrument> getHolder() {
        return this.holder;
    }

    public float getDuration() {
        return ((Instrument)this.getHandle()).useDuration();
    }

    public float getRange() {
        return ((Instrument)this.getHandle()).range();
    }

    public Component description() {
        return PaperAdventure.asAdventure(((Instrument)this.getHandle()).description());
    }

    public Sound getSound() {
        return CraftSound.minecraftHolderToBukkit(((Instrument)this.getHandle()).soundEvent());
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return Holderable.super.getKey();
    }

    @NotNull
    public String translationKey() {
        ComponentContents componentContents = ((Instrument)this.getHandle()).description().getContents();
        if (!(componentContents instanceof TranslatableContents)) {
            throw new UnsupportedOperationException("Description isn't translatable!");
        }
        TranslatableContents translatableContents = (TranslatableContents)componentContents;
        return translatableContents.getKey();
    }
}

