/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.advancement;

import com.google.common.collect.ImmutableList;
import io.papermc.paper.advancement.AdvancementDisplay;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.server.MinecraftServer;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.AdvancementRequirements;
import org.bukkit.craftbukkit.advancement.CraftAdvancementDisplay;
import org.bukkit.craftbukkit.advancement.CraftAdvancementRequirements;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;

public class CraftAdvancement
implements org.bukkit.advancement.Advancement {
    private final AdvancementHolder handle;

    public CraftAdvancement(AdvancementHolder handle) {
        this.handle = handle;
    }

    public AdvancementHolder getHandle() {
        return this.handle;
    }

    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.handle.id());
    }

    public Collection<String> getCriteria() {
        return Collections.unmodifiableCollection(this.handle.value().criteria().keySet());
    }

    public AdvancementRequirements getRequirements() {
        return new CraftAdvancementRequirements(this.handle.value().requirements());
    }

    public AdvancementDisplay getDisplay() {
        return this.handle.value().display().map(d -> d.paper).orElse(null);
    }

    @Deprecated
    public org.bukkit.advancement.AdvancementDisplay getDisplay0() {
        return this.handle.value().display().map(CraftAdvancementDisplay::new).orElse(null);
    }

    public Component displayName() {
        return PaperAdventure.asAdventure(Advancement.name(this.handle));
    }

    public org.bukkit.advancement.Advancement getParent() {
        return this.handle.value().parent().map(MinecraftServer.getServer().getAdvancements()::get).map(AdvancementHolder::toBukkit).orElse(null);
    }

    public Collection<org.bukkit.advancement.Advancement> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        AdvancementNode advancementNode = MinecraftServer.getServer().getAdvancements().tree().get(this.handle);
        if (advancementNode != null) {
            for (AdvancementNode child : advancementNode.children()) {
                children.add((Object)child.holder().toBukkit());
            }
        }
        return children.build();
    }

    public org.bukkit.advancement.Advancement getRoot() {
        AdvancementNode advancementNode = MinecraftServer.getServer().getAdvancements().tree().get(this.handle);
        return Objects.requireNonNull(advancementNode, "could not find internal advancement node for advancement " + String.valueOf(this.handle.id())).root().holder().toBukkit();
    }
}

