/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.attribute;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.util.OldEnumHolderable;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.util.ApiVersion;

public class CraftAttribute
extends OldEnumHolderable<Attribute, net.minecraft.world.entity.ai.attributes.Attribute>
implements Attribute {
    private static int count = 0;

    public static Attribute minecraftHolderToBukkit(Holder<net.minecraft.world.entity.ai.attributes.Attribute> minecraft) {
        return (Attribute)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.ATTRIBUTE);
    }

    public static Attribute stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertAttributeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        if (key == null) {
            return null;
        }
        return (Attribute)CraftRegistry.get(RegistryKey.ATTRIBUTE, key, ApiVersion.CURRENT);
    }

    public static Holder<net.minecraft.world.entity.ai.attributes.Attribute> bukkitToMinecraftHolder(Attribute bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit);
    }

    public static String bukkitToString(Attribute bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public CraftAttribute(Holder<net.minecraft.world.entity.ai.attributes.Attribute> holder) {
        super(holder, count++);
    }

    public Attribute.Sentiment getSentiment() {
        return Attribute.Sentiment.valueOf((String)((net.minecraft.world.entity.ai.attributes.Attribute)this.getHandle()).sentiment.name());
    }

    public String getTranslationKey() {
        return ((net.minecraft.world.entity.ai.attributes.Attribute)this.getHandle()).getDescriptionId();
    }

    public String translationKey() {
        return ((net.minecraft.world.entity.ai.attributes.Attribute)this.getHandle()).getDescriptionId();
    }
}

