/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.mojang.logging.LogUtils;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class CraftBlockEntityState<T extends BlockEntity>
extends CraftBlockState
implements TileState {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final T blockEntity;
    private final T snapshot;
    public boolean snapshotDisabled;
    public static boolean DISABLE_SNAPSHOT = false;

    public CraftBlockEntityState(World world, T blockEntity) {
        super(world, ((BlockEntity)blockEntity).getBlockPos(), ((BlockEntity)blockEntity).getBlockState());
        this.blockEntity = blockEntity;
        try {
            this.snapshotDisabled = DISABLE_SNAPSHOT;
            this.snapshot = DISABLE_SNAPSHOT ? this.blockEntity : this.createSnapshot(blockEntity);
            if (this.snapshot != null) {
                this.load(this.snapshot);
            }
        }
        catch (Throwable thr) {
            if (thr instanceof ThreadDeath) {
                throw (ThreadDeath)thr;
            }
            throw new RuntimeException((String)(world == null ? "Failed to read non-placed BlockState" : "Failed to read BlockState at: world: " + world.getName() + " location: (" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")"), thr);
        }
    }

    protected CraftBlockEntityState(CraftBlockEntityState<T> state, Location location) {
        super(state, location);
        this.blockEntity = this.createSnapshot(state.snapshot);
        this.snapshot = this.blockEntity;
        this.loadData(state.getSnapshotNBT());
    }

    public RegistryAccess getRegistryAccess() {
        LevelAccessor worldHandle = this.getWorldHandle();
        return worldHandle != null ? worldHandle.registryAccess() : CraftRegistry.getMinecraftRegistry();
    }

    private T createSnapshot(T from) {
        if (from == null) {
            return null;
        }
        CompoundTag tag = ((BlockEntity)from).saveWithFullMetadata(this.getRegistryAccess());
        return (T)BlockEntity.loadStatic(this.getPosition(), this.getHandle(), tag, this.getRegistryAccess());
    }

    public Set<DataComponentType<?>> applyComponents(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        Set<DataComponentType<?>> result = ((BlockEntity)this.snapshot).applyComponentsSet(datacomponentmap, datacomponentpatch);
        this.load(this.snapshot);
        return result;
    }

    public DataComponentMap collectComponents() {
        return ((BlockEntity)this.snapshot).collectComponents();
    }

    public void loadData(CompoundTag tag) {
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "CraftBlockEntityState@" + this.getPosition().toShortString(), LOGGER);){
            ((BlockEntity)this.snapshot).loadWithComponents(TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)this.getRegistryAccess(), tag));
        }
        this.load(this.snapshot);
    }

    private void copyData(T from, T to) {
        CompoundTag tag = ((BlockEntity)from).saveWithFullMetadata(this.getRegistryAccess());
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "CraftBlockEntityState@" + this.getPosition().toShortString(), LOGGER);){
            ((BlockEntity)to).loadWithComponents(TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)this.getRegistryAccess(), tag));
        }
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected BlockEntity getBlockEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().getBlockEntity(this.getPosition());
    }

    public CompoundTag getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return ((BlockEntity)this.snapshot).saveWithFullMetadata(this.getRegistryAccess());
    }

    public CompoundTag getUpdateNBT() {
        this.applyTo(this.snapshot);
        return ((BlockEntity)this.snapshot).getUpdateTag(this.getRegistryAccess());
    }

    public CompoundTag getSnapshotCustomNbtOnly() {
        this.applyTo(this.snapshot);
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "CraftBlockEntityState@" + this.getPosition().toShortString(), LOGGER);){
            TagValueOutput output = TagValueOutput.createWrappingWithContext(problemReporter, this.getRegistryAccess(), ((BlockEntity)this.snapshot).saveCustomOnly(this.getRegistryAccess()));
            ((BlockEntity)this.snapshot).removeComponentsFromTag(output);
            if (!output.isEmpty()) {
                ((BlockEntity)this.snapshot).saveId(output);
            }
            CompoundTag compoundTag = output.buildResult();
            return compoundTag;
        }
    }

    protected void load(T blockEntity) {
        if (blockEntity != null && blockEntity != this.snapshot) {
            this.copyData(blockEntity, this.snapshot);
        }
    }

    protected void applyTo(T blockEntity) {
        if (blockEntity != null && blockEntity != this.snapshot) {
            this.copyData(this.snapshot, blockEntity);
        }
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced()) {
            this.getWorldHandle().getBlockEntity(this.getPosition(), ((BlockEntity)this.blockEntity).getType()).ifPresent(blockEntity -> {
                this.applyTo(blockEntity);
                blockEntity.setChanged();
            });
        }
        return result;
    }

    @Override
    public boolean place(@Block.UpdateFlags int flags) {
        boolean result = super.place(flags);
        this.getWorldHandle().getBlockEntity(this.getPosition(), ((BlockEntity)this.blockEntity).getType()).ifPresent(blockEntity -> {
            this.applyTo(blockEntity);
            blockEntity.setChanged();
        });
        return result;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return ((BlockEntity)this.getSnapshot()).persistentDataContainer;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket(@NotNull Location location) {
        return new ClientboundBlockEntityDataPacket(CraftLocation.toBlockPosition(location), ((BlockEntity)this.snapshot).getType(), this.getUpdateNBT());
    }

    @Override
    public abstract CraftBlockEntityState<T> copy();

    @Override
    public abstract CraftBlockEntityState<T> copy(Location var1);

    public boolean isSnapshot() {
        return !this.snapshotDisabled;
    }
}

