/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Campfire;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.inventory.CraftItemStack;

public class CraftCampfire
extends CraftBlockEntityState<CampfireBlockEntity>
implements Campfire {
    public CraftCampfire(World world, CampfireBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftCampfire(CraftCampfire state, Location location) {
        super(state, location);
    }

    public int getSize() {
        return ((CampfireBlockEntity)this.getSnapshot()).getItems().size();
    }

    public org.bukkit.inventory.ItemStack getItem(int index) {
        ItemStack item = ((CampfireBlockEntity)this.getSnapshot()).getItems().get(index);
        return item.isEmpty() ? null : CraftItemStack.asCraftMirror(item);
    }

    public void setItem(int index, org.bukkit.inventory.ItemStack item) {
        ((CampfireBlockEntity)this.getSnapshot()).getItems().set(index, CraftItemStack.asNMSCopy(item));
    }

    public int getCookTime(int index) {
        return ((CampfireBlockEntity)this.getSnapshot()).cookingProgress[index];
    }

    public void setCookTime(int index, int cookTime) {
        ((CampfireBlockEntity)this.getSnapshot()).cookingProgress[index] = cookTime;
    }

    public int getCookTimeTotal(int index) {
        return ((CampfireBlockEntity)this.getSnapshot()).cookingTime[index];
    }

    public void setCookTimeTotal(int index, int cookTimeTotal) {
        ((CampfireBlockEntity)this.getSnapshot()).cookingTime[index] = cookTimeTotal;
    }

    @Override
    public CraftCampfire copy() {
        return new CraftCampfire(this, null);
    }

    @Override
    public CraftCampfire copy(Location location) {
        return new CraftCampfire(this, location);
    }

    public void stopCooking() {
        for (int i = 0; i < ((CampfireBlockEntity)this.getSnapshot()).stopCooking.length; ++i) {
            this.stopCooking(i);
        }
    }

    public void startCooking() {
        for (int i = 0; i < ((CampfireBlockEntity)this.getSnapshot()).stopCooking.length; ++i) {
            this.startCooking(i);
        }
    }

    public boolean stopCooking(int index) {
        Preconditions.checkArgument((-1 < index && index < 4 ? 1 : 0) != 0, (Object)"Slot index must be between 0 (incl) to 3 (incl)");
        boolean previous = this.isCookingDisabled(index);
        ((CampfireBlockEntity)this.getSnapshot()).stopCooking[index] = true;
        return previous;
    }

    public boolean startCooking(int index) {
        Preconditions.checkArgument((-1 < index && index < 4 ? 1 : 0) != 0, (Object)"Slot index must be between 0 (incl) to 3 (incl)");
        boolean previous = this.isCookingDisabled(index);
        ((CampfireBlockEntity)this.getSnapshot()).stopCooking[index] = false;
        return previous;
    }

    public boolean isCookingDisabled(int index) {
        Preconditions.checkArgument((-1 < index && index < 4 ? 1 : 0) != 0, (Object)"Slot index must be between 0 (incl) to 3 (incl)");
        return ((CampfireBlockEntity)this.getSnapshot()).stopCooking[index];
    }
}

