/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.LockCode;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Container;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.inventory.ItemStack;

public abstract class CraftContainer<T extends BaseContainerBlockEntity>
extends CraftBlockEntityState<T>
implements Container {
    public CraftContainer(World world, T blockEntity) {
        super(world, blockEntity);
    }

    protected CraftContainer(CraftContainer<T> state, Location location) {
        super(state, location);
    }

    public boolean isLocked() {
        return ((BaseContainerBlockEntity)this.getSnapshot()).lockKey != LockCode.NO_LOCK;
    }

    public String getLock() {
        Optional<Component> customName = ((BaseContainerBlockEntity)this.getSnapshot()).lockKey.predicate().components().exact().asPatch().get(DataComponents.CUSTOM_NAME);
        return customName != null ? customName.map(CraftChatMessage::fromComponent).orElse("") : "";
    }

    public void setLock(String key) {
        if (key == null) {
            ((BaseContainerBlockEntity)this.getSnapshot()).lockKey = LockCode.NO_LOCK;
        } else {
            DataComponentExactPredicate predicate = DataComponentExactPredicate.builder().expect(DataComponents.CUSTOM_NAME, CraftChatMessage.fromStringOrNull(key)).build();
            ((BaseContainerBlockEntity)this.getSnapshot()).lockKey = new LockCode(new ItemPredicate(Optional.empty(), MinMaxBounds.Ints.ANY, new DataComponentMatchers(predicate, Collections.emptyMap())));
        }
    }

    public void setLockItem(ItemStack key) {
        ((BaseContainerBlockEntity)this.getSnapshot()).lockKey = key == null ? LockCode.NO_LOCK : new LockCode(CraftItemStack.asCriterionConditionItem(key));
    }

    public net.kyori.adventure.text.Component customName() {
        BaseContainerBlockEntity blockEntity = (BaseContainerBlockEntity)this.getSnapshot();
        return blockEntity.hasCustomName() ? PaperAdventure.asAdventure(blockEntity.getCustomName()) : null;
    }

    public void customName(net.kyori.adventure.text.Component customName) {
        ((BaseContainerBlockEntity)this.getSnapshot()).name = customName != null ? PaperAdventure.asVanilla(customName) : null;
    }

    public String getCustomName() {
        BaseContainerBlockEntity container = (BaseContainerBlockEntity)this.getSnapshot();
        return container.name != null ? CraftChatMessage.fromComponent(container.getCustomName()) : null;
    }

    public void setCustomName(String name) {
        ((BaseContainerBlockEntity)this.getSnapshot()).name = CraftChatMessage.fromStringOrNull(name);
    }

    @Override
    public void applyTo(T blockEntity) {
        super.applyTo(blockEntity);
        if (((BaseContainerBlockEntity)this.getSnapshot()).name == null) {
            ((BaseContainerBlockEntity)blockEntity).name = null;
        }
    }

    @Override
    public abstract CraftContainer<T> copy();

    @Override
    public abstract CraftContainer<T> copy(Location var1);
}

