/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.DecoratedPot;
import org.bukkit.craftbukkit.CraftLootTable;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.inventory.CraftInventoryDecoratedPot;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.inventory.DecoratedPotInventory;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class CraftDecoratedPot
extends CraftBlockEntityState<DecoratedPotBlockEntity>
implements DecoratedPot {
    public CraftDecoratedPot(World world, DecoratedPotBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftDecoratedPot(CraftDecoratedPot state, Location location) {
        super(state, location);
    }

    public DecoratedPotInventory getSnapshotInventory() {
        return new CraftInventoryDecoratedPot((Container)this.getSnapshot());
    }

    public DecoratedPotInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryDecoratedPot((Container)this.getBlockEntity());
    }

    public void setLootTable(LootTable table) {
        this.setLootTable(table, this.getSeed());
    }

    public void setLootTable(LootTable table, long seed) {
        ((DecoratedPotBlockEntity)this.getSnapshot()).setLootTable(CraftLootTable.bukkitToMinecraft(table), seed);
    }

    public LootTable getLootTable() {
        return CraftLootTable.minecraftToBukkit(((DecoratedPotBlockEntity)this.getSnapshot()).getLootTable());
    }

    public void setSeed(long seed) {
        ((DecoratedPotBlockEntity)this.getSnapshot()).setLootTableSeed(seed);
    }

    public long getSeed() {
        return ((DecoratedPotBlockEntity)this.getSnapshot()).getLootTableSeed();
    }

    public void setSherd(DecoratedPot.Side face, Material sherd) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((sherd == null || sherd == Material.BRICK || Tag.ITEMS_DECORATED_POT_SHERDS.isTagged((Keyed)sherd) ? 1 : 0) != 0, (String)"sherd is not a valid sherd material: %s", (Object)sherd);
        Optional<Item> sherdItem = sherd != null ? Optional.of(CraftItemType.bukkitToMinecraft(sherd)) : Optional.of(Items.BRICK);
        PotDecorations decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).getDecorations();
        switch (face) {
            case BACK: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).decorations = new PotDecorations(sherdItem, decorations.left(), decorations.right(), decorations.front());
                break;
            }
            case LEFT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).decorations = new PotDecorations(decorations.back(), sherdItem, decorations.right(), decorations.front());
                break;
            }
            case RIGHT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).decorations = new PotDecorations(decorations.back(), decorations.left(), sherdItem, decorations.front());
                break;
            }
            case FRONT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).decorations = new PotDecorations(decorations.back(), decorations.left(), decorations.right(), sherdItem);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(face));
            }
        }
    }

    public Material getSherd(DecoratedPot.Side face) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        PotDecorations decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).getDecorations();
        Optional<Item> sherdItem = switch (face) {
            case DecoratedPot.Side.BACK -> decorations.back();
            case DecoratedPot.Side.LEFT -> decorations.left();
            case DecoratedPot.Side.RIGHT -> decorations.right();
            case DecoratedPot.Side.FRONT -> decorations.front();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(face));
        };
        return CraftItemType.minecraftToBukkit(sherdItem.orElse(Items.BRICK));
    }

    public Map<DecoratedPot.Side, Material> getSherds() {
        PotDecorations decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).getDecorations();
        EnumMap<DecoratedPot.Side, Material> sherds = new EnumMap<DecoratedPot.Side, Material>(DecoratedPot.Side.class);
        sherds.put(DecoratedPot.Side.BACK, CraftItemType.minecraftToBukkit(decorations.back().orElse(Items.BRICK)));
        sherds.put(DecoratedPot.Side.LEFT, CraftItemType.minecraftToBukkit(decorations.left().orElse(Items.BRICK)));
        sherds.put(DecoratedPot.Side.RIGHT, CraftItemType.minecraftToBukkit(decorations.right().orElse(Items.BRICK)));
        sherds.put(DecoratedPot.Side.FRONT, CraftItemType.minecraftToBukkit(decorations.front().orElse(Items.BRICK)));
        return sherds;
    }

    public List<Material> getShards() {
        return ((DecoratedPotBlockEntity)this.getSnapshot()).getDecorations().ordered().stream().map(CraftItemType::minecraftToBukkit).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public CraftDecoratedPot copy() {
        return new CraftDecoratedPot(this, null);
    }

    @Override
    public CraftDecoratedPot copy(Location location) {
        return new CraftDecoratedPot(this, location);
    }

    public void startWobble(@NotNull DecoratedPot.WobbleStyle style) {
        Preconditions.checkArgument((style != null ? 1 : 0) != 0, (Object)"style must not be null");
        this.requirePlaced();
        DecoratedPotBlockEntity.WobbleStyle originalStyle = switch (style) {
            default -> throw new MatchException(null, null);
            case DecoratedPot.WobbleStyle.POSITIVE -> DecoratedPotBlockEntity.WobbleStyle.POSITIVE;
            case DecoratedPot.WobbleStyle.NEGATIVE -> DecoratedPotBlockEntity.WobbleStyle.NEGATIVE;
        };
        ((DecoratedPotBlockEntity)this.getBlockEntity()).wobble(originalStyle);
    }
}

