/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Bed;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftBed
extends CraftBlockData
implements Bed {
    private static final EnumProperty<Direction> FACING = BedBlock.FACING;
    private static final BooleanProperty OCCUPIED = BedBlock.OCCUPIED;
    private static final EnumProperty<BedPart> PART = BedBlock.PART;

    public CraftBed(BlockState state) {
        super(state);
    }

    public BlockFace getFacing() {
        return this.get(FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.isCartesian() && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only cartesian horizontal face are allowed for this property!");
        this.set(FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(FACING, BlockFace.class);
    }

    public boolean isOccupied() {
        return this.get(OCCUPIED);
    }

    public void setOccupied(boolean occupied) {
        this.set(OCCUPIED, occupied);
    }

    public Bed.Part getPart() {
        return this.get(PART, Bed.Part.class);
    }

    public void setPart(Bed.Part part) {
        Preconditions.checkArgument((part != null ? 1 : 0) != 0, (Object)"part cannot be null!");
        this.set(PART, part);
    }
}

