/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.HangingSign;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.util.Vector;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftCeilingHangingSign
extends CraftBlockData
implements HangingSign {
    private static final BooleanProperty ATTACHED = CeilingHangingSignBlock.ATTACHED;
    private static final IntegerProperty ROTATION = CeilingHangingSignBlock.ROTATION;
    private static final BooleanProperty WATERLOGGED = CeilingHangingSignBlock.WATERLOGGED;

    public CraftCeilingHangingSign(BlockState state) {
        super(state);
    }

    public boolean isAttached() {
        return this.get(ATTACHED);
    }

    public void setAttached(boolean attached) {
        this.set(ATTACHED, attached);
    }

    public BlockFace getRotation() {
        return CraftBlockData.ROTATION_CYCLE[this.get(ROTATION)];
    }

    public void setRotation(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace != BlockFace.SELF && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only horizontal face are allowed for this property!");
        Vector dir = blockFace.getDirection();
        float angle = (float)(-Math.toDegrees(Math.atan2(dir.getX(), dir.getZ())));
        this.set(ROTATION, RotationSegment.convertToSegment(angle));
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

