/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.data.type.TechnicalPiston;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftPistonHead
extends CraftBlockData
implements PistonHead {
    private static final EnumProperty<Direction> FACING = PistonHeadBlock.FACING;
    private static final BooleanProperty SHORT = PistonHeadBlock.SHORT;
    private static final EnumProperty<PistonType> TYPE = PistonHeadBlock.TYPE;

    public CraftPistonHead(BlockState state) {
        super(state);
    }

    public BlockFace getFacing() {
        return this.get(FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((boolean)blockFace.isCartesian(), (Object)"Invalid face, only cartesian face are allowed for this property!");
        this.set(FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(FACING, BlockFace.class);
    }

    public boolean isShort() {
        return this.get(SHORT);
    }

    public void setShort(boolean _short) {
        this.set(SHORT, _short);
    }

    public TechnicalPiston.Type getType() {
        return this.get(TYPE, TechnicalPiston.Type.class);
    }

    public void setType(TechnicalPiston.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null!");
        this.set(TYPE, type);
    }
}

