/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.sign;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.world.level.block.entity.SignText;
import org.bukkit.DyeColor;
import org.bukkit.block.sign.SignSide;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftSignSide
implements SignSide {
    private List<Component> originalLines = null;
    private List<Component> lines = null;
    private SignText signText;

    public CraftSignSide(SignText signText) {
        this.signText = signText;
    }

    public @NotNull List<Component> lines() {
        this.loadLines();
        return this.lines;
    }

    public @NotNull Component line(int index) throws IndexOutOfBoundsException {
        this.loadLines();
        return this.lines.get(index);
    }

    public void line(int index, @NotNull Component line) throws IndexOutOfBoundsException {
        Preconditions.checkArgument((line != null ? 1 : 0) != 0, (Object)"Line cannot be null");
        this.loadLines();
        this.lines.set(index, line);
    }

    private void loadLines() {
        if (this.lines != null) {
            return;
        }
        this.lines = PaperAdventure.asAdventure(this.signText.getMessages(false));
        this.originalLines = new ArrayList<Component>(this.lines);
    }

    @NotNull
    public String[] getLines() {
        this.loadLines();
        return (String[])this.lines.stream().map(arg_0 -> ((LegacyComponentSerializer)LegacyComponentSerializer.legacySection()).serialize(arg_0)).toArray(String[]::new);
    }

    @NotNull
    public String getLine(int index) throws IndexOutOfBoundsException {
        this.loadLines();
        return LegacyComponentSerializer.legacySection().serialize(this.lines.get(index));
    }

    public void setLine(int index, @NotNull String line) throws IndexOutOfBoundsException {
        this.loadLines();
        this.lines.set(index, (Component)LegacyComponentSerializer.legacySection().deserialize(line));
    }

    public boolean isGlowingText() {
        return this.signText.hasGlowingText();
    }

    public void setGlowingText(boolean glowing) {
        this.signText = this.signText.setHasGlowingText(glowing);
    }

    @Nullable
    public DyeColor getColor() {
        return DyeColor.getByWoolData((byte)((byte)this.signText.getColor().getId()));
    }

    public void setColor(@NotNull DyeColor color) {
        this.signText = this.signText.setColor(net.minecraft.world.item.DyeColor.byId(color.getWoolData()));
    }

    public SignText applyLegacyStringToSignSide() {
        if (this.lines != null) {
            for (int i = 0; i < this.lines.size(); ++i) {
                Component origComp;
                Component component = this.lines.get(i);
                if (component.equals((Object)(origComp = this.originalLines.get(i)))) continue;
                this.signText = this.signText.setMessage(i, PaperAdventure.asVanilla(component));
            }
        }
        return this.signText;
    }
}

