/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.boss;

import com.google.common.base.Preconditions;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.dimension.end.DragonRespawnAnimation;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.boss.CraftBossBar;
import org.bukkit.craftbukkit.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;

public class CraftDragonBattle
implements DragonBattle {
    private final EndDragonFight handle;

    public CraftDragonBattle(EndDragonFight handle) {
        this.handle = handle;
    }

    public EnderDragon getEnderDragon() {
        Entity entity = this.handle.level.getEntity(this.handle.dragonUUID);
        return entity != null ? (EnderDragon)entity.getBukkitEntity() : null;
    }

    public BossBar getBossBar() {
        return new CraftBossBar(this.handle.dragonEvent);
    }

    public Location getEndPortalLocation() {
        if (this.handle.portalLocation == null) {
            return null;
        }
        return CraftLocation.toBukkit((Vec3i)this.handle.portalLocation, (Level)this.handle.level);
    }

    public boolean generateEndPortal(boolean withPortals) {
        if (this.handle.portalLocation != null || this.handle.findExitPortal() != null) {
            return false;
        }
        this.handle.spawnExitPortal(withPortals);
        return true;
    }

    public boolean hasBeenPreviouslyKilled() {
        return this.handle.hasPreviouslyKilledDragon();
    }

    public void setPreviouslyKilled(boolean previouslyKilled) {
        this.handle.previouslyKilled = previouslyKilled;
    }

    public void initiateRespawn() {
        this.handle.tryRespawn();
    }

    public boolean initiateRespawn(Collection<EnderCrystal> list) {
        if (this.hasBeenPreviouslyKilled() && this.getRespawnPhase() == DragonBattle.RespawnPhase.NONE) {
            BlockPattern.BlockPatternMatch patternMatch;
            if (this.handle.portalLocation == null && (patternMatch = this.handle.findExitPortal()) == null) {
                this.handle.spawnExitPortal(true);
            }
            list = list != null ? new ArrayList<EnderCrystal>(list) : Collections.emptyList();
            list.removeIf(enderCrystal -> {
                if (enderCrystal == null) {
                    return true;
                }
                World world = enderCrystal.getWorld();
                return !((CraftWorld)world).getHandle().equals(this.handle.level);
            });
            return this.handle.respawnDragon(list.stream().map(enderCrystal -> ((CraftEnderCrystal)enderCrystal).getHandle()).collect(Collectors.toList()));
        }
        return false;
    }

    public DragonBattle.RespawnPhase getRespawnPhase() {
        return this.toBukkitRespawnPhase(this.handle.respawnStage);
    }

    public boolean setRespawnPhase(DragonBattle.RespawnPhase phase) {
        Preconditions.checkArgument((phase != null && phase != DragonBattle.RespawnPhase.NONE ? 1 : 0) != 0, (String)"Invalid respawn phase provided: %s", (Object)phase);
        if (this.handle.respawnStage == null) {
            return false;
        }
        this.handle.setRespawnStage(this.toNMSRespawnPhase(phase));
        return true;
    }

    public void resetCrystals() {
        this.handle.resetSpikeCrystals();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftDragonBattle && ((CraftDragonBattle)obj).handle == this.handle;
    }

    private DragonBattle.RespawnPhase toBukkitRespawnPhase(DragonRespawnAnimation phase) {
        return phase != null ? DragonBattle.RespawnPhase.values()[phase.ordinal()] : DragonBattle.RespawnPhase.NONE;
    }

    private DragonRespawnAnimation toNMSRespawnPhase(DragonBattle.RespawnPhase phase) {
        return phase != DragonBattle.RespawnPhase.NONE ? DragonRespawnAnimation.values()[phase.ordinal()] : null;
    }

    public int getGatewayCount() {
        return 20 - this.handle.gateways.size();
    }

    public boolean spawnNewGateway() {
        return this.handle.spawnNewGatewayIfPossible();
    }

    public void spawnNewGateway(Position position) {
        this.handle.spawnNewGateway(MCUtil.toBlockPos(position));
    }

    public List<EnderCrystal> getRespawnCrystals() {
        if (this.handle.respawnCrystals == null) {
            return Collections.emptyList();
        }
        ArrayList<EnderCrystal> enderCrystals = new ArrayList<EnderCrystal>();
        for (EndCrystal endCrystal : this.handle.respawnCrystals) {
            if (endCrystal.isRemoved() || !endCrystal.isAlive() || !endCrystal.valid) continue;
            enderCrystals.add((EnderCrystal)endCrystal.getBukkitEntity());
        }
        return Collections.unmodifiableList(enderCrystals);
    }

    public List<EnderCrystal> getHealingCrystals() {
        ArrayList<EnderCrystal> enderCrystals = new ArrayList<EnderCrystal>();
        for (EndCrystal endCrystal : this.handle.getSpikeCrystals()) {
            if (endCrystal.isRemoved() || !endCrystal.isAlive() || !endCrystal.valid) continue;
            enderCrystals.add((EnderCrystal)endCrystal.getBukkitEntity());
        }
        return Collections.unmodifiableList(enderCrystals);
    }
}

