/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.HolderableBase;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.entity.Chicken;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CraftChicken
extends CraftAnimals
implements Chicken {
    public CraftChicken(CraftServer server, net.minecraft.world.entity.animal.chicken.Chicken entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.animal.chicken.Chicken getHandle() {
        return (net.minecraft.world.entity.animal.chicken.Chicken)this.entity;
    }

    public Chicken.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().getVariant());
    }

    public void setVariant(Chicken.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant cannot be null");
        this.getHandle().setVariant(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public boolean isChickenJockey() {
        return this.getHandle().isChickenJockey();
    }

    public void setIsChickenJockey(boolean isChickenJockey) {
        this.getHandle().setChickenJockey(isChickenJockey);
    }

    public int getEggLayTime() {
        return this.getHandle().eggTime;
    }

    public void setEggLayTime(int eggLayTime) {
        this.getHandle().eggTime = eggLayTime;
    }

    public static class CraftVariant
    extends HolderableBase<ChickenVariant>
    implements Chicken.Variant {
        public static Chicken.Variant minecraftHolderToBukkit(Holder<ChickenVariant> minecraft) {
            return (Chicken.Variant)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.CHICKEN_VARIANT);
        }

        public static Holder<ChickenVariant> bukkitToMinecraftHolder(Chicken.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftVariant(Holder<ChickenVariant> holder) {
            super(holder);
        }
    }
}

