/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LightningBolt;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class CraftLightningStrike
extends CraftEntity
implements LightningStrike {
    private final LightningStrike.Spigot spigot = new LightningStrike.Spigot(this){

        public boolean isSilent() {
            return false;
        }
    };

    public CraftLightningStrike(CraftServer server, LightningBolt entity) {
        super(server, entity);
    }

    @Override
    public LightningBolt getHandle() {
        return (LightningBolt)this.entity;
    }

    public boolean isEffect() {
        return this.getHandle().isEffect;
    }

    public int getFlashes() {
        return this.getHandle().flashes;
    }

    public void setFlashes(int flashes) {
        this.getHandle().flashes = flashes;
    }

    public int getLifeTicks() {
        return this.getHandle().life;
    }

    public void setLifeTicks(int ticks) {
        this.getHandle().life = ticks;
    }

    public Player getCausingPlayer() {
        ServerPlayer player = this.getHandle().getCause();
        return player != null ? player.getBukkitEntity() : null;
    }

    public void setCausingPlayer(Player player) {
        this.getHandle().setCause(player != null ? ((CraftPlayer)player).getHandle() : null);
    }

    public LightningStrike.Spigot spigot() {
        return this.spigot;
    }

    public int getFlashCount() {
        return this.getHandle().flashes;
    }

    public void setFlashCount(int flashes) {
        Preconditions.checkArgument((flashes >= 0 ? 1 : 0) != 0, (Object)"Flashes has to be a positive number!");
        this.getHandle().flashes = flashes;
    }

    @Nullable
    public Entity getCausingEntity() {
        ServerPlayer cause = this.getHandle().getCause();
        return cause == null ? null : cause.getBukkitEntity();
    }
}

