/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.destroystokyo.paper.entity.CraftRangedEntity;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPiglinAbstract;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.entity.Piglin;
import org.bukkit.inventory.Inventory;

public class CraftPiglin
extends CraftPiglinAbstract
implements Piglin,
CraftRangedEntity<net.minecraft.world.entity.monster.piglin.Piglin> {
    public CraftPiglin(CraftServer server, net.minecraft.world.entity.monster.piglin.Piglin entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.monster.piglin.Piglin getHandle() {
        return (net.minecraft.world.entity.monster.piglin.Piglin)this.entity;
    }

    public boolean isAbleToHunt() {
        return this.getHandle().cannotHunt;
    }

    public void setIsAbleToHunt(boolean flag) {
        this.getHandle().cannotHunt = flag;
    }

    public boolean addBarterMaterial(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Item item = CraftItemType.bukkitToMinecraft(material);
        return this.getHandle().allowedBarterItems.add(item);
    }

    public boolean removeBarterMaterial(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Item item = CraftItemType.bukkitToMinecraft(material);
        return this.getHandle().allowedBarterItems.remove(item);
    }

    public boolean addMaterialOfInterest(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Item item = CraftItemType.bukkitToMinecraft(material);
        return this.getHandle().interestItems.add(item);
    }

    public boolean removeMaterialOfInterest(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Item item = CraftItemType.bukkitToMinecraft(material);
        return this.getHandle().interestItems.remove(item);
    }

    public Set<Material> getInterestList() {
        return Collections.unmodifiableSet(this.getHandle().interestItems.stream().map(CraftItemType::minecraftToBukkit).collect(Collectors.toSet()));
    }

    public Set<Material> getBarterList() {
        return Collections.unmodifiableSet(this.getHandle().allowedBarterItems.stream().map(CraftItemType::minecraftToBukkit).collect(Collectors.toSet()));
    }

    public Inventory getInventory() {
        return new CraftInventory(this.getHandle().inventory);
    }

    public void setChargingCrossbow(boolean chargingCrossbow) {
        this.getHandle().setChargingCrossbow(chargingCrossbow);
    }

    public boolean isChargingCrossbow() {
        return this.getHandle().isChargingCrossbow();
    }

    public void setDancing(boolean dancing) {
        if (dancing) {
            this.getHandle().getBrain().setMemory(MemoryModuleType.DANCING, true);
            this.getHandle().getBrain().setMemory(MemoryModuleType.CELEBRATE_LOCATION, this.getHandle().getOnPos());
        } else {
            this.getHandle().getBrain().eraseMemory(MemoryModuleType.DANCING);
            this.getHandle().getBrain().eraseMemory(MemoryModuleType.CELEBRATE_LOCATION);
        }
    }

    public void setDancing(long duration) {
        this.getHandle().getBrain().setMemoryWithExpiry(MemoryModuleType.DANCING, true, duration);
        this.getHandle().getBrain().setMemoryWithExpiry(MemoryModuleType.CELEBRATE_LOCATION, this.getHandle().getOnPos(), duration);
    }

    public boolean isDancing() {
        return this.getHandle().isDancing();
    }
}

