/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.skeleton.Skeleton;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAbstractSkeleton;
import org.bukkit.entity.Skeleton;

public class CraftSkeleton
extends CraftAbstractSkeleton
implements org.bukkit.entity.Skeleton {
    public CraftSkeleton(CraftServer server, Skeleton entity) {
        super(server, entity);
    }

    @Override
    public Skeleton getHandle() {
        return (Skeleton)this.entity;
    }

    public boolean isConverting() {
        return this.getHandle().isFreezeConverting();
    }

    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity is not converting");
        return this.getHandle().conversionTime;
    }

    public void setConversionTime(int time) {
        if (time < 0) {
            this.getHandle().conversionTime = -1;
            this.getHandle().getEntityData().set(Skeleton.DATA_STRAY_CONVERSION_ID, false);
        } else {
            this.getHandle().startFreezeConversion(time);
        }
    }

    public Skeleton.SkeletonType getSkeletonType() {
        return Skeleton.SkeletonType.NORMAL;
    }

    public int inPowderedSnowTime() {
        return this.getHandle().inPowderSnowTime;
    }
}

