/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TNTPrimed;

public class CraftTNTPrimed
extends CraftEntity
implements TNTPrimed {
    public CraftTNTPrimed(CraftServer server, PrimedTnt entity) {
        super(server, entity);
    }

    @Override
    public PrimedTnt getHandle() {
        return (PrimedTnt)this.entity;
    }

    public float getYield() {
        return this.getHandle().explosionPower;
    }

    public boolean isIncendiary() {
        return this.getHandle().isIncendiary;
    }

    public void setIsIncendiary(boolean isIncendiary) {
        this.getHandle().isIncendiary = isIncendiary;
    }

    public void setYield(float yield) {
        this.getHandle().explosionPower = yield;
    }

    public int getFuseTicks() {
        return this.getHandle().getFuse();
    }

    public void setFuseTicks(int fuseTicks) {
        this.getHandle().setFuse(fuseTicks);
    }

    public Entity getSource() {
        LivingEntity source = this.getHandle().getOwner();
        return source != null ? source.getBukkitEntity() : null;
    }

    public void setSource(Entity source) {
        this.getHandle().owner = source instanceof org.bukkit.entity.LivingEntity ? EntityReference.of(((CraftLivingEntity)source).getHandle()) : null;
    }

    public void setBlockData(BlockData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"The visual block data of this tnt cannot be null. To reset it just set to the TNT default block data");
        this.getHandle().setBlockState(((CraftBlockData)data).getState());
    }

    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getHandle().getBlockState());
    }
}

