/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.event;

import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.destroystokyo.paper.event.entity.EntityZapEvent;
import com.destroystokyo.paper.event.entity.ExperienceOrbMergeEvent;
import com.destroystokyo.paper.event.entity.ProjectileCollideEvent;
import com.destroystokyo.paper.event.entity.WitchReadyPotionEvent;
import com.destroystokyo.paper.event.inventory.PrepareResultEvent;
import com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.block.bed.BedEnterAction;
import io.papermc.paper.block.bed.BedEnterActionImpl;
import io.papermc.paper.block.bed.BedEnterProblem;
import io.papermc.paper.block.bed.BedRuleResult;
import io.papermc.paper.connection.HorriblePlayerLoginEventHack;
import io.papermc.paper.connection.PlayerConnection;
import io.papermc.paper.event.block.BellRingEvent;
import io.papermc.paper.event.block.BlockFailedDispenseEvent;
import io.papermc.paper.event.block.BlockLockCheckEvent;
import io.papermc.paper.event.block.BlockPreDispenseEvent;
import io.papermc.paper.event.connection.PlayerConnectionValidateLoginEvent;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.ItemTransportingEntityValidateTargetEvent;
import io.papermc.paper.event.entity.WaterBottleSplashEvent;
import io.papermc.paper.event.player.PlayerBedFailEnterEvent;
import io.papermc.paper.event.world.PaperWorldGameRuleChangeEvent;
import io.papermc.paper.util.TransformingRandomAccessList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.LockCode;
import net.minecraft.world.attribute.BedRule;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.fish.AbstractFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.illager.SpellcasterIllager;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.throwableitemprojectile.AbstractThrownPotion;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrownLingeringPotion;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrownSplashPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.PortalType;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.TrialSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftExplosionResult;
import org.bukkit.craftbukkit.CraftGameRule;
import org.bukkit.craftbukkit.CraftLootTable;
import org.bukkit.craftbukkit.CraftRaid;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.CraftStatistic;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.damage.CraftDamageSource;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.entity.CraftItem;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.entity.CraftSpellcaster;
import org.bukkit.craftbukkit.event.PortalEventResult;
import org.bukkit.craftbukkit.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Witch;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BellResonateEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.block.VaultDisplayItemEvent;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.BatToggleSleepEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntitySpellCastEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.entity.StriderTemperatureChangeEvent;
import org.bukkit.event.entity.TrialSpawnerSpawnEvent;
import org.bukkit.event.entity.VillagerCareerChangeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerBucketFishEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerRecipeBookSettingsChangeEvent;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.event.raid.RaidSpawnWaveEvent;
import org.bukkit.event.raid.RaidStopEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftEventFactory {
    public static BlockPos sourceBlockOverride = null;
    private static final Function<ItemStack, Entity.DefaultDrop> FROM_FUNCTION = stack -> {
        if (stack == null) {
            return null;
        }
        return new Entity.DefaultDrop(CraftItemType.bukkitToMinecraft(stack.getType()), (ItemStack)stack, null);
    };
    private static final com.google.common.base.Function<? super Double, Double> ZERO = Functions.constant((Object)-0.0);
    private static BlockLockCheckEvent LAST_BLOCK_LOCK_CHECK_EVENT = null;

    private static boolean canBuild(Level world, org.bukkit.entity.Player player, int x, int z) {
        return world.mayInteract(((CraftPlayer)player).getHandle(), new BlockPos(x, 0, z));
    }

    public static boolean callPlayerSignOpenEvent(Player player, SignBlockEntity signBlockEntity, boolean front, PlayerSignOpenEvent.Cause cause) {
        CraftBlock block = CraftBlock.at(signBlockEntity.getLevel(), signBlockEntity.getBlockPos());
        Sign sign = (Sign)CraftBlockStates.getBlockState(block);
        Side side = front ? Side.FRONT : Side.BACK;
        return CraftEventFactory.callPlayerSignOpenEvent((org.bukkit.entity.Player)player.getBukkitEntity(), sign, side, cause);
    }

    public static boolean callPlayerSignOpenEvent(org.bukkit.entity.Player player, Sign sign, Side side, PlayerSignOpenEvent.Cause cause) {
        PlayerSignOpenEvent event = new PlayerSignOpenEvent(player, sign, side, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static Pair<PlayerBedFailEnterEvent.FailReason, BedEnterAction> asFailReason(Player player, BedRule bedRule, Player.BedSleepingProblem sleepingProblem) {
        PlayerBedFailEnterEvent.FailReason failReason = null;
        BedEnterProblem enterProblem = null;
        net.minecraft.network.chat.Component errorMessage = sleepingProblem.message();
        if (sleepingProblem == Player.BedSleepingProblem.OTHER_PROBLEM) {
            failReason = PlayerBedFailEnterEvent.FailReason.OTHER_PROBLEM;
            enterProblem = BedEnterProblem.OTHER;
        } else if (sleepingProblem == Player.BedSleepingProblem.NOT_SAFE) {
            failReason = PlayerBedFailEnterEvent.FailReason.NOT_SAFE;
            enterProblem = BedEnterProblem.NOT_SAFE;
        } else if (sleepingProblem == Player.BedSleepingProblem.OBSTRUCTED) {
            failReason = PlayerBedFailEnterEvent.FailReason.OBSTRUCTED;
            enterProblem = BedEnterProblem.OBSTRUCTED;
        } else if (sleepingProblem == Player.BedSleepingProblem.TOO_FAR_AWAY) {
            failReason = PlayerBedFailEnterEvent.FailReason.TOO_FAR_AWAY;
            enterProblem = BedEnterProblem.TOO_FAR_AWAY;
        } else if (sleepingProblem == Player.BedSleepingProblem.EXPLOSION) {
            failReason = PlayerBedFailEnterEvent.FailReason.EXPLOSION;
            enterProblem = BedEnterProblem.EXPLOSION;
            errorMessage = bedRule.errorMessage().orElse(null);
        } else if (bedRule.canSleep() == BedRule.Rule.NEVER) {
            failReason = PlayerBedFailEnterEvent.FailReason.NOT_POSSIBLE_HERE;
        } else if (bedRule.canSleep() == BedRule.Rule.WHEN_DARK) {
            failReason = PlayerBedFailEnterEvent.FailReason.NOT_POSSIBLE_NOW;
        }
        if (failReason == null) {
            failReason = PlayerBedFailEnterEvent.FailReason.OTHER_PROBLEM;
            enterProblem = BedEnterProblem.OTHER;
        }
        return Pair.of((Object)failReason, (Object)new BedEnterActionImpl(CraftEventFactory.asBedRuleResult(bedRule.canSleep(), bedRule.canSleep().test(player.level())), CraftEventFactory.asBedRuleResult(bedRule.canSetSpawn(), bedRule.canSetSpawn().test(player.level())), enterProblem, errorMessage == null ? null : PaperAdventure.asAdventure(errorMessage)));
    }

    public static BedRuleResult asBedRuleResult(BedRule.Rule rule, boolean value) {
        if (rule == BedRule.Rule.ALWAYS) {
            return BedRuleResult.ALLOWED;
        }
        if (rule == BedRule.Rule.WHEN_DARK) {
            if (value) {
                return BedRuleResult.ALLOWED;
            }
            return BedRuleResult.TOO_MUCH_LIGHT;
        }
        if (rule == BedRule.Rule.NEVER) {
            return BedRuleResult.NEVER;
        }
        throw new IllegalArgumentException(rule.toString());
    }

    public static PlayerBedFailEnterEvent callPlayerBedFailEnterEvent(Player player, BlockPos bed, Player.BedSleepingProblem bedSleepingProblem) {
        BedRule bedRule = player.level().environmentAttributes().getDimensionValue(EnvironmentAttributes.BED_RULE);
        Pair<PlayerBedFailEnterEvent.FailReason, BedEnterAction> actionPair = CraftEventFactory.asFailReason(player, bedRule, bedSleepingProblem);
        PlayerBedFailEnterEvent event = new PlayerBedFailEnterEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (PlayerBedFailEnterEvent.FailReason)actionPair.getFirst(), (Block)CraftBlock.at(player.level(), bed), bedSleepingProblem == Player.BedSleepingProblem.EXPLOSION, ((BedEnterAction)actionPair.getSecond()).errorMessage(), (BedEnterAction)actionPair.getSecond());
        event.callEvent();
        return event;
    }

    public static Either<Player.BedSleepingProblem, Unit> callPlayerBedEnterEvent(Player player, BlockPos bed, Either<Player.BedSleepingProblem, Unit> nmsBedResult) {
        BedRule bedRule = player.level().environmentAttributes().getDimensionValue(EnvironmentAttributes.BED_RULE);
        Pair bedEnterResult = (Pair)nmsBedResult.mapBoth(sleepingProblem -> {
            PlayerBedEnterEvent.BedEnterResult enterResult = null;
            BedEnterProblem enterProblem = null;
            net.minecraft.network.chat.Component errorMessage = sleepingProblem.message();
            if (sleepingProblem == Player.BedSleepingProblem.OTHER_PROBLEM) {
                enterResult = PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM;
                enterProblem = BedEnterProblem.OTHER;
            } else if (sleepingProblem == Player.BedSleepingProblem.NOT_SAFE) {
                enterResult = PlayerBedEnterEvent.BedEnterResult.NOT_SAFE;
                enterProblem = BedEnterProblem.NOT_SAFE;
            } else if (sleepingProblem == Player.BedSleepingProblem.OBSTRUCTED) {
                enterResult = PlayerBedEnterEvent.BedEnterResult.OBSTRUCTED;
                enterProblem = BedEnterProblem.OBSTRUCTED;
            } else if (sleepingProblem == Player.BedSleepingProblem.TOO_FAR_AWAY) {
                enterResult = PlayerBedEnterEvent.BedEnterResult.TOO_FAR_AWAY;
                enterProblem = BedEnterProblem.TOO_FAR_AWAY;
            } else if (sleepingProblem == Player.BedSleepingProblem.EXPLOSION) {
                enterResult = PlayerBedEnterEvent.BedEnterResult.EXPLOSION;
                enterProblem = BedEnterProblem.EXPLOSION;
                errorMessage = bedRule.errorMessage().orElse(null);
            } else if (bedRule.canSleep() == BedRule.Rule.NEVER) {
                enterResult = PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_HERE;
            } else if (bedRule.canSleep() == BedRule.Rule.WHEN_DARK) {
                enterResult = PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_NOW;
            }
            if (enterResult == null) {
                enterResult = PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM;
                enterProblem = BedEnterProblem.OTHER;
            }
            return Pair.of((Object)enterResult, (Object)new BedEnterActionImpl(CraftEventFactory.asBedRuleResult(bedRule.canSleep(), bedRule.canSleep().test(player.level())), CraftEventFactory.asBedRuleResult(bedRule.canSetSpawn(), bedRule.canSetSpawn().test(player.level())), enterProblem, errorMessage == null ? null : PaperAdventure.asAdventure(errorMessage)));
        }, t -> Pair.of((Object)PlayerBedEnterEvent.BedEnterResult.OK, (Object)new BedEnterActionImpl(CraftEventFactory.asBedRuleResult(bedRule.canSleep(), bedRule.canSleep().test(player.level())), CraftEventFactory.asBedRuleResult(bedRule.canSetSpawn(), bedRule.canSetSpawn().test(player.level())), null, null))).map(Function.identity(), Function.identity());
        PlayerBedEnterEvent event = new PlayerBedEnterEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (Block)CraftBlock.at(player.level(), bed), (PlayerBedEnterEvent.BedEnterResult)bedEnterResult.getFirst(), (BedEnterAction)bedEnterResult.getSecond());
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        Event.Result result = event.useBed();
        if (result == Event.Result.ALLOW) {
            return Either.right(Unit.INSTANCE);
        }
        if (result == Event.Result.DENY) {
            return Either.left(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
        return nmsBedResult;
    }

    public static EntityEnterLoveModeEvent callEntityEnterLoveModeEvent(Player entityHuman, Animal entityAnimal, int loveTicks) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = new EntityEnterLoveModeEvent((Animals)entityAnimal.getBukkitEntity(), (HumanEntity)(entityHuman != null ? entityHuman.getBukkitEntity() : null), loveTicks);
        Bukkit.getPluginManager().callEvent((Event)entityEnterLoveModeEvent);
        return entityEnterLoveModeEvent;
    }

    public static PlayerHarvestBlockEvent callPlayerHarvestBlockEvent(Level world, BlockPos pos, Player player, InteractionHand hand, List<net.minecraft.world.item.ItemStack> itemsToHarvest) {
        ArrayList bukkitItemsToHarvest = new ArrayList(itemsToHarvest.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        PlayerHarvestBlockEvent playerHarvestBlockEvent = new PlayerHarvestBlockEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (Block)CraftBlock.at(world, pos), CraftEquipmentSlot.getHand(hand), bukkitItemsToHarvest);
        Bukkit.getPluginManager().callEvent((Event)playerHarvestBlockEvent);
        return playerHarvestBlockEvent;
    }

    public static PlayerBucketEntityEvent callPlayerFishBucketEvent(LivingEntity fish, Player entityHuman, net.minecraft.world.item.ItemStack originalBucket, net.minecraft.world.item.ItemStack entityBucket, InteractionHand hand) {
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)entityHuman.getBukkitEntity();
        EquipmentSlot handSlot = CraftEquipmentSlot.getHand(hand);
        Object event = fish instanceof AbstractFish ? new PlayerBucketFishEvent(player, (Fish)fish.getBukkitEntity(), CraftItemStack.asBukkitCopy(originalBucket), CraftItemStack.asBukkitCopy(entityBucket), handSlot) : new PlayerBucketEntityEvent(player, (Entity)fish.getBukkitEntity(), CraftItemStack.asBukkitCopy(originalBucket), CraftItemStack.asBukkitCopy(entityBucket), handSlot);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static TradeSelectEvent callTradeSelectEvent(int newIndex, MerchantMenu merchant) {
        TradeSelectEvent tradeSelectEvent = new TradeSelectEvent((MerchantView)merchant.getBukkitView(), newIndex);
        Bukkit.getPluginManager().callEvent((Event)tradeSelectEvent);
        return tradeSelectEvent;
    }

    public static boolean handleBellRingEvent(Level world, BlockPos position, Direction direction, net.minecraft.world.entity.Entity entity) {
        CraftBlock block = CraftBlock.at(world, position);
        BlockFace bukkitDirection = CraftBlock.notchToBlockFace(direction);
        BellRingEvent event = new BellRingEvent((Block)block, bukkitDirection, (Entity)(entity != null ? entity.getBukkitEntity() : null));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static Stream<LivingEntity> handleBellResonateEvent(Level world, BlockPos position, List<org.bukkit.entity.LivingEntity> bukkitEntities) {
        CraftBlock block = CraftBlock.at(world, position);
        BellResonateEvent event = new BellResonateEvent((Block)block, bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getResonatedEntities().stream().map(bukkitEntity -> ((CraftLivingEntity)bukkitEntity).getHandle());
    }

    public static BlockMultiPlaceEvent callBlockMultiPlaceEvent(ServerLevel level, Player player, InteractionHand hand, List<BlockState> blockStates, BlockPos clickedPos) {
        org.bukkit.entity.Player cplayer = (org.bukkit.entity.Player)player.getBukkitEntity();
        CraftBlock clickedBlock = CraftBlock.at(level, clickedPos);
        boolean canBuild = true;
        for (BlockState blockState : blockStates) {
            if (CraftEventFactory.canBuild(level, cplayer, blockState.getX(), blockState.getZ())) continue;
            canBuild = false;
            break;
        }
        EquipmentSlot handSlot = CraftEquipmentSlot.getHand(hand);
        BlockMultiPlaceEvent event = new BlockMultiPlaceEvent(blockStates, (Block)clickedBlock, cplayer.getInventory().getItem(handSlot), cplayer, canBuild, handSlot);
        event.callEvent();
        return event;
    }

    public static BlockPlaceEvent callBlockPlaceEvent(ServerLevel level, Player player, InteractionHand hand, BlockState replacedSnapshot, BlockPos clickedPos) {
        org.bukkit.entity.Player cplayer = (org.bukkit.entity.Player)player.getBukkitEntity();
        CraftBlock clickedBlock = CraftBlock.at(level, clickedPos);
        Block placedBlock = replacedSnapshot.getBlock();
        boolean canBuild = CraftEventFactory.canBuild(level, cplayer, placedBlock.getX(), placedBlock.getZ());
        EquipmentSlot handSlot = CraftEquipmentSlot.getHand(hand);
        BlockPlaceEvent event = new BlockPlaceEvent(placedBlock, replacedSnapshot, (Block)clickedBlock, cplayer.getInventory().getItem(handSlot), cplayer, canBuild, handSlot);
        event.callEvent();
        return event;
    }

    public static void handleBlockDropItemEvent(Block block, BlockState state, ServerPlayer player, List<ItemEntity> items) {
        ArrayList<Item> list = new ArrayList<Item>();
        for (ItemEntity item : items) {
            list.add((Item)item.getBukkitEntity());
        }
        BlockDropItemEvent event = new BlockDropItemEvent(block, state, (org.bukkit.entity.Player)player.getBukkitEntity(), list);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            for (Item bukkit : list) {
                if (bukkit.isValid()) continue;
                ItemEntity item = ((CraftItem)bukkit).getHandle();
                item.level().addFreshEntity(item);
            }
        } else {
            for (Item bukkit : list) {
                if (!bukkit.isValid()) continue;
                bukkit.remove();
            }
        }
    }

    public static EntityPlaceEvent callEntityPlaceEvent(UseOnContext context, net.minecraft.world.entity.Entity entity) {
        return CraftEventFactory.callEntityPlaceEvent(context.getLevel(), context.getClickedPos(), context.getClickedFace(), context.getPlayer(), entity, context.getHand());
    }

    public static EntityPlaceEvent callEntityPlaceEvent(Level world, BlockPos clickedPos, Direction clickedFace, Player player, net.minecraft.world.entity.Entity entity, InteractionHand hand) {
        org.bukkit.entity.Player cplayer = player == null ? null : (org.bukkit.entity.Player)player.getBukkitEntity();
        CraftBlock clickedBlock = CraftBlock.at(world, clickedPos);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EntityPlaceEvent event = new EntityPlaceEvent((Entity)entity.getBukkitEntity(), cplayer, (Block)clickedBlock, blockFace, CraftEquipmentSlot.getHand(hand));
        entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerBucketEmptyEvent callPlayerBucketEmptyEvent(Level world, Player player, BlockPos changed, BlockPos clicked, Direction clickedFace, net.minecraft.world.item.ItemStack itemInHand, InteractionHand hand) {
        return (PlayerBucketEmptyEvent)CraftEventFactory.getPlayerBucketEvent(false, world, player, changed, clicked, clickedFace, itemInHand, Items.BUCKET, hand);
    }

    public static PlayerBucketFillEvent callPlayerBucketFillEvent(Level world, Player player, BlockPos changed, BlockPos clicked, Direction clickedFace, net.minecraft.world.item.ItemStack itemInHand, net.minecraft.world.item.Item bucket, InteractionHand hand) {
        return (PlayerBucketFillEvent)CraftEventFactory.getPlayerBucketEvent(true, world, player, clicked, changed, clickedFace, itemInHand, bucket, hand);
    }

    private static PlayerEvent getPlayerBucketEvent(boolean isFilling, Level world, Player player, BlockPos changed, BlockPos clicked, Direction clickedFace, net.minecraft.world.item.ItemStack bucket, net.minecraft.world.item.Item item, InteractionHand hand) {
        PlayerBucketFillEvent event;
        org.bukkit.entity.Player cplayer = (org.bukkit.entity.Player)player.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asNewCraftStack(item);
        Material bucketItem = CraftItemType.minecraftToBukkit(bucket.getItem());
        CraftBlock block = CraftBlock.at(world, changed);
        CraftBlock clickedBlock = CraftBlock.at(world, clicked);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EquipmentSlot handSlot = CraftEquipmentSlot.getHand(hand);
        if (isFilling) {
            event = new PlayerBucketFillEvent(cplayer, (Block)block, (Block)clickedBlock, blockFace, bucketItem, (ItemStack)itemInHand, handSlot);
            event.setCancelled(!CraftEventFactory.canBuild(world, cplayer, changed.getX(), changed.getZ()));
        } else {
            event = new PlayerBucketEmptyEvent(cplayer, (Block)block, (Block)clickedBlock, blockFace, bucketItem, (ItemStack)itemInHand, handSlot);
            ((PlayerBucketEmptyEvent)event).setCancelled(!CraftEventFactory.canBuild(world, cplayer, changed.getX(), changed.getZ()));
        }
        event.callEvent();
        return event;
    }

    public static PlayerInteractEvent callPlayerInteractEvent(Player player, Action action, net.minecraft.world.item.ItemStack item, InteractionHand hand) {
        if (action != Action.LEFT_CLICK_AIR && action != Action.RIGHT_CLICK_AIR) {
            throw new AssertionError((Object)String.format("%s performing %s with %s", player, action, item));
        }
        return CraftEventFactory.callPlayerInteractEvent(player, action, null, Direction.SOUTH, item, hand);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(Player player, Action action, BlockPos pos, Direction direction, net.minecraft.world.item.ItemStack item, InteractionHand hand) {
        return CraftEventFactory.callPlayerInteractEvent(player, action, pos, direction, item, false, hand, null);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(Player player, Action action, BlockPos pos, Direction direction, net.minecraft.world.item.ItemStack item, boolean cancelledBlock, InteractionHand hand, Vec3 targetPos) {
        return CraftEventFactory.callPlayerInteractEvent(player, action, pos, direction, item, cancelledBlock, false, hand, targetPos);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(Player player, Action action, BlockPos pos, Direction direction, net.minecraft.world.item.ItemStack item, boolean cancelledBlock, boolean cancelledItem, InteractionHand hand, Vec3 targetPos) {
        org.bukkit.entity.Player cplayer = player == null ? null : (org.bukkit.entity.Player)player.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(item);
        Vector clickedPos = null;
        if (pos != null && targetPos != null) {
            clickedPos = CraftVector.toBukkit(targetPos.subtract(Vec3.atLowerCornerOf(pos)));
        }
        CraftServer craftServer = (CraftServer)cplayer.getServer();
        CraftBlock clickedBlock = null;
        if (pos != null) {
            clickedBlock = CraftBlock.at(player.level(), pos);
        } else {
            switch (action) {
                case LEFT_CLICK_BLOCK: {
                    action = Action.LEFT_CLICK_AIR;
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    action = Action.RIGHT_CLICK_AIR;
                }
            }
        }
        BlockFace blockFace = CraftBlock.notchToBlockFace(direction);
        if (itemInHand.isEmpty()) {
            itemInHand = null;
        }
        PlayerInteractEvent event = new PlayerInteractEvent(cplayer, action, (ItemStack)itemInHand, (Block)clickedBlock, blockFace, hand == null ? null : (hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND), clickedPos);
        if (cancelledBlock) {
            event.setUseInteractedBlock(Event.Result.DENY);
        }
        if (cancelledItem) {
            event.setUseItemInHand(Event.Result.DENY);
        }
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTransformEvent callEntityTransformEvent(LivingEntity original, LivingEntity converted, EntityTransformEvent.TransformReason transformReason) {
        return CraftEventFactory.callEntityTransformEvent(original, Collections.singletonList(converted), transformReason);
    }

    public static EntityTransformEvent callEntityTransformEvent(LivingEntity original, List<LivingEntity> convertedList, EntityTransformEvent.TransformReason convertType) {
        ArrayList<CraftEntity> list = new ArrayList<CraftEntity>();
        for (LivingEntity entityLiving : convertedList) {
            list.add(entityLiving.getBukkitEntity());
        }
        EntityTransformEvent event = new EntityTransformEvent((Entity)original.getBukkitEntity(), list, convertType);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityShootBowEvent callEntityShootBowEvent(LivingEntity entity, net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack consumableItem, net.minecraft.world.entity.Entity entityArrow, InteractionHand hand, float force, boolean consumeItem) {
        org.bukkit.entity.LivingEntity shooter = (org.bukkit.entity.LivingEntity)entity.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(bow);
        CraftItemStack itemConsumable = CraftItemStack.asCraftMirror(consumableItem);
        CraftEntity arrow = entityArrow.getBukkitEntity();
        if (itemInHand.isEmpty()) {
            itemInHand = null;
        }
        EntityShootBowEvent event = new EntityShootBowEvent(shooter, (ItemStack)itemInHand, (ItemStack)itemConsumable, (Entity)arrow, CraftEquipmentSlot.getHand(hand), force, consumeItem);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VillagerCareerChangeEvent callVillagerCareerChangeEvent(Villager villager, Villager.Profession future, VillagerCareerChangeEvent.ChangeReason reason) {
        VillagerCareerChangeEvent event = new VillagerCareerChangeEvent((org.bukkit.entity.Villager)villager.getBukkitEntity(), future, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDamageEvent callBlockDamageEvent(ServerPlayer player, BlockPos pos, Direction direction, net.minecraft.world.item.ItemStack item, boolean instaBreak) {
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(item);
        CraftBlock clickedBlock = CraftBlock.at(player.level(), pos);
        BlockDamageEvent event = new BlockDamageEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (Block)clickedBlock, CraftBlock.notchToBlockFace(direction), (ItemStack)itemInHand, instaBreak);
        event.callEvent();
        return event;
    }

    public static BlockDamageAbortEvent callBlockDamageAbortEvent(ServerPlayer player, BlockPos pos, net.minecraft.world.item.ItemStack item) {
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(item);
        CraftBlock clickedBlock = CraftBlock.at(player.level(), pos);
        BlockDamageAbortEvent event = new BlockDamageAbortEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (Block)clickedBlock, (ItemStack)itemInHand);
        event.callEvent();
        return event;
    }

    public static boolean doEntityAddEventCalling(Level world, net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (entity == null) {
            return false;
        }
        ItemSpawnEvent event = null;
        if (entity instanceof LivingEntity && !(entity instanceof ServerPlayer)) {
            event = CraftEventFactory.callCreatureSpawnEvent((LivingEntity)entity, spawnReason);
        } else if (entity instanceof ItemEntity) {
            event = CraftEventFactory.callItemSpawnEvent((ItemEntity)entity);
        } else if (entity.getBukkitEntity() instanceof org.bukkit.entity.Projectile) {
            event = CraftEventFactory.callProjectileLaunchEvent(entity);
        } else if (entity.getBukkitEntity() instanceof Vehicle) {
            event = CraftEventFactory.callVehicleCreateEvent(entity);
        } else if (entity.getBukkitEntity() instanceof LightningStrike) {
            LightningStrikeEvent.Cause cause;
            switch (spawnReason) {
                case COMMAND: {
                    LightningStrikeEvent.Cause cause2 = LightningStrikeEvent.Cause.COMMAND;
                    break;
                }
                case CUSTOM: {
                    LightningStrikeEvent.Cause cause2 = LightningStrikeEvent.Cause.CUSTOM;
                    break;
                }
                case SPAWNER: {
                    LightningStrikeEvent.Cause cause2 = LightningStrikeEvent.Cause.SPAWNER;
                    break;
                }
                default: {
                    LightningStrikeEvent.Cause cause2 = cause = LightningStrikeEvent.Cause.UNKNOWN;
                }
            }
            if (cause == LightningStrikeEvent.Cause.UNKNOWN && spawnReason == CreatureSpawnEvent.SpawnReason.DEFAULT) {
                return true;
            }
            event = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entity.getBukkitEntity(), cause);
        } else if (!(entity instanceof ServerPlayer)) {
            event = CraftEventFactory.callEntitySpawnEvent(entity);
        }
        if (event != null && (event.isCancelled() || entity.isRemoved())) {
            net.minecraft.world.entity.Entity vehicle = entity.getVehicle();
            if (vehicle != null) {
                vehicle.discard(null);
            }
            for (net.minecraft.world.entity.Entity passenger : entity.getIndirectPassengers()) {
                passenger.discard(null);
            }
            entity.discard(null);
            return false;
        }
        if (entity instanceof net.minecraft.world.entity.ExperienceOrb) {
            net.minecraft.world.entity.ExperienceOrb xp = (net.minecraft.world.entity.ExperienceOrb)entity;
            double radius = world.spigotConfig.expMerge;
            event = CraftEventFactory.callEntitySpawnEvent(entity);
            if (radius > 0.0 && !event.isCancelled() && !entity.isRemoved()) {
                boolean mergeUnconditionally;
                long maxValue = world.paperConfig().entities.behavior.experienceMergeMaxValue;
                boolean bl = mergeUnconditionally = maxValue <= 0L;
                if (mergeUnconditionally || (long)xp.getValue() < maxValue) {
                    List<net.minecraft.world.entity.Entity> entities = world.getEntities(entity, entity.getBoundingBox().inflate(radius, radius, radius));
                    for (net.minecraft.world.entity.Entity e : entities) {
                        long newTotal;
                        net.minecraft.world.entity.ExperienceOrb loopItem;
                        if (!(e instanceof net.minecraft.world.entity.ExperienceOrb) || (loopItem = (net.minecraft.world.entity.ExperienceOrb)e).isRemoved() || xp.count != loopItem.count || !mergeUnconditionally && (long)loopItem.getValue() >= maxValue || !new ExperienceOrbMergeEvent((ExperienceOrb)entity.getBukkitEntity(), (ExperienceOrb)loopItem.getBukkitEntity()).callEvent() || (int)(newTotal = (long)xp.getValue() + (long)loopItem.getValue()) < 0) continue;
                        if (!mergeUnconditionally && newTotal > maxValue) {
                            loopItem.setValue((int)(newTotal - maxValue));
                            xp.setValue((int)maxValue);
                            continue;
                        }
                        xp.setValue(xp.getValue() + loopItem.getValue());
                        loopItem.discard(null);
                    }
                }
            }
        }
        return true;
    }

    public static EntitySpawnEvent callEntitySpawnEvent(net.minecraft.world.entity.Entity entity) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        EntitySpawnEvent event = new EntitySpawnEvent((Entity)bukkitEntity);
        bukkitEntity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static CreatureSpawnEvent callCreatureSpawnEvent(LivingEntity entityliving, CreatureSpawnEvent.SpawnReason spawnReason) {
        org.bukkit.entity.LivingEntity entity = (org.bukkit.entity.LivingEntity)entityliving.getBukkitEntity();
        CraftServer craftServer = (CraftServer)entity.getServer();
        CreatureSpawnEvent event = new CreatureSpawnEvent(entity, spawnReason);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTameEvent callEntityTameEvent(Mob entity, Player tamer) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        CraftHumanEntity bukkitTamer = tamer != null ? tamer.getBukkitEntity() : null;
        CraftServer craftServer = (CraftServer)bukkitEntity.getServer();
        EntityTameEvent event = new EntityTameEvent((org.bukkit.entity.LivingEntity)bukkitEntity, (AnimalTamer)bukkitTamer);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemSpawnEvent callItemSpawnEvent(ItemEntity entityitem) {
        Item entity = (Item)entityitem.getBukkitEntity();
        CraftServer craftServer = (CraftServer)entity.getServer();
        ItemSpawnEvent event = new ItemSpawnEvent(entity);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemDespawnEvent callItemDespawnEvent(ItemEntity entityitem) {
        Item entity = (Item)entityitem.getBukkitEntity();
        ItemDespawnEvent event = new ItemDespawnEvent(entity, entity.getLocation());
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callItemMergeEvent(ItemEntity merging, ItemEntity mergingWith) {
        Item entityMerging = (Item)merging.getBukkitEntity();
        Item entityMergingWith = (Item)mergingWith.getBukkitEntity();
        ItemMergeEvent event = new ItemMergeEvent(entityMerging, entityMergingWith);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PotionSplashEvent callPotionSplashEvent(ThrownSplashPotion potion, @Nullable HitResult position, Map<org.bukkit.entity.LivingEntity, Double> affectedEntities) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position != null && position.getType() == HitResult.Type.BLOCK) {
            BlockHitResult positionBlock = (BlockHitResult)position;
            hitBlock = CraftBlock.at(potion.level(), positionBlock.getBlockPos());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.getDirection());
        }
        CraftEntity hitEntity = null;
        if (position != null && position.getType() == HitResult.Type.ENTITY) {
            hitEntity = ((EntityHitResult)position).getEntity().getBukkitEntity();
        }
        PotionSplashEvent event = new PotionSplashEvent(thrownPotion, hitEntity, hitBlock, hitFace, affectedEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static LingeringPotionSplashEvent callLingeringPotionSplashEvent(ThrownLingeringPotion potion, @Nullable HitResult position, net.minecraft.world.entity.AreaEffectCloud cloud) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        AreaEffectCloud effectCloud = (AreaEffectCloud)cloud.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position != null && position.getType() == HitResult.Type.BLOCK) {
            BlockHitResult positionBlock = (BlockHitResult)position;
            hitBlock = CraftBlock.at(potion.level(), positionBlock.getBlockPos());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.getDirection());
        }
        CraftEntity hitEntity = null;
        if (position != null && position.getType() == HitResult.Type.ENTITY) {
            hitEntity = ((EntityHitResult)position).getEntity().getBukkitEntity();
        }
        LingeringPotionSplashEvent event = new LingeringPotionSplashEvent(thrownPotion, hitEntity, hitBlock, hitFace, effectCloud);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static WaterBottleSplashEvent callWaterBottleSplashEvent(AbstractThrownPotion potion, @Nullable HitResult hitResult, Map<org.bukkit.entity.LivingEntity, Double> affectedEntities, Set<org.bukkit.entity.LivingEntity> rehydrate, Set<org.bukkit.entity.LivingEntity> extinguish) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        CraftEntity hitEntity = null;
        if (hitResult != null) {
            if (hitResult.getType() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                hitBlock = CraftBlock.at(potion.level(), blockHitResult.getBlockPos());
                hitFace = CraftBlock.notchToBlockFace(blockHitResult.getDirection());
            } else if (hitResult.getType() == HitResult.Type.ENTITY) {
                hitEntity = ((EntityHitResult)hitResult).getEntity().getBukkitEntity();
            }
        }
        WaterBottleSplashEvent event = new WaterBottleSplashEvent(thrownPotion, hitEntity, hitBlock, hitFace, affectedEntities, rehydrate, extinguish);
        event.callEvent();
        return event;
    }

    public static BlockFadeEvent callBlockFadeEvent(LevelAccessor world, BlockPos pos, net.minecraft.world.level.block.state.BlockState state) {
        CraftBlockState snapshot = CraftBlockStates.getBlockState(world, pos);
        snapshot.setData(state);
        BlockFadeEvent event = new BlockFadeEvent((Block)snapshot.getBlock(), (BlockState)snapshot);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleMoistureChangeEvent(Level world, BlockPos pos, net.minecraft.world.level.block.state.BlockState state, @Block.UpdateFlags int flags) {
        CraftBlockState snapshot = CraftBlockStates.getBlockState(world, pos);
        snapshot.setData(state);
        MoistureChangeEvent event = new MoistureChangeEvent((Block)snapshot.getBlock(), (BlockState)snapshot);
        if (event.callEvent()) {
            snapshot.place(flags);
            return true;
        }
        return false;
    }

    public static boolean handleBlockSpreadEvent(LevelAccessor world, BlockPos source, BlockPos target, net.minecraft.world.level.block.state.BlockState state, @Block.UpdateFlags int flags) {
        return CraftEventFactory.handleBlockSpreadEvent(world, source, target, state, flags, false);
    }

    public static boolean handleBlockSpreadEvent(LevelAccessor world, BlockPos source, BlockPos target, net.minecraft.world.level.block.state.BlockState state, @Block.UpdateFlags int flags, boolean checkSetResult) {
        if (!(world instanceof Level)) {
            boolean result = world.setBlock(target, state, flags);
            return !checkSetResult || result;
        }
        CraftBlockState snapshot = CraftBlockStates.getBlockState(world, target);
        snapshot.setData(state);
        BlockSpreadEvent event = new BlockSpreadEvent((Block)snapshot.getBlock(), (Block)CraftBlock.at(world, sourceBlockOverride != null ? sourceBlockOverride : source), (BlockState)snapshot);
        if (event.callEvent()) {
            boolean result = snapshot.place(flags);
            return !checkSetResult || result;
        }
        return false;
    }

    public static EntityDeathEvent callEntityDeathEvent(LivingEntity victim, net.minecraft.world.damagesource.DamageSource damageSource) {
        return CraftEventFactory.callEntityDeathEvent(victim, damageSource, new ArrayList<Entity.DefaultDrop>(0));
    }

    public static EntityDeathEvent callEntityDeathEvent(LivingEntity victim, net.minecraft.world.damagesource.DamageSource damageSource, List<Entity.DefaultDrop> drops) {
        return CraftEventFactory.callEntityDeathEvent(victim, damageSource, drops, Runnables.doNothing());
    }

    public static EntityDeathEvent callEntityDeathEvent(LivingEntity victim, net.minecraft.world.damagesource.DamageSource damageSource, List<Entity.DefaultDrop> drops, Runnable lootCheck) {
        CraftLivingEntity entity = (CraftLivingEntity)victim.getBukkitEntity();
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        CraftWorld world = (CraftWorld)entity.getWorld();
        EntityDeathEvent event = new EntityDeathEvent((org.bukkit.entity.LivingEntity)entity, (DamageSource)bukkitDamageSource, (List)new TransformingRandomAccessList(drops, Entity.DefaultDrop::stack, FROM_FUNCTION), victim.getExpReward(world.getHandle(), damageSource.getEntity()));
        CraftEventFactory.populateFields(victim, event);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        CraftEventFactory.playDeathSound(victim, event, damageSource);
        victim.expToDrop = event.getDroppedExp();
        lootCheck.run();
        for (Entity.DefaultDrop drop : drops) {
            ItemStack stack;
            if (drop == null || (stack = drop.stack()) == null || stack.getType() == Material.AIR || stack.getAmount() == 0) continue;
            drop.runConsumer(s -> world.dropItem(entity.getLocation(), (ItemStack)s));
        }
        return event;
    }

    public static PlayerDeathEvent callPlayerDeathEvent(ServerPlayer victim, net.minecraft.world.damagesource.DamageSource damageSource, List<Entity.DefaultDrop> drops, Component deathMessage, boolean showDeathMessages, boolean keepInventory) {
        CraftPlayer entity = victim.getBukkitEntity();
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        PlayerDeathEvent event = new PlayerDeathEvent((org.bukkit.entity.Player)entity, (DamageSource)bukkitDamageSource, (List)new TransformingRandomAccessList(drops, Entity.DefaultDrop::stack, FROM_FUNCTION), victim.getExpReward(victim.level(), damageSource.getEntity()), 0, deathMessage, showDeathMessages);
        event.setKeepInventory(keepInventory);
        event.setKeepLevel(victim.keepLevel);
        CraftEventFactory.populateFields(victim, (EntityDeathEvent)event);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        CraftEventFactory.playDeathSound(victim, (EntityDeathEvent)event, damageSource);
        victim.keepLevel = event.getKeepLevel();
        victim.newLevel = event.getNewLevel();
        victim.newTotalExp = event.getNewTotalExp();
        victim.expToDrop = event.getDroppedExp();
        victim.newExp = event.getNewExp();
        for (Entity.DefaultDrop drop : drops) {
            ItemStack stack;
            if (drop == null || (stack = drop.stack()) == null || stack.getType() == Material.AIR) continue;
            drop.runConsumer(s -> victim.drop(CraftItemStack.unwrap(s), true, false));
        }
        return event;
    }

    private static void populateFields(LivingEntity victim, EntityDeathEvent event) {
        event.setReviveHealth(event.getEntity().getAttribute(Attribute.MAX_HEALTH).getValue());
        event.setShouldPlayDeathSound(!victim.silentDeath && !victim.isSilent());
        SoundEvent soundEffect = victim.getDeathSound();
        event.setDeathSound(soundEffect != null ? CraftSound.minecraftToBukkit(soundEffect) : null);
        event.setDeathSoundCategory(SoundCategory.valueOf((String)victim.getSoundSource().name()));
        event.setDeathSoundVolume(victim.getSoundVolume());
        event.setDeathSoundPitch(victim.getVoicePitch());
    }

    private static void playDeathSound(LivingEntity victim, EntityDeathEvent event, net.minecraft.world.damagesource.DamageSource damageSource) {
        if (event.shouldPlayDeathSound() && event.getDeathSound() != null && event.getDeathSoundCategory() != null) {
            Player source = victim instanceof Player ? (Player)victim : null;
            double x = event.getEntity().getLocation().getX();
            double y = event.getEntity().getLocation().getY();
            double z = event.getEntity().getLocation().getZ();
            SoundEvent soundEffect = CraftSound.bukkitToMinecraft(event.getDeathSound());
            SoundSource soundCategory = SoundSource.valueOf(event.getDeathSoundCategory().name());
            victim.level().playSound((net.minecraft.world.entity.Entity)source, x, y, z, soundEffect, soundCategory, event.getDeathSoundVolume(), event.getDeathSoundPitch());
            victim.playSecondaryHurtSound(damageSource);
        }
    }

    private static EntityDamageEvent handleEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions) {
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, modifierFunctions, false);
    }

    private static EntityDamageEvent handleEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        net.minecraft.world.entity.Entity damager;
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(source);
        net.minecraft.world.entity.Entity entity2 = damager = source.eventEntityDamager() != null ? source.eventEntityDamager() : source.getDirectEntity();
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            if (damager == null) {
                return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
            }
            EntityDamageEvent.DamageCause damageCause = damager.getBukkitEntity() instanceof TNTPrimed ? EntityDamageEvent.DamageCause.BLOCK_EXPLOSION : EntityDamageEvent.DamageCause.ENTITY_EXPLOSION;
            return CraftEventFactory.callEntityDamageEvent(damager, entity, damageCause, bukkitDamageSource, modifiers, modifierFunctions, cancelled, source.isCritical());
        }
        if (damager != null || source.getDirectEntity() != null) {
            EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.ENTITY_ATTACK;
            if (source.knownCause() != null) {
                cause = source.knownCause();
            } else if (damager instanceof Projectile) {
                if (damager.getBukkitEntity() instanceof ThrownPotion) {
                    cause = EntityDamageEvent.DamageCause.MAGIC;
                } else if (damager.getBukkitEntity() instanceof org.bukkit.entity.Projectile) {
                    cause = EntityDamageEvent.DamageCause.PROJECTILE;
                }
            } else if (source.is(DamageTypes.THORNS)) {
                cause = EntityDamageEvent.DamageCause.THORNS;
            } else if (source.is(DamageTypes.SONIC_BOOM)) {
                cause = EntityDamageEvent.DamageCause.SONIC_BOOM;
            } else if (source.is(DamageTypes.FALLING_STALACTITE) || source.is(DamageTypes.FALLING_BLOCK) || source.is(DamageTypes.FALLING_ANVIL)) {
                cause = EntityDamageEvent.DamageCause.FALLING_BLOCK;
            } else if (source.is(DamageTypes.LIGHTNING_BOLT)) {
                cause = EntityDamageEvent.DamageCause.LIGHTNING;
            } else if (source.is(DamageTypes.FALL)) {
                cause = EntityDamageEvent.DamageCause.FALL;
            } else if (source.is(DamageTypes.DRAGON_BREATH)) {
                cause = EntityDamageEvent.DamageCause.DRAGON_BREATH;
            } else if (source.is(DamageTypes.MAGIC)) {
                cause = EntityDamageEvent.DamageCause.MAGIC;
            }
            return CraftEventFactory.callEntityDamageEvent(damager, entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled, source.isCritical());
        }
        if (source.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, EntityDamageEvent.DamageCause.VOID, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        if (source.is(DamageTypes.LAVA)) {
            return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, EntityDamageEvent.DamageCause.LAVA, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        if (source.eventBlockDamager() != null) {
            EntityDamageEvent.DamageCause cause = source.knownCause() != null ? source.knownCause() : (source.is(DamageTypes.CACTUS) || source.is(DamageTypes.SWEET_BERRY_BUSH) || source.is(DamageTypes.STALAGMITE) || source.is(DamageTypes.FALLING_STALACTITE) || source.is(DamageTypes.FALLING_ANVIL) ? EntityDamageEvent.DamageCause.CONTACT : (source.is(DamageTypes.HOT_FLOOR) ? EntityDamageEvent.DamageCause.HOT_FLOOR : (source.is(DamageTypes.MAGIC) ? EntityDamageEvent.DamageCause.MAGIC : (source.is(DamageTypes.IN_FIRE) ? EntityDamageEvent.DamageCause.FIRE : (source.is(DamageTypes.CAMPFIRE) ? EntityDamageEvent.DamageCause.CAMPFIRE : EntityDamageEvent.DamageCause.CUSTOM)))));
            return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        EntityDamageEvent.DamageCause cause = source.knownCause() != null ? source.knownCause() : (source.is(DamageTypes.IN_FIRE) ? EntityDamageEvent.DamageCause.FIRE : (source.is(DamageTypes.STARVE) ? EntityDamageEvent.DamageCause.STARVATION : (source.is(DamageTypes.WITHER) ? EntityDamageEvent.DamageCause.WITHER : (source.is(DamageTypes.IN_WALL) ? EntityDamageEvent.DamageCause.SUFFOCATION : (source.is(DamageTypes.DROWN) ? EntityDamageEvent.DamageCause.DROWNING : (source.is(DamageTypes.ON_FIRE) ? EntityDamageEvent.DamageCause.FIRE_TICK : (source.is(DamageTypes.MAGIC) ? EntityDamageEvent.DamageCause.MAGIC : (source.is(DamageTypes.FALL) ? EntityDamageEvent.DamageCause.FALL : (source.is(DamageTypes.FLY_INTO_WALL) ? EntityDamageEvent.DamageCause.FLY_INTO_WALL : (source.is(DamageTypes.CRAMMING) ? EntityDamageEvent.DamageCause.CRAMMING : (source.is(DamageTypes.DRY_OUT) ? EntityDamageEvent.DamageCause.DRYOUT : (source.is(DamageTypes.FREEZE) ? EntityDamageEvent.DamageCause.FREEZE : (source.is(DamageTypes.GENERIC_KILL) ? EntityDamageEvent.DamageCause.KILL : (source.is(DamageTypes.OUTSIDE_BORDER) ? EntityDamageEvent.DamageCause.WORLD_BORDER : EntityDamageEvent.DamageCause.CUSTOM))))))))))))));
        return CraftEventFactory.callEntityDamageEvent(null, entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled, source.isCritical());
    }

    private static EntityDamageEvent callEntityDamageEvent(net.minecraft.world.entity.Entity damager, net.minecraft.world.entity.Entity damagee, EntityDamageEvent.DamageCause cause, DamageSource bukkitDamageSource, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled, boolean critical) {
        Object event = damager != null ? new EntityDamageByEntityEvent((Entity)damager.getBukkitEntity(), (Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions, critical) : new EntityDamageEvent((Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions);
        return CraftEventFactory.callEntityDamageEvent(event, damagee, cancelled);
    }

    private static EntityDamageEvent callEntityDamageEvent(Block damager, BlockState damagerState, net.minecraft.world.entity.Entity damagee, EntityDamageEvent.DamageCause cause, DamageSource bukkitDamageSource, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        EntityDamageByBlockEvent event = new EntityDamageByBlockEvent(damager, damagerState, (Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions);
        return CraftEventFactory.callEntityDamageEvent((EntityDamageEvent)event, damagee, cancelled);
    }

    private static EntityDamageEvent callEntityDamageEvent(EntityDamageEvent event, net.minecraft.world.entity.Entity damagee, boolean cancelled) {
        event.setCancelled(cancelled);
        event.callEvent();
        if (!event.isCancelled()) {
            event.getEntity().setLastDamageCause(event);
        } else {
            damagee.lastDamageCancelled = true;
        }
        return event;
    }

    public static EntityDamageEvent handleLivingEntityDamageEvent(net.minecraft.world.entity.Entity damagee, net.minecraft.world.damagesource.DamageSource source, double rawDamage, double freezingModifier, double hardHatModifier, double blockingModifier, double armorModifier, double resistanceModifier, double magicModifier, double absorptionModifier, com.google.common.base.Function<Double, Double> freezing, com.google.common.base.Function<Double, Double> hardHat, com.google.common.base.Function<Double, Double> blocking, com.google.common.base.Function<Double, Double> armor, com.google.common.base.Function<Double, Double> resistance, com.google.common.base.Function<Double, Double> magic, com.google.common.base.Function<Double, Double> absorption) {
        return CraftEventFactory.handleLivingEntityDamageEvent(damagee, source, rawDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption, null);
    }

    public static EntityDamageEvent handleLivingEntityDamageEvent(net.minecraft.world.entity.Entity damagee, net.minecraft.world.damagesource.DamageSource source, double rawDamage, double freezingModifier, double hardHatModifier, double blockingModifier, double armorModifier, double resistanceModifier, double magicModifier, double absorptionModifier, com.google.common.base.Function<Double, Double> freezing, com.google.common.base.Function<Double, Double> hardHat, com.google.common.base.Function<Double, Double> blocking, com.google.common.base.Function<Double, Double> armor, com.google.common.base.Function<Double, Double> resistance, com.google.common.base.Function<Double, Double> magic, com.google.common.base.Function<Double, Double> absorption, BiConsumer<Map<EntityDamageEvent.DamageModifier, Double>, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>> callback) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, rawDamage);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        if (source.is(DamageTypeTags.IS_FREEZING)) {
            modifiers.put(EntityDamageEvent.DamageModifier.FREEZING, freezingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.FREEZING, freezing);
        }
        if (source.is(DamageTypeTags.DAMAGES_HELMET)) {
            modifiers.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHatModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHat);
        }
        if (damagee instanceof Player) {
            modifiers.put(EntityDamageEvent.DamageModifier.BLOCKING, blockingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.BLOCKING, blocking);
        }
        modifiers.put(EntityDamageEvent.DamageModifier.ARMOR, armorModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ARMOR, armor);
        modifiers.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistanceModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistance);
        modifiers.put(EntityDamageEvent.DamageModifier.MAGIC, magicModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.MAGIC, magic);
        modifiers.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorptionModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorption);
        if (callback != null) {
            callback.accept(modifiers, modifierFunctions);
        }
        return CraftEventFactory.handleEntityDamageEvent(damagee, source, modifiers, modifierFunctions);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, true);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage, boolean cancelOnZeroDamage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, cancelOnZeroDamage, false);
    }

    public static EntityDamageEvent callNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage, boolean cancelled) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> functions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, damage);
        functions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, functions, cancelled);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage, boolean cancelOnZeroDamage, boolean cancelled) {
        EntityDamageEvent event = CraftEventFactory.callNonLivingEntityDamageEvent(entity, source, damage, cancelled);
        if (event == null) {
            return false;
        }
        return event.isCancelled() || cancelOnZeroDamage && event.getDamage() == 0.0;
    }

    public static PlayerLevelChangeEvent callPlayerLevelChangeEvent(org.bukkit.entity.Player player, int oldLevel, int newLevel) {
        PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(player, oldLevel, newLevel);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpCooldownChangeEvent callPlayerXpCooldownEvent(Player entity, int newCooldown, PlayerExpCooldownChangeEvent.ChangeReason changeReason) {
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)entity.getBukkitEntity();
        PlayerExpCooldownChangeEvent event = new PlayerExpCooldownChangeEvent(player, newCooldown, changeReason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerItemMendEvent callPlayerItemMendEvent(Player entity, net.minecraft.world.entity.ExperienceOrb orb, net.minecraft.world.item.ItemStack nmsMendedItem, net.minecraft.world.entity.EquipmentSlot slot, int repairAmount, int consumedExperience) {
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)entity.getBukkitEntity();
        CraftItemStack bukkitStack = CraftItemStack.asCraftMirror(nmsMendedItem);
        PlayerItemMendEvent event = new PlayerItemMendEvent(player, (ItemStack)bukkitStack, CraftEquipmentSlot.getSlot(slot), (ExperienceOrb)orb.getBukkitEntity(), repairAmount, consumedExperience);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpChangeEvent callPlayerExpChangeEvent(Player entity, net.minecraft.world.entity.ExperienceOrb entityOrb, int expAmount) {
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)entity.getBukkitEntity();
        ExperienceOrb source = (ExperienceOrb)entityOrb.getBukkitEntity();
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, (Entity)source, expAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockGrowEvent(Level world, BlockPos pos, net.minecraft.world.level.block.state.BlockState state, @Block.UpdateFlags int flags) {
        CraftBlockState snapshot = CraftBlockStates.getBlockState(world, pos);
        snapshot.setData(state);
        BlockGrowEvent event = new BlockGrowEvent((Block)snapshot.getBlock(), (BlockState)snapshot);
        if (event.callEvent()) {
            snapshot.place(flags);
            return true;
        }
        return false;
    }

    public static FluidLevelChangeEvent callFluidLevelChangeEvent(Level world, BlockPos block, net.minecraft.world.level.block.state.BlockState newData) {
        FluidLevelChangeEvent event = new FluidLevelChangeEvent((Block)CraftBlock.at(world, block), (BlockData)CraftBlockData.fromData(newData));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(Player entity, int level) {
        return CraftEventFactory.callFoodLevelChangeEvent(entity, level, null);
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(Player entity, int level, net.minecraft.world.item.ItemStack item) {
        FoodLevelChangeEvent event = new FoodLevelChangeEvent((HumanEntity)entity.getBukkitEntity(), level, item == null ? null : CraftItemStack.asBukkitCopy(item));
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PigZapEvent callPigZapEvent(net.minecraft.world.entity.Entity pig, net.minecraft.world.entity.Entity lightning, net.minecraft.world.entity.Entity pigzombie) {
        PigZapEvent event = new PigZapEvent((Pig)pig.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), (PigZombie)pigzombie.getBukkitEntity());
        pig.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callHorseJumpEvent(net.minecraft.world.entity.Entity horse, float power) {
        HorseJumpEvent event = new HorseJumpEvent((AbstractHorse)horse.getBukkitEntity(), power);
        horse.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static EntityZapEvent callEntityZapEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity lightning, net.minecraft.world.entity.Entity changedEntity) {
        EntityZapEvent event = new EntityZapEvent((Entity)entity.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), (Entity)changedEntity.getBukkitEntity());
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callEntityChangeBlockEvent(net.minecraft.world.entity.Entity entity, BlockPos pos, net.minecraft.world.level.block.state.BlockState newState) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity, pos, newState, false);
    }

    public static boolean callEntityChangeBlockEvent(net.minecraft.world.entity.Entity entity, BlockPos pos, net.minecraft.world.level.block.state.BlockState newState, boolean cancelled) {
        CraftBlock block = CraftBlock.at(entity.level(), pos);
        EntityChangeBlockEvent event = new EntityChangeBlockEvent((Entity)entity.getBukkitEntity(), (Block)block, (BlockData)CraftBlockData.fromData(newState));
        event.setCancelled(cancelled);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static CreeperPowerEvent callCreeperPowerEvent(net.minecraft.world.entity.Entity creeper, net.minecraft.world.entity.Entity lightning, CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)creeper.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), cause);
        creeper.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTargetEvent callEntityTargetEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity target, EntityTargetEvent.TargetReason reason) {
        EntityTargetEvent event = new EntityTargetEvent((Entity)entity.getBukkitEntity(), (Entity)(target == null ? null : target.getBukkitEntity()), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTargetLivingEntityEvent callEntityTargetLivingEvent(net.minecraft.world.entity.Entity entity, LivingEntity target, EntityTargetEvent.TargetReason reason) {
        EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((Entity)entity.getBukkitEntity(), target == null ? null : (org.bukkit.entity.LivingEntity)target.getBukkitEntity(), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreakDoorEvent callEntityBreakDoorEvent(net.minecraft.world.entity.Entity entity, BlockPos pos, net.minecraft.world.level.block.state.BlockState newState) {
        CraftEntity entity1 = entity.getBukkitEntity();
        CraftBlock block = CraftBlock.at(entity.level(), pos);
        EntityBreakDoorEvent event = new EntityBreakDoorEvent((org.bukkit.entity.LivingEntity)entity1, (Block)block, (BlockData)newState.createCraftBlockData());
        entity1.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    @Nullable
    public static AbstractContainerMenu callInventoryOpenEvent(ServerPlayer player, AbstractContainerMenu container) {
        return (AbstractContainerMenu)CraftEventFactory.callInventoryOpenEventWithTitle(player, container).getSecond();
    }

    public static Pair<@Nullable Component, @Nullable AbstractContainerMenu> callInventoryOpenEventWithTitle(ServerPlayer player, AbstractContainerMenu container) {
        return CraftEventFactory.callInventoryOpenEventWithTitle(player, container, false);
    }

    public static Pair<@Nullable Component, @Nullable AbstractContainerMenu> callInventoryOpenEventWithTitle(ServerPlayer player, AbstractContainerMenu container, boolean cancelled) {
        container.startOpen();
        if (player.containerMenu != player.inventoryMenu) {
            player.connection.handleContainerClose(new ServerboundContainerClosePacket(player.containerMenu.containerId), InventoryCloseEvent.Reason.OPEN_NEW);
        }
        CraftServer server = player.level().getCraftServer();
        CraftPlayer craftPlayer = player.getBukkitEntity();
        player.containerMenu.transferTo(container, craftPlayer);
        InventoryOpenEvent event = new InventoryOpenEvent(container.getBukkitView());
        event.setCancelled(cancelled);
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            container.transferTo(player.containerMenu, craftPlayer);
            return Pair.of(null, null);
        }
        return Pair.of((Object)event.titleOverride(), (Object)container);
    }

    public static net.minecraft.world.item.ItemStack callPreCraftEvent(CraftingContainer matrix, Container resultInventory, net.minecraft.world.item.ItemStack result, InventoryView lastCraftView, boolean isRepair) {
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(matrix, resultInventory);
        inventory.setResult(CraftItemStack.asCraftMirror(result));
        PrepareItemCraftEvent event = new PrepareItemCraftEvent((CraftingInventory)inventory, lastCraftView, isRepair);
        Bukkit.getPluginManager().callEvent((Event)event);
        return CraftItemStack.asNMSCopy(event.getInventory().getResult());
    }

    public static CrafterCraftEvent callCrafterCraftEvent(BlockPos pos, Level world, net.minecraft.world.item.ItemStack result, RecipeHolder<net.minecraft.world.item.crafting.CraftingRecipe> holder) {
        CraftBlock block = CraftBlock.at(world, pos);
        CraftItemStack itemStack = CraftItemStack.asCraftMirror(result);
        CraftingRecipe craftingRecipe = (CraftingRecipe)holder.toBukkitRecipe();
        CrafterCraftEvent crafterCraftEvent = new CrafterCraftEvent((Block)block, craftingRecipe, (ItemStack)itemStack);
        Bukkit.getPluginManager().callEvent((Event)crafterCraftEvent);
        return crafterCraftEvent;
    }

    @Deprecated
    public static ProjectileCollideEvent callProjectileCollideEvent(net.minecraft.world.entity.Entity entity, EntityHitResult position) {
        org.bukkit.entity.Projectile projectile = (org.bukkit.entity.Projectile)entity.getBukkitEntity();
        CraftEntity collided = position.getEntity().getBukkitEntity();
        ProjectileCollideEvent event = new ProjectileCollideEvent(projectile, (Entity)collided);
        if (projectile.getShooter() instanceof org.bukkit.entity.Player && collided instanceof org.bukkit.entity.Player && !((org.bukkit.entity.Player)projectile.getShooter()).canSee((org.bukkit.entity.Player)collided)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ProjectileLaunchEvent callProjectileLaunchEvent(net.minecraft.world.entity.Entity entity) {
        org.bukkit.entity.Projectile bukkitEntity = (org.bukkit.entity.Projectile)entity.getBukkitEntity();
        ProjectileLaunchEvent event = new ProjectileLaunchEvent((Entity)bukkitEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ProjectileHitEvent callProjectileHitEvent(net.minecraft.world.entity.Entity entity, HitResult hitResult) {
        if (hitResult.getType() == HitResult.Type.MISS) {
            return null;
        }
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult positionBlock = (BlockHitResult)hitResult;
            hitBlock = CraftBlock.at(entity.level(), positionBlock.getBlockPos());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.getDirection());
        }
        CraftEntity hitEntity = null;
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            hitEntity = ((EntityHitResult)hitResult).getEntity().getBukkitEntity();
        }
        boolean cancelled = false;
        if (hitEntity != null && hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            cancelled = CraftEventFactory.callProjectileCollideEvent(entity, entityHitResult).isCancelled();
        }
        ProjectileHitEvent event = new ProjectileHitEvent((org.bukkit.entity.Projectile)entity.getBukkitEntity(), (Entity)hitEntity, (Block)hitBlock, hitFace);
        event.setCancelled(cancelled);
        entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExpBottleEvent callExpBottleEvent(net.minecraft.world.entity.Entity entity, HitResult hitResult, int exp) {
        ThrownExpBottle bottle = (ThrownExpBottle)entity.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult positionBlock = (BlockHitResult)hitResult;
            hitBlock = CraftBlock.at(entity.level(), positionBlock.getBlockPos());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.getDirection());
        }
        CraftEntity hitEntity = null;
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            hitEntity = ((EntityHitResult)hitResult).getEntity().getBukkitEntity();
        }
        ExpBottleEvent event = new ExpBottleEvent(bottle, (Entity)hitEntity, (Block)hitBlock, hitFace, exp);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callBinaryRedstoneChange(LevelAccessor level, BlockPos pos, boolean willBePowered) {
        int oldCurrent = willBePowered ? 0 : 15;
        int newCurrent = willBePowered ? 15 : 0;
        return CraftEventFactory.callRedstoneChange(level, pos, oldCurrent, newCurrent).getNewCurrent() == newCurrent;
    }

    public static BlockRedstoneEvent callRedstoneChange(LevelAccessor level, BlockPos pos, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(level, pos), oldCurrent, newCurrent);
        event.callEvent();
        return event;
    }

    public static NotePlayEvent callNotePlayEvent(Level world, BlockPos pos, NoteBlockInstrument instrument, int note) {
        NotePlayEvent event = new NotePlayEvent((Block)CraftBlock.at(world, pos), Instrument.getByType((byte)((byte)instrument.ordinal())), new Note(note));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callPlayerItemBreakEvent(ServerPlayer human, net.minecraft.world.item.ItemStack brokenItem) {
        CraftItemStack item = CraftItemStack.asCraftMirror(brokenItem);
        PlayerItemBreakEvent event = new PlayerItemBreakEvent((org.bukkit.entity.Player)human.getBukkitEntity(), (ItemStack)item);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static BlockIgniteEvent callBlockIgniteEvent(Level world, BlockPos pos, BlockPos sourcePos) {
        CraftBlock igniter = CraftBlock.at(world, sourcePos);
        BlockIgniteEvent event = new BlockIgniteEvent((Block)CraftBlock.at(world, pos), switch (igniter.getType()) {
            case Material.LAVA -> BlockIgniteEvent.IgniteCause.LAVA;
            case Material.DISPENSER -> BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
            default -> BlockIgniteEvent.IgniteCause.SPREAD;
        }, (Block)igniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(Level world, BlockPos pos, net.minecraft.world.entity.Entity igniter) {
        net.minecraft.world.entity.Entity shooter;
        BlockIgniteEvent.IgniteCause cause;
        CraftEntity bukkitIgniter = igniter.getBukkitEntity();
        switch (bukkitIgniter.getType()) {
            case END_CRYSTAL: {
                BlockIgniteEvent.IgniteCause igniteCause = BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL;
                break;
            }
            case LIGHTNING_BOLT: {
                BlockIgniteEvent.IgniteCause igniteCause = BlockIgniteEvent.IgniteCause.LIGHTNING;
                break;
            }
            case SMALL_FIREBALL: 
            case FIREBALL: {
                BlockIgniteEvent.IgniteCause igniteCause = BlockIgniteEvent.IgniteCause.FIREBALL;
                break;
            }
            case ARROW: {
                BlockIgniteEvent.IgniteCause igniteCause = BlockIgniteEvent.IgniteCause.ARROW;
                break;
            }
            default: {
                BlockIgniteEvent.IgniteCause igniteCause = cause = BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
            }
        }
        if (igniter instanceof Projectile && (shooter = ((Projectile)igniter).getOwner()) != null) {
            bukkitIgniter = shooter.getBukkitEntity();
        }
        BlockIgniteEvent event = new BlockIgniteEvent((Block)CraftBlock.at(world, pos), cause, (Entity)bukkitIgniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(Level world, BlockPos pos, Explosion explosion) {
        CraftEntity igniter = explosion.getDirectSourceEntity() == null ? null : explosion.getDirectSourceEntity().getBukkitEntity();
        BlockIgniteEvent event = new BlockIgniteEvent((Block)CraftBlock.at(world, pos), BlockIgniteEvent.IgniteCause.EXPLOSION, (Entity)igniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(Level world, BlockPos pos, BlockIgniteEvent.IgniteCause cause, net.minecraft.world.entity.Entity igniter) {
        BlockIgniteEvent event = new BlockIgniteEvent((Block)CraftBlock.at(world, pos), cause, (Entity)igniter.getBukkitEntity());
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void handleInventoryCloseEvent(Player human, InventoryCloseEvent.Reason reason) {
        InventoryCloseEvent event = new InventoryCloseEvent(human.containerMenu.getBukkitView(), reason);
        human.level().getCraftServer().getPluginManager().callEvent((Event)event);
        human.containerMenu.transferTo(human.inventoryMenu, human.getBukkitEntity());
    }

    public static net.minecraft.world.item.ItemStack handleEditBookEvent(ServerPlayer player, int itemInHandIndex, net.minecraft.world.item.ItemStack itemInHand, net.minecraft.world.item.ItemStack newBookItem) {
        PlayerEditBookEvent editBookEvent = new PlayerEditBookEvent((org.bukkit.entity.Player)player.getBukkitEntity(), itemInHandIndex >= 0 && itemInHandIndex <= 8 ? itemInHandIndex : -1, (BookMeta)CraftItemStack.getItemMeta(itemInHand), (BookMeta)CraftItemStack.getItemMeta(newBookItem), newBookItem.is(Items.WRITTEN_BOOK));
        player.level().getCraftServer().getPluginManager().callEvent((Event)editBookEvent);
        if (itemInHand != null && itemInHand.is(Items.WRITABLE_BOOK)) {
            if (!editBookEvent.isCancelled()) {
                if (editBookEvent.isSigning()) {
                    itemInHand.setItem(Items.WRITTEN_BOOK);
                }
                BookMeta meta = editBookEvent.getNewBookMeta();
                CraftItemStack.setItemMeta(itemInHand, (ItemMeta)meta);
            } else {
                player.containerMenu.forceSlot(player.getInventory(), itemInHandIndex);
            }
        }
        return itemInHand;
    }

    public static void callRecipeBookSettingsEvent(ServerPlayer player, RecipeBookType type, boolean open, boolean filter) {
        PlayerRecipeBookSettingsChangeEvent.RecipeBookType bukkitType = PlayerRecipeBookSettingsChangeEvent.RecipeBookType.values()[type.ordinal()];
        Bukkit.getPluginManager().callEvent((Event)new PlayerRecipeBookSettingsChangeEvent((org.bukkit.entity.Player)player.getBukkitEntity(), bukkitType, open, filter));
    }

    public static boolean handlePlayerUnleashEntityEvent(Leashable leashable, @Nullable Player player, @Nullable InteractionHand hand, boolean dropLeash, boolean resendState) {
        if (!(leashable instanceof net.minecraft.world.entity.Entity)) {
            return true;
        }
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)((Object)leashable);
        return CraftEventFactory.handlePlayerUnleashEntityEvent(entity, player, hand, dropLeash, resendState);
    }

    public static boolean handlePlayerUnleashEntityEvent(net.minecraft.world.entity.Entity entity, @Nullable Player player, @Nullable InteractionHand hand, boolean dropLeash, boolean resendState) {
        if (player == null || hand == null) {
            if (entity instanceof Leashable) {
                Leashable leashable = (Leashable)((Object)entity);
                if (dropLeash) {
                    leashable.dropLeash();
                } else {
                    leashable.removeLeash();
                }
            }
            return true;
        }
        PlayerUnleashEntityEvent event = new PlayerUnleashEntityEvent((Entity)entity.getBukkitEntity(), (org.bukkit.entity.Player)player.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), dropLeash);
        entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            if (resendState && entity instanceof Leashable) {
                Leashable leashable = (Leashable)((Object)entity);
                ((ServerPlayer)player).connection.send(new ClientboundSetEntityLinkPacket(entity, leashable.getLeashHolder()));
            }
            return false;
        }
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (event.isDropLeash()) {
                leashable.dropLeash();
            } else {
                leashable.removeLeash();
            }
        }
        return true;
    }

    public static boolean handlePlayerLeashEntityEvent(Leashable leashed, net.minecraft.world.entity.Entity leashHolder, Player player, InteractionHand hand) {
        if (!(leashed instanceof net.minecraft.world.entity.Entity)) {
            return true;
        }
        net.minecraft.world.entity.Entity leashedEntity = (net.minecraft.world.entity.Entity)((Object)leashed);
        return !CraftEventFactory.callPlayerLeashEntityEvent(leashedEntity, leashHolder, player, hand).isCancelled();
    }

    @Nullable
    public static PlayerLeashEntityEvent callPlayerLeashEntityEvent(Leashable leashed, net.minecraft.world.entity.Entity leashHolder, Player player, InteractionHand hand) {
        if (!(leashed instanceof net.minecraft.world.entity.Entity)) {
            return null;
        }
        net.minecraft.world.entity.Entity leashedEntity = (net.minecraft.world.entity.Entity)((Object)leashed);
        return CraftEventFactory.callPlayerLeashEntityEvent(leashedEntity, leashHolder, player, hand);
    }

    public static PlayerLeashEntityEvent callPlayerLeashEntityEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity leashHolder, Player player, InteractionHand hand) {
        PlayerLeashEntityEvent event = new PlayerLeashEntityEvent((Entity)entity.getBukkitEntity(), (Entity)leashHolder.getBukkitEntity(), (org.bukkit.entity.Player)player.getBukkitEntity(), CraftEquipmentSlot.getHand(hand));
        entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callPlayerRiptideEvent(Player player, net.minecraft.world.item.ItemStack tridentItemStack, float velocityX, float velocityY, float velocityZ) {
        PlayerRiptideEvent event = new PlayerRiptideEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(tridentItemStack), new Vector(velocityX, velocityY, velocityZ));
        return event.callEvent();
    }

    public static BlockShearEntityEvent callBlockShearEntityEvent(net.minecraft.world.entity.Entity animal, Block dispenser, CraftItemStack is, List<net.minecraft.world.item.ItemStack> drops) {
        BlockShearEntityEvent bse = new BlockShearEntityEvent(dispenser, (Entity)animal.getBukkitEntity(), (ItemStack)is, Lists.transform(drops, CraftItemStack::asCraftMirror));
        Bukkit.getPluginManager().callEvent((Event)bse);
        return bse;
    }

    public static PlayerShearEntityEvent handlePlayerShearEntityEvent(Player player, net.minecraft.world.entity.Entity sheared, net.minecraft.world.item.ItemStack shears, InteractionHand hand, List<net.minecraft.world.item.ItemStack> drops) {
        if (!(player instanceof ServerPlayer)) {
            return null;
        }
        PlayerShearEntityEvent event = new PlayerShearEntityEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (Entity)sheared.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(shears), hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND, Lists.transform(drops, CraftItemStack::asCraftMirror));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static Cancellable handleStatisticsIncrease(Player entityHuman, Stat<?> statistic, int current, int newValue) {
        PlayerStatisticIncrementEvent event;
        CraftPlayer player = ((ServerPlayer)entityHuman).getBukkitEntity();
        Statistic stat = CraftStatistic.getBukkitStatistic(statistic);
        if (stat == null) {
            System.err.println("Unhandled statistic: " + String.valueOf(statistic));
            return null;
        }
        switch (stat) {
            case FALL_ONE_CM: 
            case BOAT_ONE_CM: 
            case CLIMB_ONE_CM: 
            case WALK_ON_WATER_ONE_CM: 
            case WALK_UNDER_WATER_ONE_CM: 
            case FLY_ONE_CM: 
            case HORSE_ONE_CM: 
            case MINECART_ONE_CM: 
            case PIG_ONE_CM: 
            case PLAY_ONE_MINUTE: 
            case SWIM_ONE_CM: 
            case WALK_ONE_CM: 
            case SPRINT_ONE_CM: 
            case CROUCH_ONE_CM: 
            case TIME_SINCE_DEATH: 
            case SNEAK_TIME: 
            case TOTAL_WORLD_TIME: 
            case TIME_SINCE_REST: 
            case AVIATE_ONE_CM: 
            case STRIDER_ONE_CM: 
            case HAPPY_GHAST_ONE_CM: 
            case NAUTILUS_ONE_CM: {
                return null;
            }
        }
        if (stat.getType() == Statistic.Type.UNTYPED) {
            event = new PlayerStatisticIncrementEvent((org.bukkit.entity.Player)player, stat, current, newValue);
        } else if (stat.getType() == Statistic.Type.ENTITY) {
            EntityType entityType = CraftStatistic.getEntityTypeFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((org.bukkit.entity.Player)player, stat, current, newValue, entityType);
        } else {
            Material material = CraftStatistic.getMaterialFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((org.bukkit.entity.Player)player, stat, current, newValue, material);
        }
        event.callEvent();
        return (Cancellable)event;
    }

    public static boolean callFireworkExplodeEvent(FireworkRocketEntity firework) {
        FireworkExplodeEvent event = new FireworkExplodeEvent((Firework)firework.getBukkitEntity());
        if (!event.callEvent()) {
            firework.discard(null);
            return false;
        }
        return true;
    }

    public static PrepareAnvilEvent callPrepareAnvilEvent(AnvilView view, net.minecraft.world.item.ItemStack item) {
        view.getTopInventory().setItem(2, (ItemStack)CraftItemStack.asCraftMirror(item));
        return null;
    }

    public static PrepareGrindstoneEvent callPrepareGrindstoneEvent(InventoryView view, net.minecraft.world.item.ItemStack item) {
        view.getTopInventory().setItem(2, (ItemStack)CraftItemStack.asCraftMirror(item));
        return null;
    }

    public static PrepareSmithingEvent callPrepareSmithingEvent(InventoryView view, net.minecraft.world.item.ItemStack item) {
        view.getTopInventory().setItem(3, (ItemStack)CraftItemStack.asCraftMirror(item));
        return null;
    }

    public static void callPrepareResultEvent(AbstractContainerMenu container, int resultSlot) {
        Object event;
        CraftItemStack result;
        InventoryView view = container.getBukkitView();
        ItemStack origItem = view.getTopInventory().getItem(resultSlot);
        CraftItemStack craftItemStack = result = origItem != null ? CraftItemStack.asCraftCopy(origItem) : null;
        if (view.getTopInventory() instanceof AnvilInventory && view instanceof AnvilView) {
            AnvilView anvilView = (AnvilView)view;
            event = new PrepareAnvilEvent(anvilView, (ItemStack)result);
        } else {
            event = view.getTopInventory() instanceof GrindstoneInventory ? new PrepareGrindstoneEvent(view, (ItemStack)result) : (view.getTopInventory() instanceof SmithingInventory ? new PrepareSmithingEvent(view, (ItemStack)result) : new PrepareResultEvent(view, (ItemStack)result));
        }
        event.callEvent();
        event.getInventory().setItem(resultSlot, event.getResult());
        container.broadcastChanges();
    }

    public static SpawnerSpawnEvent callSpawnerSpawnEvent(net.minecraft.world.entity.Entity spawnee, BlockPos pos) {
        CraftEntity entity = spawnee.getBukkitEntity();
        BlockState state = CraftBlock.at(spawnee.level(), pos).getState();
        if (!(state instanceof CreatureSpawner)) {
            state = null;
        }
        SpawnerSpawnEvent event = new SpawnerSpawnEvent((Entity)entity, (CreatureSpawner)state);
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static TrialSpawnerSpawnEvent callTrialSpawnerSpawnEvent(net.minecraft.world.entity.Entity spawnee, BlockPos pos) {
        CraftEntity entity = spawnee.getBukkitEntity();
        BlockState state = CraftBlock.at(spawnee.level(), pos).getState();
        if (!(state instanceof TrialSpawner)) {
            state = null;
        }
        TrialSpawnerSpawnEvent event = new TrialSpawnerSpawnEvent((Entity)entity, (TrialSpawner)state);
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDispenseLootEvent callBlockDispenseLootEvent(ServerLevel level, BlockPos pos, Player player, List<net.minecraft.world.item.ItemStack> rewardLoot, net.minecraft.world.level.storage.loot.LootTable lootTable) {
        List craftItemStacks = rewardLoot.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        BlockDispenseLootEvent event = new BlockDispenseLootEvent(player == null ? null : (org.bukkit.entity.Player)player.getBukkitEntity(), (Block)CraftBlock.at(level, pos), craftItemStacks, (LootTable)lootTable.craftLootTable);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VaultDisplayItemEvent callVaultDisplayItemEvent(ServerLevel level, BlockPos pos, net.minecraft.world.item.ItemStack displayitemStack) {
        VaultDisplayItemEvent event = new VaultDisplayItemEvent((Block)CraftBlock.at(level, pos), CraftItemStack.asBukkitCopy(displayitemStack));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityToggleGlideEvent callToggleGlideEvent(LivingEntity entity, boolean gliding) {
        EntityToggleGlideEvent event = new EntityToggleGlideEvent((org.bukkit.entity.LivingEntity)entity.getBukkitEntity(), gliding);
        entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityToggleSwimEvent callToggleSwimEvent(LivingEntity entity, boolean swimming) {
        EntityToggleSwimEvent event = new EntityToggleSwimEvent((org.bukkit.entity.LivingEntity)entity.getBukkitEntity(), swimming);
        entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static AreaEffectCloudApplyEvent callAreaEffectCloudApplyEvent(net.minecraft.world.entity.AreaEffectCloud cloud, List<org.bukkit.entity.LivingEntity> entities) {
        AreaEffectCloudApplyEvent event = new AreaEffectCloudApplyEvent((AreaEffectCloud)cloud.getBukkitEntity(), entities);
        cloud.level().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VehicleCreateEvent callVehicleCreateEvent(net.minecraft.world.entity.Entity entity) {
        Vehicle bukkitEntity = (Vehicle)entity.getBukkitEntity();
        VehicleCreateEvent event = new VehicleCreateEvent(bukkitEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreedEvent callEntityBreedEvent(LivingEntity child, LivingEntity mother, LivingEntity father, LivingEntity breeder, net.minecraft.world.item.ItemStack bredWith, int experience) {
        org.bukkit.entity.LivingEntity breederEntity = breeder == null ? null : (org.bukkit.entity.LivingEntity)breeder.getBukkitEntity();
        CraftItemStack bredWithStack = bredWith == null ? null : CraftItemStack.asCraftMirror(bredWith).clone();
        EntityBreedEvent event = new EntityBreedEvent((org.bukkit.entity.LivingEntity)child.getBukkitEntity(), (org.bukkit.entity.LivingEntity)mother.getBukkitEntity(), (org.bukkit.entity.LivingEntity)father.getBukkitEntity(), breederEntity, (ItemStack)bredWithStack, experience);
        event.callEvent();
        return event;
    }

    public static BlockPhysicsEvent callBlockPhysicsEvent(LevelAccessor world, BlockPos pos) {
        CraftBlock block = CraftBlock.at(world, pos);
        BlockPhysicsEvent event = new BlockPhysicsEvent((Block)block, block.getBlockData());
        if (world instanceof Level) {
            event.callEvent();
        }
        return event;
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(LivingEntity entity, @Nullable MobEffectInstance oldEffect, @Nullable MobEffectInstance newEffect, EntityPotionEffectEvent.Cause cause) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(LivingEntity entity, @Nullable MobEffectInstance oldEffect, @Nullable MobEffectInstance newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(LivingEntity entity, @Nullable MobEffectInstance oldEffect, @Nullable MobEffectInstance newEffect, EntityPotionEffectEvent.Cause cause, boolean willOverride) {
        EntityPotionEffectEvent.Action action = EntityPotionEffectEvent.Action.CHANGED;
        if (oldEffect == null) {
            action = EntityPotionEffectEvent.Action.ADDED;
        } else if (newEffect == null) {
            action = EntityPotionEffectEvent.Action.REMOVED;
        }
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, willOverride);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(LivingEntity entity, @Nullable MobEffectInstance oldEffect, @Nullable MobEffectInstance newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action, boolean willOverride) {
        PotionEffect bukkitOldEffect = oldEffect == null ? null : CraftPotionUtil.toBukkit(oldEffect);
        PotionEffect bukkitNewEffect = newEffect == null ? null : CraftPotionUtil.toBukkit(newEffect);
        Preconditions.checkState((bukkitOldEffect != null || bukkitNewEffect != null ? 1 : 0) != 0, (Object)"Old and new potion effect are both null");
        EntityPotionEffectEvent event = new EntityPotionEffectEvent((org.bukkit.entity.LivingEntity)entity.getBukkitEntity(), bukkitOldEffect, bukkitNewEffect, cause, action, willOverride);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockFormEvent(Level world, BlockPos pos, net.minecraft.world.level.block.state.BlockState state, @Block.UpdateFlags int flags) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, state, flags, null);
    }

    public static boolean handleBlockFormEvent(Level world, BlockPos pos, net.minecraft.world.level.block.state.BlockState state, @Block.UpdateFlags int flags, @Nullable net.minecraft.world.entity.Entity entity) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, state, flags, entity, false);
    }

    public static boolean handleBlockFormEvent(Level world, BlockPos pos, net.minecraft.world.level.block.state.BlockState state, @Block.UpdateFlags int flags, @Nullable net.minecraft.world.entity.Entity entity, boolean checkSetResult) {
        BlockFormEvent event;
        CraftBlockState snapshot = CraftBlockStates.getBlockState(world, pos);
        snapshot.setData(state);
        Object object = event = entity == null ? new BlockFormEvent((Block)snapshot.getBlock(), (BlockState)snapshot) : new EntityBlockFormEvent((Entity)entity.getBukkitEntity(), (Block)snapshot.getBlock(), (BlockState)snapshot);
        if (event.callEvent()) {
            boolean result = snapshot.place(flags);
            return !checkSetResult || result;
        }
        return false;
    }

    public static boolean handleBatToggleSleepEvent(net.minecraft.world.entity.Entity bat, boolean awake) {
        BatToggleSleepEvent event = new BatToggleSleepEvent((Bat)bat.getBukkitEntity(), awake);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PlayerRecipeDiscoverEvent callPlayerRecipeListUpdateEvent(Player player, RecipeHolder<?> recipeHolder) {
        PlayerRecipeDiscoverEvent event = new PlayerRecipeDiscoverEvent((org.bukkit.entity.Player)player.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(recipeHolder.id().identifier()), recipeHolder.value().showNotification());
        event.callEvent();
        return event;
    }

    public static EntityPickupItemEvent callEntityPickupItemEvent(net.minecraft.world.entity.Entity entity, ItemEntity item, int remaining, boolean cancelled) {
        EntityPickupItemEvent event = new EntityPickupItemEvent((org.bukkit.entity.LivingEntity)entity.getBukkitEntity(), (Item)item.getBukkitEntity(), remaining);
        event.setCancelled(cancelled);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static LightningStrikeEvent callLightningStrikeEvent(LightningStrike entity, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent event = new LightningStrikeEvent(entity.getWorld(), entity, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callRaidTriggerEvent(Level level, net.minecraft.world.entity.raid.Raid raid, ServerPlayer player) {
        RaidTriggerEvent event = new RaidTriggerEvent((Raid)new CraftRaid(raid, level), (World)level.getWorld(), (org.bukkit.entity.Player)player.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static void callRaidFinishEvent(Level level, net.minecraft.world.entity.raid.Raid raid, List<org.bukkit.entity.Player> players) {
        RaidFinishEvent event = new RaidFinishEvent((Raid)new CraftRaid(raid, level), (World)level.getWorld(), players);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callRaidStopEvent(Level level, net.minecraft.world.entity.raid.Raid raid, RaidStopEvent.Reason reason) {
        RaidStopEvent event = new RaidStopEvent((Raid)new CraftRaid(raid, level), (World)level.getWorld(), reason);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callRaidSpawnWaveEvent(Level level, net.minecraft.world.entity.raid.Raid raid, Raider leader, Set<Raider> raiders) {
        org.bukkit.entity.Raider bukkitLeader = (org.bukkit.entity.Raider)leader.getBukkitEntity();
        ArrayList<org.bukkit.entity.Raider> bukkitRaiders = new ArrayList<org.bukkit.entity.Raider>(raiders.size());
        for (Raider raider : raiders) {
            bukkitRaiders.add((org.bukkit.entity.Raider)raider.getBukkitEntity());
        }
        RaidSpawnWaveEvent event = new RaidSpawnWaveEvent((Raid)new CraftRaid(raid, level), (World)level.getWorld(), bukkitLeader, bukkitRaiders);
        event.callEvent();
    }

    public static LootGenerateEvent callLootGenerateEvent(Container inventory, net.minecraft.world.level.storage.loot.LootTable lootTable, LootContext lootInfo, List<net.minecraft.world.item.ItemStack> loot, boolean plugin) {
        CraftWorld world = lootInfo.getLevel().getWorld();
        net.minecraft.world.entity.Entity entity = lootInfo.getOptionalParameter(LootContextParams.THIS_ENTITY);
        List bukkitLoot = loot.stream().map(CraftItemStack::asCraftMirror).collect(Collectors.toCollection(ArrayList::new));
        LootGenerateEvent event = new LootGenerateEvent((World)world, (Entity)(entity != null ? entity.getBukkitEntity() : null), inventory.getOwner(), (LootTable)lootTable.craftLootTable, CraftLootTable.convertContext(lootInfo), bukkitLoot, plugin);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callStriderTemperatureChangeEvent(net.minecraft.world.entity.monster.Strider strider, boolean shivering) {
        StriderTemperatureChangeEvent event = new StriderTemperatureChangeEvent((Strider)strider.getBukkitEntity(), shivering);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static boolean handleEntitySpellCastEvent(SpellcasterIllager caster, SpellcasterIllager.IllagerSpell spell) {
        EntitySpellCastEvent event = new EntitySpellCastEvent((Spellcaster)caster.getBukkitEntity(), CraftSpellcaster.toBukkitSpell(spell));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static ArrowBodyCountChangeEvent callArrowBodyCountChangeEvent(LivingEntity entity, int oldAmount, int newAmount, boolean isReset) {
        org.bukkit.entity.LivingEntity bukkitEntity = (org.bukkit.entity.LivingEntity)entity.getBukkitEntity();
        ArrowBodyCountChangeEvent event = new ArrowBodyCountChangeEvent(bukkitEntity, oldAmount, newAmount, isReset);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityExhaustionEvent callPlayerExhaustionEvent(Player humanEntity, EntityExhaustionEvent.ExhaustionReason exhaustionReason, float exhaustion) {
        EntityExhaustionEvent event = new EntityExhaustionEvent((HumanEntity)humanEntity.getBukkitEntity(), exhaustionReason, exhaustion);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PiglinBarterEvent callPiglinBarterEvent(Piglin piglin, List<net.minecraft.world.item.ItemStack> outcome, net.minecraft.world.item.ItemStack input) {
        PiglinBarterEvent event = new PiglinBarterEvent((org.bukkit.entity.Piglin)piglin.getBukkitEntity(), CraftItemStack.asBukkitCopy(input), outcome.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callEntitiesLoadEvent(Level world, ChunkPos coords, List<net.minecraft.world.entity.Entity> entities) {
        List bukkitEntities = Collections.unmodifiableList(entities.stream().map(net.minecraft.world.entity.Entity::getBukkitEntity).collect(Collectors.toList()));
        EntitiesLoadEvent event = new EntitiesLoadEvent((Chunk)new CraftChunk((ServerLevel)world, coords.x, coords.z), bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callEntitiesUnloadEvent(Level world, ChunkPos coords, List<net.minecraft.world.entity.Entity> entities) {
        List bukkitEntities = Collections.unmodifiableList(entities.stream().map(net.minecraft.world.entity.Entity::getBukkitEntity).collect(Collectors.toList()));
        EntitiesUnloadEvent event = new EntitiesUnloadEvent((Chunk)new CraftChunk((ServerLevel)world, coords.x, coords.z), bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static boolean callTNTPrimeEvent(Level world, BlockPos pos, TNTPrimeEvent.PrimeCause cause, net.minecraft.world.entity.Entity causingEntity, BlockPos causePosition) {
        CraftEntity bukkitEntity = causingEntity == null ? null : causingEntity.getBukkitEntity();
        CraftBlock bukkitBlock = causePosition == null ? null : CraftBlock.at(world, causePosition);
        TNTPrimeEvent event = new TNTPrimeEvent((Block)CraftBlock.at(world, pos), cause, (Entity)bukkitEntity, (Block)bukkitBlock);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PlayerRecipeBookClickEvent callRecipeBookClickEvent(ServerPlayer player, Recipe recipe, boolean shiftClick) {
        PlayerRecipeBookClickEvent event = new PlayerRecipeBookClickEvent((org.bukkit.entity.Player)player.getBukkitEntity(), recipe, shiftClick);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTeleportEvent callEntityTeleportEvent(net.minecraft.world.entity.Entity nmsEntity, double x, double y, double z) {
        CraftEntity entity = nmsEntity.getBukkitEntity();
        Location to = new Location(entity.getWorld(), x, y, z, nmsEntity.getYRot(), nmsEntity.getXRot());
        return CraftEventFactory.callEntityTeleportEvent(nmsEntity, to);
    }

    public static EntityTeleportEvent callEntityTeleportEvent(net.minecraft.world.entity.Entity nmsEntity, Location to) {
        CraftEntity entity = nmsEntity.getBukkitEntity();
        EntityTeleportEvent event = new EntityTeleportEvent((Entity)entity, entity.getLocation(), to);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    @Nullable
    public static PortalEventResult handlePortalEvents(net.minecraft.world.entity.Entity entity, Location to, PortalType type, int searchRadius, int createRadius) {
        PortalEventResult result;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerTeleportEvent.TeleportCause cause = switch (type) {
                default -> throw new MatchException(null, null);
                case PortalType.ENDER -> PlayerTeleportEvent.TeleportCause.END_PORTAL;
                case PortalType.NETHER -> PlayerTeleportEvent.TeleportCause.NETHER_PORTAL;
                case PortalType.END_GATEWAY -> PlayerTeleportEvent.TeleportCause.END_GATEWAY;
                case PortalType.CUSTOM -> PlayerTeleportEvent.TeleportCause.PLUGIN;
            };
            result = CraftEventFactory.callPlayerPortalEvent(player, to, cause, searchRadius, createRadius);
        } else {
            result = CraftEventFactory.callEntityPortalEvent(entity, to, type, searchRadius, createRadius);
        }
        return result;
    }

    @Nullable
    public static PortalEventResult callPlayerPortalEvent(ServerPlayer player, Location to, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int createRadius) {
        CraftPlayer bukkitPlayer = player.getBukkitEntity();
        Location from = bukkitPlayer.getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((org.bukkit.entity.Player)bukkitPlayer, from, to, cause, searchRadius, true, createRadius);
        event.callEvent();
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !player.isAlive()) {
            return null;
        }
        return new PortalEventResult(event.getTo(), event.getSearchRadius(), event.getCreationRadius(), event.getCanCreatePortal());
    }

    @Nullable
    public static PortalEventResult callEntityPortalEvent(net.minecraft.world.entity.Entity entity, Location to, PortalType type, int searchRadius, int createRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location from = bukkitEntity.getLocation();
        EntityPortalEvent event = new EntityPortalEvent((Entity)bukkitEntity, from, to, searchRadius, true, createRadius, type);
        event.callEvent();
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.isAlive()) {
            return null;
        }
        return new PortalEventResult(event.getTo(), event.getSearchRadius(), event.getCreationRadius(), event.getCanCreatePortal());
    }

    public static boolean callEntityInteractEvent(net.minecraft.world.entity.Entity nmsEntity, Block block) {
        EntityInteractEvent event = new EntityInteractEvent((Entity)nmsEntity.getBukkitEntity(), block);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static EntityExplodeEvent callEntityExplodeEvent(net.minecraft.world.entity.Entity entity, List<Block> blocks, float yield, Explosion.BlockInteraction effect) {
        EntityExplodeEvent event = new EntityExplodeEvent((Entity)entity.getBukkitEntity(), entity.getBukkitEntity().getLocation(), blocks, yield, CraftExplosionResult.toExplosionResult(effect));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockExplodeEvent callBlockExplodeEvent(Block block, BlockState state, List<Block> blocks, float yield, Explosion.BlockInteraction effect) {
        BlockExplodeEvent event = new BlockExplodeEvent(block, state, blocks, yield, CraftExplosionResult.toExplosionResult(effect));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExplosionPrimeEvent callExplosionPrimeEvent(Explosive explosive) {
        ExplosionPrimeEvent event = new ExplosionPrimeEvent(explosive);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExplosionPrimeEvent callExplosionPrimeEvent(net.minecraft.world.entity.Entity nmsEntity, float size, boolean fire) {
        ExplosionPrimeEvent event = new ExplosionPrimeEvent((Entity)nmsEntity.getBukkitEntity(), size, fire);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static io.papermc.paper.event.entity.EntityKnockbackEvent callEntityKnockbackEvent(CraftLivingEntity entity, net.minecraft.world.entity.Entity pusher, net.minecraft.world.entity.Entity attacker, EntityKnockbackEvent.Cause cause, double force, Vec3 knockback) {
        Vector apiKnockback = CraftVector.toBukkit(knockback);
        Vector currentVelocity = entity.getVelocity();
        Vector legacyFinalKnockback = currentVelocity.clone().add(apiKnockback);
        EntityKnockbackEvent.KnockbackCause legacyCause = EntityKnockbackEvent.KnockbackCause.valueOf((String)cause.name());
        Object legacyEvent = pusher != null ? new org.bukkit.event.entity.EntityKnockbackByEntityEvent((org.bukkit.entity.LivingEntity)entity, (Entity)pusher.getBukkitEntity(), legacyCause, force, apiKnockback, legacyFinalKnockback) : new EntityKnockbackEvent((org.bukkit.entity.LivingEntity)entity, legacyCause, force, apiKnockback, legacyFinalKnockback);
        legacyEvent.callEvent();
        apiKnockback = legacyEvent.getFinalKnockback().subtract(currentVelocity);
        Object event = attacker != null ? new EntityKnockbackByEntityEvent((org.bukkit.entity.LivingEntity)entity, (Entity)attacker.getBukkitEntity(), cause, (float)force, apiKnockback) : new io.papermc.paper.event.entity.EntityKnockbackEvent((Entity)entity, cause, apiKnockback);
        event.setCancelled(legacyEvent.isCancelled());
        event.callEvent();
        return event;
    }

    public static void callEntityRemoveEvent(net.minecraft.world.entity.Entity entity, EntityRemoveEvent.Cause cause) {
        if (entity instanceof ServerPlayer) {
            return;
        }
        if (cause == null) {
            return;
        }
        if (entity.generation) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityRemoveEvent((Entity)entity.getBukkitEntity(), cause));
    }

    public static void callPlayerUseUnknownEntityEvent(Player player, ServerboundInteractPacket packet, InteractionHand hand, @Nullable Vec3 vector) {
        new PlayerUseUnknownEntityEvent((org.bukkit.entity.Player)player.getBukkitEntity(), packet.getEntityId(), packet.isAttack(), CraftEquipmentSlot.getHand(hand), vector != null ? CraftVector.toBukkit(vector) : null).callEvent();
    }

    public static net.minecraft.world.item.ItemStack handleWitchReadyPotionEvent(net.minecraft.world.entity.monster.Witch witch, @Nullable net.minecraft.world.item.ItemStack potion) {
        WitchReadyPotionEvent event = new WitchReadyPotionEvent((Witch)witch.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(potion));
        if (!event.callEvent() || event.getPotion() == null) {
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        return CraftItemStack.asNMSCopy(event.getPotion());
    }

    public static boolean handleBlockFailedDispenseEvent(ServerLevel serverLevel, BlockPos pos) {
        CraftBlock block = CraftBlock.at(serverLevel, pos);
        BlockFailedDispenseEvent event = new BlockFailedDispenseEvent((Block)block);
        return event.callEvent();
    }

    public static boolean handleBlockPreDispenseEvent(ServerLevel serverLevel, BlockPos pos, net.minecraft.world.item.ItemStack itemStack, int slot) {
        CraftBlock block = CraftBlock.at(serverLevel, pos);
        BlockPreDispenseEvent event = new BlockPreDispenseEvent((Block)block, (ItemStack)CraftItemStack.asCraftMirror(itemStack), slot);
        return event.callEvent();
    }

    @Nullable
    public static net.minecraft.world.item.ItemStack handleBlockDispenseEvent(BlockSource pointer, BlockPos to, net.minecraft.world.item.ItemStack itemStack, DispenseItemBehavior instance) {
        net.minecraft.world.item.ItemStack eventStack;
        DispenseItemBehavior itemBehavior;
        CraftItemStack craftItem;
        CraftBlock bukkitBlock = CraftBlock.at(pointer.level(), pointer.pos());
        BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (ItemStack)(craftItem = CraftItemStack.asCraftMirror(itemStack.isDamageableItem() ? itemStack : itemStack.copyWithCount(1))).clone(), CraftVector.toBukkit(to));
        if (!event.callEvent()) {
            return itemStack;
        }
        if (!event.getItem().equals((Object)craftItem) && (itemBehavior = DispenserBlock.getDispenseBehavior(pointer, eventStack = CraftItemStack.asNMSCopy(event.getItem()))) != DispenseItemBehavior.NOOP && itemBehavior != instance) {
            itemBehavior.dispense(pointer, eventStack);
            return itemStack;
        }
        return null;
    }

    public static EntityFertilizeEggEvent callEntityFertilizeEggEvent(Animal breeding, Animal partner) {
        ServerPlayer serverPlayer = breeding.getLoveCause();
        if (serverPlayer == null) {
            serverPlayer = partner.getLoveCause();
        }
        int experience = breeding.getRandom().nextInt(7) + 1;
        EntityFertilizeEggEvent event = new EntityFertilizeEggEvent((org.bukkit.entity.LivingEntity)breeding.getBukkitEntity(), (org.bukkit.entity.LivingEntity)partner.getBukkitEntity(), (org.bukkit.entity.Player)(serverPlayer == null ? null : serverPlayer.getBukkitEntity()), breeding.breedItem == null ? null : CraftItemStack.asCraftMirror(breeding.breedItem).clone(), experience);
        if (!event.callEvent()) {
            breeding.resetLove();
            partner.resetLove();
        }
        return event;
    }

    public static net.minecraft.network.chat.Component handleLoginResult(PlayerList.LoginResult result, PlayerConnection paperConnection, Connection connection, GameProfile profile, MinecraftServer server, boolean loginPhase) {
        PlayerConnectionValidateLoginEvent event = new PlayerConnectionValidateLoginEvent(paperConnection, result.isAllowed() ? null : PaperAdventure.asAdventure(result.message()));
        event.callEvent();
        net.minecraft.network.chat.Component disconnectReason = PaperAdventure.asVanilla(event.getKickMessage());
        if (loginPhase) {
            disconnectReason = HorriblePlayerLoginEventHack.execute(connection, server, profile, disconnectReason == null ? PlayerList.LoginResult.ALLOW : new PlayerList.LoginResult(disconnectReason, disconnectReason == null ? PlayerLoginEvent.Result.KICK_OTHER : result.result()));
        } else if (connection.legacySavedLoginEventResultOverride != null) {
            disconnectReason = connection.legacySavedLoginEventResultOverride.orElse(null);
        }
        return disconnectReason;
    }

    public static boolean callTransporterValidateTarget(PathfinderMob mob, Level level, BlockPos transportItemTarget) {
        if (ItemTransportingEntityValidateTargetEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return true;
        }
        ItemTransportingEntityValidateTargetEvent event = new ItemTransportingEntityValidateTargetEvent((Entity)mob.getBukkitEntity(), (Block)CraftBlock.at(level, transportItemTarget));
        event.callEvent();
        return event.isAllowed();
    }

    public static <T> GameRuleSetResult<T> handleGameRuleSet(GameRule<@NotNull T> rule, T value, ServerLevel level, @Nullable CommandSender sender) {
        String valueStr = rule.serialize(value);
        PaperWorldGameRuleChangeEvent event = new PaperWorldGameRuleChangeEvent(level.getWorld(), sender, CraftGameRule.minecraftToBukkit(rule), valueStr);
        if (event.callEvent()) {
            if (!event.getValue().equals(valueStr)) {
                value = rule.deserialize(event.getValue()).getOrThrow();
            }
            level.getGameRules().set(rule, value, level);
            return new GameRuleSetResult<T>(value, false);
        }
        return new GameRuleSetResult<T>(level.getGameRules().get(rule), true);
    }

    public static boolean callBlockLockCheckEvent(BlockEntity blockEntity, LockCode code, net.minecraft.network.chat.Component displayName, Player p) {
        if (p instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)p;
            if (blockEntity != null && blockEntity.getLevel() != null && blockEntity.getLevel().getBlockEntity(blockEntity.getBlockPos()) == blockEntity) {
                CraftBlock block = CraftBlock.at(blockEntity.getLevel(), blockEntity.getBlockPos());
                TranslatableComponent lockedMessage = Component.translatable((String)"container.isLocked", (ComponentLike[])new ComponentLike[]{PaperAdventure.asAdventure(displayName)});
                net.kyori.adventure.sound.Sound lockedSound = net.kyori.adventure.sound.Sound.sound((Sound.Type)Sound.BLOCK_CHEST_LOCKED, (Sound.Source)Sound.Source.BLOCK, (float)1.0f, (float)1.0f);
                BlockLockCheckEvent event = new BlockLockCheckEvent((Block)block, (org.bukkit.entity.Player)player.getBukkitEntity(), (Component)lockedMessage, lockedSound);
                event.callEvent();
                if (event.getResult() == Event.Result.ALLOW) {
                    return true;
                }
                if (event.getResult() == Event.Result.DENY || !code.canUnlock(player, event.isUsingCustomKeyItemStack() ? CraftItemStack.asNMSCopy(event.getKeyItem()) : player.getMainHandItem())) {
                    LAST_BLOCK_LOCK_CHECK_EVENT = event;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean sendChestLockedNotifications(Vec3 pos) {
        if (LAST_BLOCK_LOCK_CHECK_EVENT != null) {
            BlockLockCheckEvent event = LAST_BLOCK_LOCK_CHECK_EVENT;
            LAST_BLOCK_LOCK_CHECK_EVENT = null;
            if (event.getLockedMessage() != null) {
                event.getPlayer().sendActionBar(event.getLockedMessage());
            }
            if (event.getLockedSound() != null) {
                event.getPlayer().getWorld().playSound(event.getLockedSound(), pos.x(), pos.y(), pos.z());
            }
            return true;
        }
        return false;
    }

    public record GameRuleSetResult<T>(T value, boolean cancelled) {
    }
}

