/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.generator.structure;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.bukkit.craftbukkit.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.generator.structure.CraftStructurePiece;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.util.BoundingBox;

public class CraftGeneratedStructure
implements GeneratedStructure {
    private final StructureStart handle;
    private List<org.bukkit.generator.structure.StructurePiece> pieces;

    public CraftGeneratedStructure(StructureStart handle) {
        this.handle = handle;
    }

    public BoundingBox getBoundingBox() {
        net.minecraft.world.level.levelgen.structure.BoundingBox box = this.handle.getBoundingBox();
        return new BoundingBox((double)box.minX(), (double)box.minY(), (double)box.minZ(), (double)box.maxX(), (double)box.maxY(), (double)box.maxZ());
    }

    public Structure getStructure() {
        return CraftStructure.minecraftToBukkit(this.handle.getStructure());
    }

    public Collection<org.bukkit.generator.structure.StructurePiece> getPieces() {
        if (this.pieces == null) {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.handle.getPieces().size());
            for (StructurePiece piece : this.handle.getPieces()) {
                builder.add((Object)new CraftStructurePiece(piece));
            }
            this.pieces = builder.build();
        }
        return this.pieces;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.handle.persistentDataContainer;
    }
}

