/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scoreboard;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.util.PaperScoreboardFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboard;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;

final class CraftScore
implements Score {
    private final ScoreHolder entry;
    private final CraftObjective objective;

    CraftScore(CraftObjective objective, ScoreHolder entry) {
        this.objective = objective;
        this.entry = entry;
    }

    public OfflinePlayer getPlayer() {
        return Bukkit.getOfflinePlayer((String)this.entry.getScoreboardName());
    }

    public String getEntry() {
        return this.entry.getScoreboardName();
    }

    public Objective getObjective() {
        return this.objective;
    }

    public int getScore() {
        this.objective.checkState();
        Scoreboard board = this.objective.getScoreboard().getHandle();
        ReadOnlyScoreInfo score = board.getPlayerScoreInfo(this.entry, this.objective.getHandle());
        if (score != null) {
            return score.value();
        }
        return 0;
    }

    public void setScore(int score) {
        this.objective.checkState();
        this.objective.getScoreboard().getHandle().getOrCreatePlayerScore(this.entry, this.objective.getHandle()).set(score);
    }

    public io.papermc.paper.scoreboard.numbers.NumberFormat numberFormat() {
        this.objective.checkState();
        ReadOnlyScoreInfo scoreInfo = this.objective.getScoreboard().getHandle().getPlayerScoreInfo(this.entry, this.objective.getHandle());
        if (scoreInfo == null) {
            return null;
        }
        NumberFormat vanilla = scoreInfo.numberFormat();
        if (vanilla == null) {
            return null;
        }
        return PaperScoreboardFormat.asPaper(vanilla);
    }

    public void numberFormat(io.papermc.paper.scoreboard.numbers.NumberFormat format) {
        this.objective.checkState();
        ScoreAccess access = this.objective.getScoreboard().getHandle().getOrCreatePlayerScore(this.entry, this.objective.getHandle());
        if (format == null) {
            access.numberFormatOverride(null);
            return;
        }
        access.numberFormatOverride(PaperScoreboardFormat.asVanilla(format));
    }

    public boolean isScoreSet() {
        this.objective.checkState();
        Scoreboard board = this.objective.getScoreboard().getHandle();
        return board.getPlayerScoreInfo(this.entry, this.objective.getHandle()) != null;
    }

    public CraftScoreboard getScoreboard() {
        return this.objective.getScoreboard();
    }

    public void resetScore() {
        this.objective.checkState();
        Scoreboard board = this.objective.getScoreboard().getHandle();
        board.resetSinglePlayerScore(this.entry, this.objective.getHandle());
    }

    public boolean isTriggerable() {
        this.objective.checkState();
        if (this.objective.getTrackedCriteria() != Criteria.TRIGGER) {
            return false;
        }
        Scoreboard board = this.objective.getScoreboard().getHandle();
        ReadOnlyScoreInfo scoreInfo = board.getPlayerScoreInfo(this.entry, this.objective.getHandle());
        return scoreInfo != null && !scoreInfo.isLocked();
    }

    public void setTriggerable(boolean triggerable) {
        Preconditions.checkArgument((this.objective.getTrackedCriteria() == Criteria.TRIGGER ? 1 : 0) != 0, (Object)"the criteria isn't 'trigger'");
        this.objective.checkState();
        Scoreboard board = this.objective.getScoreboard().getHandle();
        if (triggerable) {
            board.getOrCreatePlayerScore(this.entry, this.objective.getHandle()).unlock();
        } else {
            board.getOrCreatePlayerScore(this.entry, this.objective.getHandle()).lock();
        }
    }

    public net.kyori.adventure.text.Component customName() {
        this.objective.checkState();
        Scoreboard board = this.objective.getScoreboard().getHandle();
        ReadOnlyScoreInfo scoreInfo = board.getPlayerScoreInfo(this.entry, this.objective.getHandle());
        if (scoreInfo == null) {
            return null;
        }
        Component display = board.getOrCreatePlayerScore(this.entry, this.objective.getHandle()).display();
        return display == null ? null : PaperAdventure.asAdventure(display);
    }

    public void customName(net.kyori.adventure.text.Component customName) {
        this.objective.checkState();
        Scoreboard board = this.objective.getScoreboard().getHandle();
        board.getOrCreatePlayerScore(this.entry, this.objective.getHandle()).display(PaperAdventure.asVanilla(customName));
    }
}

