/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.painting.Painting;
import net.minecraft.world.entity.item.ItemEntity;
import org.spigotmc.SpigotWorldConfig;

public final class TrackingRange {
    private TrackingRange() {
    }

    public static int getEntityTrackingRange(Entity entity, int defaultRange) {
        if (defaultRange == 0) {
            return defaultRange;
        }
        SpigotWorldConfig config = entity.level().spigotConfig;
        if (entity instanceof ServerPlayer) {
            return config.playerTrackingRange;
        }
        if (entity instanceof EnderDragon) {
            return ((ServerLevel)entity.level()).getChunkSource().chunkMap.serverViewDistance << 4;
        }
        switch (entity.activationType) {
            case RAIDER: 
            case MONSTER: 
            case FLYING_MONSTER: {
                return config.monsterTrackingRange;
            }
            case WATER: 
            case VILLAGER: 
            case ANIMAL: {
                return config.animalTrackingRange;
            }
        }
        if (entity instanceof ItemFrame || entity instanceof Painting || entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
            return config.miscTrackingRange;
        }
        if (entity instanceof Display) {
            return config.displayTrackingRange;
        }
        return config.otherTrackingRange;
    }
}

