/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.attributes;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.util.NamespaceUtil;
import java.util.function.DoubleUnaryOperator;

public final class ConverterEntityAttributesBaseValueUpdater
extends DataConverter<MapType<String>, MapType<String>> {
    private final String targetId;
    private final DoubleUnaryOperator updater;

    public ConverterEntityAttributesBaseValueUpdater(int toVersion, String targetId, DoubleUnaryOperator updater) {
        this(toVersion, 0, targetId, updater);
    }

    public ConverterEntityAttributesBaseValueUpdater(int toVersion, int versionStep, String targetId, DoubleUnaryOperator updater) {
        super(toVersion, versionStep);
        this.targetId = targetId;
        this.updater = updater;
    }

    @Override
    public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
        ListType modifiers = data.getList("attributes", ObjectType.MAP);
        if (modifiers == null) {
            return null;
        }
        int len = modifiers.size();
        for (int i = 0; i < len; ++i) {
            MapType modifier = modifiers.getMap(i);
            if (!this.targetId.equals(NamespaceUtil.correctNamespace(modifier.getString("id", "")))) continue;
            modifier.setDouble("base", this.updater.applyAsDouble(modifier.getDouble("base", 0.0)));
        }
        return null;
    }
}

