/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V1918 {
    private static final int VERSION = 1918;

    private static String getProfessionString(int professionId, int careerId) {
        if (professionId == 0) {
            if (careerId == 2) {
                return "minecraft:fisherman";
            }
            if (careerId == 3) {
                return "minecraft:shepherd";
            }
            return careerId == 4 ? "minecraft:fletcher" : "minecraft:farmer";
        }
        if (professionId == 1) {
            return careerId == 2 ? "minecraft:cartographer" : "minecraft:librarian";
        }
        if (professionId == 2) {
            return "minecraft:cleric";
        }
        if (professionId == 3) {
            if (careerId == 2) {
                return "minecraft:weaponsmith";
            }
            return careerId == 3 ? "minecraft:toolsmith" : "minecraft:armorer";
        }
        if (professionId == 4) {
            return careerId == 2 ? "minecraft:leatherworker" : "minecraft:butcher";
        }
        return professionId == 5 ? "minecraft:nitwit" : "minecraft:none";
    }

    public static void register() {
        DataConverter<MapType<String>, MapType<String>> converter = new DataConverter<MapType<String>, MapType<String>>(1918){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                int profession = data.getInt("Profession");
                int career = data.getInt("Career");
                int careerLevel = data.getInt("CareerLevel", 1);
                data.remove("Profession");
                data.remove("Career");
                data.remove("CareerLevel");
                MapType<String> villagerData = Types.NBT.createEmptyMap();
                data.setMap("VillagerData", villagerData);
                villagerData.setString("type", "minecraft:plains");
                villagerData.setString("profession", V1918.getProfessionString(profession, career));
                villagerData.setInt("level", careerLevel);
                return null;
            }
        };
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:villager", converter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:zombie_villager", converter);
    }

    private V1918() {
    }
}

