/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.paper.util;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.util.ChunkSystemHooks;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public abstract class BaseChunkSystemHooks
implements ChunkSystemHooks {
    @Override
    public void scheduleChunkTask(ServerLevel level, int chunkX, int chunkZ, Runnable run) {
        this.scheduleChunkTask(level, chunkX, chunkZ, run, Priority.NORMAL);
    }

    @Override
    public void scheduleChunkTask(ServerLevel level, int chunkX, int chunkZ, Runnable run, Priority priority) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkTask(chunkX, chunkZ, run, priority);
    }

    @Override
    public void scheduleChunkLoad(ServerLevel level, int chunkX, int chunkZ, boolean gen, ChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<ChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, gen, toStatus, addTicket, priority, onComplete);
    }

    @Override
    public void scheduleChunkLoad(ServerLevel level, int chunkX, int chunkZ, ChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<ChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    @Override
    public void scheduleTickingState(ServerLevel level, int chunkX, int chunkZ, FullChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<LevelChunk> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    @Override
    public List<ChunkHolder> getVisibleChunkHolders(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    @Override
    public List<ChunkHolder> getUpdatingChunkHolders(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    @Override
    public int getVisibleChunkHolderCount(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    @Override
    public int getUpdatingChunkHolderCount(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    @Override
    public boolean hasAnyChunkHolders(ServerLevel level) {
        return this.getUpdatingChunkHolderCount(level) != 0;
    }

    @Override
    public void onChunkHolderCreate(ServerLevel level, ChunkHolder holder) {
    }

    @Override
    public void onChunkHolderDelete(ServerLevel level, ChunkHolder holder) {
        ChunkProgressListener progressListener = level.getChunkSource().chunkMap.progressListener;
        if (progressListener != null) {
            this.scheduleChunkTask(level, holder.getPos().x, holder.getPos().z, () -> progressListener.onStatusChange(holder.getPos(), null));
        }
    }

    @Override
    public void onChunkPreBorder(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).getChunkSource().moonrise$setFullChunk(chunk.getPos().x, chunk.getPos().z, chunk);
    }

    @Override
    public void onChunkBorder(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getLoadedChunks().add(chunk.moonrise$getChunkAndHolder());
        chunk.loadCallback();
    }

    @Override
    public void onChunkNotBorder(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getLoadedChunks().remove(chunk.moonrise$getChunkAndHolder());
        chunk.unloadCallback();
    }

    @Override
    public void onChunkPostNotBorder(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).getChunkSource().moonrise$setFullChunk(chunk.getPos().x, chunk.getPos().z, null);
    }

    @Override
    public void onChunkTicking(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getTickingChunks().add(chunk.moonrise$getChunkAndHolder());
        if (!chunk.moonrise$isPostProcessingDone()) {
            chunk.postProcessGeneration((ServerLevel)chunk.getLevel());
        }
        ((ServerLevel)chunk.getLevel()).startTickingChunk(chunk);
        ((ServerLevel)chunk.getLevel()).getChunkSource().chunkMap.tickingGenerated.incrementAndGet();
        ((ServerLevel)chunk.getLevel()).moonrise$markChunkForPlayerTicking(chunk);
    }

    @Override
    public void onChunkNotTicking(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getTickingChunks().remove(chunk.moonrise$getChunkAndHolder());
        ((ServerLevel)chunk.getLevel()).moonrise$removeChunkForPlayerTicking(chunk);
    }

    @Override
    public void onChunkEntityTicking(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getEntityTickingChunks().add(chunk.moonrise$getChunkAndHolder());
    }

    @Override
    public void onChunkNotEntityTicking(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).moonrise$getEntityTickingChunks().remove(chunk.moonrise$getChunkAndHolder());
    }

    @Override
    public ChunkHolder getUnloadingChunkHolder(ServerLevel level, int chunkX, int chunkZ) {
        return null;
    }

    @Override
    public int getSendViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getAPISendViewDistance(player);
    }

    @Override
    public int getViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getAPIViewDistance(player);
    }

    @Override
    public int getTickViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getAPITickViewDistance(player);
    }

    @Override
    public void addPlayerToDistanceMaps(ServerLevel world, ServerPlayer player) {
        world.moonrise$getPlayerChunkLoader().addPlayer(player);
    }

    @Override
    public void removePlayerFromDistanceMaps(ServerLevel world, ServerPlayer player) {
        world.moonrise$getPlayerChunkLoader().removePlayer(player);
    }

    @Override
    public void updateMaps(ServerLevel world, ServerPlayer player) {
        world.moonrise$getPlayerChunkLoader().updatePlayer(player);
    }
}

