/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.fixes.References;

public final class ChunkSystemConverters {
    private static final int DEFAULT_POI_DATA_VERSION = 1945;
    private static final int DEFAULT_ENTITY_CHUNK_DATA_VERSION = -1;

    private static int getCurrentVersion() {
        return SharedConstants.getCurrentVersion().getDataVersion().getVersion();
    }

    private static int getDataVersion(CompoundTag data, int dfl) {
        return !data.contains("DataVersion", 99) ? dfl : data.getInt("DataVersion");
    }

    public static CompoundTag convertPoiCompoundTag(CompoundTag data, ServerLevel world) {
        int dataVersion = ChunkSystemConverters.getDataVersion(data, 1945);
        return PlatformHooks.get().convertNBT(References.POI_CHUNK, world.getServer().getFixerUpper(), data, dataVersion, ChunkSystemConverters.getCurrentVersion());
    }

    public static CompoundTag convertEntityChunkCompoundTag(CompoundTag data, ServerLevel world) {
        int dataVersion = ChunkSystemConverters.getDataVersion(data, -1);
        return PlatformHooks.get().convertNBT(References.ENTITY_CHUNK, world.getServer().getFixerUpper(), data, dataVersion, ChunkSystemConverters.getCurrentVersion());
    }

    private ChunkSystemConverters() {
    }
}

