/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller;

import ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

public final class EntityDataController
extends MoonriseRegionFileIO.RegionDataController {
    private final EntityRegionFileStorage storage;

    public EntityDataController(EntityRegionFileStorage storage, ChunkTaskScheduler taskScheduler) {
        super(MoonriseRegionFileIO.RegionFileType.ENTITY_DATA, (PrioritisedExecutor)taskScheduler.ioExecutor, (PrioritisedExecutor)taskScheduler.compressionExecutor);
        this.storage = storage;
    }

    @Override
    public RegionFileStorage getCache() {
        return this.storage;
    }

    @Override
    public MoonriseRegionFileIO.RegionDataController.WriteData startWrite(int chunkX, int chunkZ, CompoundTag compound) throws IOException {
        EntityDataController.checkPosition(new ChunkPos(chunkX, chunkZ), compound);
        return this.getCache().moonrise$startWrite(chunkX, chunkZ, compound);
    }

    @Override
    public void finishWrite(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.WriteData writeData) throws IOException {
        this.getCache().moonrise$finishWrite(chunkX, chunkZ, writeData);
    }

    @Override
    public MoonriseRegionFileIO.RegionDataController.ReadData readData(int chunkX, int chunkZ) throws IOException {
        return this.getCache().moonrise$readData(chunkX, chunkZ);
    }

    @Override
    public CompoundTag finishRead(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.ReadData readData) throws IOException {
        return this.getCache().moonrise$finishRead(chunkX, chunkZ, readData);
    }

    private static void checkPosition(ChunkPos pos, CompoundTag nbt) {
        ChunkPos nbtPos;
        ChunkPos chunkPos = nbtPos = nbt == null ? null : EntityStorage.readChunkPos(nbt);
        if (nbtPos != null && !pos.equals(nbtPos)) {
            throw new IllegalArgumentException("Entity chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + pos.toString() + " but compound says coordinate is " + String.valueOf(nbtPos));
        }
    }

    public static final class EntityRegionFileStorage
    extends RegionFileStorage {
        public EntityRegionFileStorage(RegionStorageInfo regionStorageInfo, Path directory, boolean dsync) {
            super(regionStorageInfo, directory, dsync);
        }

        @Override
        public void write(ChunkPos pos, CompoundTag nbt) throws IOException {
            EntityDataController.checkPosition(pos, nbt);
            super.write(pos, nbt);
        }
    }
}

