/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.ai;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import com.destroystokyo.paper.entity.ai.MobGoalHelper;
import com.destroystokyo.paper.entity.ai.MobGoals;
import com.destroystokyo.paper.entity.ai.PaperCustomGoal;
import com.destroystokyo.paper.entity.ai.PaperVanillaGoal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import org.bukkit.craftbukkit.entity.CraftMob;
import org.bukkit.entity.Mob;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperMobGoals
implements MobGoals {
    public <T extends Mob> void addGoal(T mob, int priority, Goal<T> goal) {
        net.minecraft.world.entity.ai.goal.Goal mojangGoal;
        CraftMob craftMob = (CraftMob)mob;
        if (goal instanceof PaperVanillaGoal) {
            PaperVanillaGoal vanillaGoal = (PaperVanillaGoal)goal;
            mojangGoal = vanillaGoal.getHandle();
        } else {
            mojangGoal = new PaperCustomGoal<T>(goal);
        }
        this.getHandle(craftMob, goal.getTypes()).addGoal(priority, mojangGoal);
    }

    public <T extends Mob> void removeGoal(T mob, Goal<T> goal) {
        CraftMob craftMob = (CraftMob)mob;
        if (goal instanceof PaperCustomGoal) {
            this.getHandle(craftMob, goal.getTypes()).removeGoal((net.minecraft.world.entity.ai.goal.Goal)goal);
        } else if (goal instanceof PaperVanillaGoal) {
            this.getHandle(craftMob, goal.getTypes()).removeGoal(((PaperVanillaGoal)goal).getHandle());
        } else {
            LinkedList<net.minecraft.world.entity.ai.goal.Goal> toRemove = new LinkedList<net.minecraft.world.entity.ai.goal.Goal>();
            for (WrappedGoal item : this.getHandle(craftMob, goal.getTypes()).getAvailableGoals()) {
                if (!(item.getGoal() instanceof PaperCustomGoal) || ((PaperCustomGoal)item.getGoal()).getHandle() != goal) continue;
                toRemove.add(item.getGoal());
            }
            for (net.minecraft.world.entity.ai.goal.Goal g : toRemove) {
                this.getHandle(craftMob, goal.getTypes()).removeGoal(g);
            }
        }
    }

    public <T extends Mob> void removeAllGoals(T mob) {
        for (GoalType type : GoalType.values()) {
            this.removeAllGoals(mob, type);
        }
    }

    public <T extends Mob> void removeAllGoals(T mob, GoalType type) {
        for (Goal<T> goal : this.getAllGoals(mob, type)) {
            this.removeGoal(mob, goal);
        }
    }

    public <T extends Mob> void removeGoal(T mob, GoalKey<T> key) {
        for (Goal<T> goal : this.getGoals(mob, key)) {
            this.removeGoal(mob, goal);
        }
    }

    public <T extends Mob> boolean hasGoal(T mob, GoalKey<T> key) {
        for (Goal<T> g : this.getAllGoals(mob)) {
            if (!g.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public <T extends Mob> Goal<T> getGoal(T mob, GoalKey<T> key) {
        for (Goal<T> g : this.getAllGoals(mob)) {
            if (!g.getKey().equals(key)) continue;
            return g;
        }
        return null;
    }

    public <T extends Mob> Collection<Goal<T>> getGoals(T mob, GoalKey<T> key) {
        HashSet<Goal<T>> goals = new HashSet<Goal<T>>();
        for (Goal<T> g : this.getAllGoals(mob)) {
            if (!g.getKey().equals(key)) continue;
            goals.add(g);
        }
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getAllGoals(T mob) {
        HashSet<Goal<T>> goals = new HashSet<Goal<T>>();
        for (GoalType type : GoalType.values()) {
            goals.addAll(this.getAllGoals(mob, type));
        }
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getAllGoals(T mob, GoalType type) {
        CraftMob craftMob = (CraftMob)mob;
        HashSet<Goal<T>> goals = new HashSet<Goal<T>>();
        for (WrappedGoal item : this.getHandle(craftMob, type).getAvailableGoals()) {
            if (!item.getGoal().hasFlag(MobGoalHelper.paperToVanilla(type))) continue;
            if (item.getGoal() instanceof PaperCustomGoal) {
                goals.add(((PaperCustomGoal)item.getGoal()).getHandle());
                continue;
            }
            goals.add(item.getGoal().asPaperVanillaGoal());
        }
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getAllGoalsWithout(T mob, GoalType type) {
        CraftMob craftMob = (CraftMob)mob;
        HashSet<Goal<T>> goals = new HashSet<Goal<T>>();
        for (GoalType internalType : GoalType.values()) {
            if (internalType == type) continue;
            for (WrappedGoal item : this.getHandle(craftMob, internalType).getAvailableGoals()) {
                if (item.getGoal().hasFlag(MobGoalHelper.paperToVanilla(type))) continue;
                if (item.getGoal() instanceof PaperCustomGoal) {
                    goals.add(((PaperCustomGoal)item.getGoal()).getHandle());
                    continue;
                }
                goals.add(item.getGoal().asPaperVanillaGoal());
            }
        }
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getRunningGoals(T mob) {
        HashSet<Goal<T>> goals = new HashSet<Goal<T>>();
        for (GoalType type : GoalType.values()) {
            goals.addAll(this.getRunningGoals(mob, type));
        }
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getRunningGoals(T mob, GoalType type) {
        CraftMob craftMob = (CraftMob)mob;
        HashSet goals = new HashSet();
        this.getHandle(craftMob, type).getAvailableGoals().stream().filter(WrappedGoal::isRunning).filter(item -> item.getGoal().hasFlag(MobGoalHelper.paperToVanilla(type))).forEach(item -> {
            if (item.getGoal() instanceof PaperCustomGoal) {
                goals.add(((PaperCustomGoal)item.getGoal()).getHandle());
            } else {
                goals.add(item.getGoal().asPaperVanillaGoal());
            }
        });
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getRunningGoalsWithout(T mob, GoalType type) {
        CraftMob craftMob = (CraftMob)mob;
        HashSet goals = new HashSet();
        for (GoalType internalType : GoalType.values()) {
            if (internalType == type) continue;
            this.getHandle(craftMob, internalType).getAvailableGoals().stream().filter(WrappedGoal::isRunning).filter(item -> !item.getGoal().hasFlag(MobGoalHelper.paperToVanilla(type))).forEach(item -> {
                if (item.getGoal() instanceof PaperCustomGoal) {
                    goals.add(((PaperCustomGoal)item.getGoal()).getHandle());
                } else {
                    goals.add(item.getGoal().asPaperVanillaGoal());
                }
            });
        }
        return goals;
    }

    private GoalSelector getHandle(CraftMob mob, EnumSet<GoalType> types) {
        if (types.contains(GoalType.TARGET)) {
            return mob.getHandle().targetSelector;
        }
        return mob.getHandle().goalSelector;
    }

    private GoalSelector getHandle(CraftMob mob, GoalType type) {
        if (type == GoalType.TARGET) {
            return mob.getHandle().targetSelector;
        }
        return mob.getHandle().goalSelector;
    }
}

