/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@FunctionalInterface
public interface Axis {
    public static final Axis XN = radians -> new Quaternionf().rotationX(-radians);
    public static final Axis XP = radians -> new Quaternionf().rotationX(radians);
    public static final Axis YN = radians -> new Quaternionf().rotationY(-radians);
    public static final Axis YP = radians -> new Quaternionf().rotationY(radians);
    public static final Axis ZN = radians -> new Quaternionf().rotationZ(-radians);
    public static final Axis ZP = radians -> new Quaternionf().rotationZ(radians);

    public static Axis of(Vector3f axis) {
        return radians -> new Quaternionf().rotationAxis(radians, (Vector3fc)axis);
    }

    public Quaternionf rotation(float var1);

    default public Quaternionf rotationDegrees(float degrees) {
        return this.rotation(degrees * ((float)Math.PI / 180));
    }
}

